/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.containers.EJBTimerSchedule;
import com.sun.ejb.containers.TimerBean;
import com.sun.ejb.containers.TimerPrimaryKey;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import javax.persistence.Transient;

@Entity(name="Timer")
@NamedQueries(value={@NamedQuery(name="findTimerIdsByContainer", query="SELECT t.timerId FROM Timer t WHERE t.containerId = ?1"), @NamedQuery(name="findTimerIdsByContainerAndState", query="SELECT t.timerId FROM Timer t WHERE t.containerId = ?1 AND t.state=?2"), @NamedQuery(name="findTimerIdsByContainerAndOwner", query="SELECT t.timerId FROM Timer t WHERE t.containerId = ?1 AND t.ownerId=?2"), @NamedQuery(name="findTimerIdsByContainerAndOwnerAndState", query="SELECT t.timerId FROM Timer t WHERE t.containerId = ?1 AND t.ownerId=?2 AND t.state=?3"), @NamedQuery(name="findTimerIdsByOwner", query="SELECT t.timerId FROM Timer t WHERE t.ownerId = ?1"), @NamedQuery(name="findTimerIdsByOwnerAndState", query="SELECT t.timerId FROM Timer t WHERE t.ownerId = ?1 AND t.state=?2"), @NamedQuery(name="findTimersByContainer", query="SELECT t FROM Timer t WHERE t.containerId = ?1"), @NamedQuery(name="findTimersByContainerAndState", query="SELECT t FROM Timer t WHERE t.containerId = ?1 AND t.state=?2"), @NamedQuery(name="findTimersByContainerAndOwner", query="SELECT t FROM Timer t WHERE t.containerId = ?1 AND t.ownerId=?2"), @NamedQuery(name="findTimersByContainerAndOwnerAndState", query="SELECT t FROM Timer t WHERE t.containerId = ?1 AND t.ownerId=?2 AND t.state=?3"), @NamedQuery(name="findTimersByOwner", query="SELECT t FROM Timer t WHERE t.ownerId = ?1 ORDER BY t.timerId"), @NamedQuery(name="findTimersByOwnerAndState", query="SELECT t FROM Timer t WHERE t.ownerId = ?1 AND t.state=?2"), @NamedQuery(name="countTimersByApplication", query="SELECT COUNT(t) FROM Timer t WHERE t.applicationId = ?1"), @NamedQuery(name="countTimersByOwner", query="SELECT COUNT(t) FROM Timer t WHERE t.ownerId = ?1"), @NamedQuery(name="countTimersByOwnerAndState", query="SELECT COUNT(t) FROM Timer t WHERE t.ownerId = ?1 AND t.state=?2"), @NamedQuery(name="countTimersByContainer", query="SELECT COUNT(t) FROM Timer t WHERE t.containerId = ?1"), @NamedQuery(name="countTimersByContainerAndState", query="SELECT COUNT(t) FROM Timer t WHERE t.containerId = ?1 AND t.state=?2"), @NamedQuery(name="countTimersByContainerAndOwner", query="SELECT COUNT(t) FROM Timer t WHERE t.containerId = ?1 AND t.ownerId=?2"), @NamedQuery(name="countTimersByContainerAndOwnerAndState", query="SELECT COUNT(t) FROM Timer t WHERE t.containerId = ?1 AND t.ownerId=?2 AND t.state=?3"), @NamedQuery(name="updateTimersFromOwnerToNewOwner", query="UPDATE Timer t SET t.ownerId = :toOwner WHERE t.ownerId = :fromOwner"), @NamedQuery(name="deleteTimersByContainer", query="DELETE FROM Timer t WHERE t.containerId = :containerId"), @NamedQuery(name="deleteTimersByApplication", query="DELETE FROM Timer t WHERE t.applicationId = :applicationId")})
@Table(name="EJB__TIMER__TBL")
@IdClass(value=TimerPrimaryKey.class)
public class TimerState
implements Serializable {
    public static final int ACTIVE = 0;
    public static final int CANCELLED = 1;
    @Id
    @Column(name="TIMERID")
    private String timerId;
    @Column(name="CREATIONTIMERAW")
    private long creationTimeRaw;
    @Column(name="INITIALEXPIRATIONRAW")
    private long initialExpirationRaw;
    @Column(name="LASTEXPIRATIONRAW")
    private long lastExpirationRaw;
    @Column(name="INTERVALDURATION")
    private long intervalDuration;
    @Column(name="STATE")
    private int state;
    @Column(name="CONTAINERID")
    private long containerId;
    @Column(name="APPLICATIONID")
    private long applicationId;
    @Column(name="PKHASHCODE")
    private int pkHashCode;
    @Column(name="OWNERID")
    private String ownerId;
    @Column(name="SCHEDULE")
    private String schedule;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="BLOB")
    private Blob blob;
    @Transient
    private boolean blobLoaded_;
    private transient Object timedObjectPrimaryKey_;
    private transient Serializable info_;
    private transient Date creationTime_;
    private transient Date initialExpiration_;
    private transient Date lastExpiration_;
    private transient EJBTimerSchedule timerSchedule_;

    public String getTimerId() {
        return this.timerId;
    }

    public void setTimerId(String timerId) {
        this.timerId = timerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public long getCreationTimeRaw() {
        return this.creationTimeRaw;
    }

    public void setCreationTimeRaw(long creationTime) {
        this.creationTimeRaw = creationTime;
    }

    public long getInitialExpirationRaw() {
        return this.initialExpirationRaw;
    }

    public void setInitialExpirationRaw(long initialExpiration) {
        this.initialExpirationRaw = initialExpiration;
    }

    public long getLastExpirationRaw() {
        return this.lastExpirationRaw;
    }

    public void setLastExpirationRaw(long lastExpiration) {
        this.lastExpirationRaw = lastExpiration;
    }

    public long getIntervalDuration() {
        return this.intervalDuration;
    }

    public void setIntervalDuration(long intervalDuration) {
        this.intervalDuration = intervalDuration;
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }

    public long getContainerId() {
        return this.containerId;
    }

    public void setContainerId(long containerId) {
        this.containerId = containerId;
    }

    public long getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(long applicationId) {
        this.applicationId = applicationId;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public void setSchedule(String schedule) {
        this.schedule = schedule;
    }

    public Blob getBlob() {
        return this.blob;
    }

    public void setBlob(Blob blob) {
        this.blob = blob;
    }

    public int getPkHashCode() {
        return this.pkHashCode;
    }

    public void setPkHashCode(int pkHash) {
        this.pkHashCode = pkHash;
    }

    public EJBTimerSchedule getTimerSchedule() {
        return this.timerSchedule_;
    }

    public TimerState() {
    }

    public TimerState(String timerId, long containerId, long applicationId, String ownerId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, EJBTimerSchedule schedule, Serializable info) throws IOException {
        this.timerId = timerId;
        this.ownerId = ownerId;
        this.creationTime_ = new Date();
        this.creationTimeRaw = this.creationTime_.getTime();
        this.initialExpirationRaw = initialExpiration.getTime();
        this.initialExpiration_ = initialExpiration;
        this.lastExpirationRaw = 0L;
        this.lastExpiration_ = null;
        this.intervalDuration = intervalDuration;
        this.timerSchedule_ = schedule;
        if (this.timerSchedule_ != null) {
            this.schedule = this.timerSchedule_.getScheduleAsString();
        }
        this.containerId = containerId;
        this.applicationId = applicationId;
        this.timedObjectPrimaryKey_ = timedObjectPrimaryKey;
        this.info_ = info;
        this.blobLoaded_ = true;
        this.blob = new Blob(timedObjectPrimaryKey, info);
        this.state = 0;
    }

    public String stateToString() {
        return TimerState.stateToString(this.state);
    }

    public static String stateToString(int state) {
        String stateStr = "UNKNOWN_TIMER_STATE";
        switch (state) {
            case 0: {
                stateStr = "TIMER_ACTIVE";
                break;
            }
            case 1: {
                stateStr = "TIMER_CANCELLED";
                break;
            }
            default: {
                stateStr = "UNKNOWN_TIMER_STATE";
            }
        }
        return stateStr;
    }

    private void loadBlob(ClassLoader cl) {
        try {
            this.timedObjectPrimaryKey_ = this.blob.getTimedObjectPrimaryKey(cl);
            this.info_ = this.blob.getInfo(cl);
            this.blobLoaded_ = true;
        }
        catch (Exception e) {
            RuntimeException ex = new RuntimeException();
            ex.initCause(e);
            throw ex;
        }
    }

    @PostLoad
    public void load() {
        this.lastExpiration_ = this.lastExpirationRaw > 0L ? new Date(this.lastExpirationRaw) : null;
        this.creationTime_ = new Date(this.creationTimeRaw);
        this.initialExpiration_ = new Date(this.initialExpirationRaw);
        if (this.schedule != null) {
            this.timerSchedule_ = new EJBTimerSchedule(this.schedule);
        }
        this.timedObjectPrimaryKey_ = null;
        this.info_ = null;
        this.blobLoaded_ = false;
    }

    public boolean repeats() {
        return this.intervalDuration > 0L;
    }

    public Serializable getInfo() {
        if (!this.blobLoaded_) {
            this.loadBlob(TimerBean.getContainer(this.getContainerId()).getClassLoader());
        }
        return this.info_;
    }

    public Object getTimedObjectPrimaryKey() {
        if (!this.blobLoaded_) {
            this.loadBlob(TimerBean.getContainer(this.getContainerId()).getClassLoader());
        }
        return this.timedObjectPrimaryKey_;
    }

    public Date getCreationTime() {
        return this.creationTime_;
    }

    public Date getInitialExpiration() {
        return this.initialExpiration_;
    }

    public Date getLastExpiration() {
        return this.lastExpiration_;
    }

    public void setLastExpiration(Date lastExpiration) {
        this.lastExpiration_ = lastExpiration;
        this.lastExpirationRaw = lastExpiration != null ? lastExpiration.getTime() : 0L;
    }

    public boolean isActive() {
        return this.state == 0;
    }

    public boolean isCancelled() {
        return this.state == 1;
    }

    public static class Blob
    implements Serializable {
        private byte[] primaryKeyBytes_ = null;
        private byte[] infoBytes_ = null;
        private static final long serialVersionUID = 5022674828003386360L;

        public Blob() {
        }

        public Blob(Object primaryKey, Serializable info) throws IOException {
            if (primaryKey != null) {
                this.primaryKeyBytes_ = EJBUtils.serializeObject(primaryKey);
            }
            if (info != null) {
                this.infoBytes_ = EJBUtils.serializeObject(info);
            }
        }

        Blob(byte[] primaryKeyBytes, byte[] infoBytes) {
            this.primaryKeyBytes_ = primaryKeyBytes;
            this.infoBytes_ = infoBytes;
        }

        public Object getTimedObjectPrimaryKey(ClassLoader cl) throws Exception {
            Object pKey = null;
            if (this.primaryKeyBytes_ != null) {
                pKey = EJBUtils.deserializeObject(this.primaryKeyBytes_, cl);
            }
            return pKey;
        }

        public Serializable getInfo(ClassLoader cl) throws Exception {
            Serializable info = null;
            if (this.infoBytes_ != null) {
                info = (Serializable)EJBUtils.deserializeObject(this.infoBytes_, cl);
            }
            return info;
        }
    }
}

