/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.SessionContextImpl;
import com.sun.ejb.containers.StatefulSessionContainer;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.ha.store.api.BackingStore;
import org.glassfish.ha.store.api.BackingStoreException;
import org.glassfish.ha.store.util.SimpleMetadata;

public class SFSBTxCheckpointCoordinator {
    private static final Logger _logger = LogDomains.getLogger(SFSBTxCheckpointCoordinator.class, (String)"javax.enterprise.system.container.ejb");
    private String haStoreType;
    private ArrayList ctxList = new ArrayList();

    SFSBTxCheckpointCoordinator(String haStoreType) {
        this.haStoreType = haStoreType;
    }

    void registerContext(SessionContextImpl ctx) {
        this.ctxList.add(ctx);
    }

    void doTxCheckpoint() {
        StatefulSessionContainer container;
        SessionContextImpl ctx;
        int i;
        SessionContextImpl[] contexts = this.ctxList.toArray(new SessionContextImpl[this.ctxList.size()]);
        int size = contexts.length;
        ArrayList<StoreAndBeanState> states = new ArrayList<StoreAndBeanState>(size);
        for (i = 0; i < size; ++i) {
            ctx = contexts[i];
            container = (StatefulSessionContainer)ctx.getContainer();
            SimpleMetadata beanState = container.getSFSBBeanState(ctx);
            if (beanState == null) continue;
            states.add(new StoreAndBeanState((Serializable)ctx.getInstanceKey(), container.getBackingStore(), beanState, !ctx.existsInStore()));
        }
        if (states.size() > 0) {
            StoreAndBeanState[] beanStates = states.toArray(new StoreAndBeanState[states.size()]);
            try {
                for (StoreAndBeanState st : states) {
                    st.store.save(st.key, (Serializable)st.state, st.isNew);
                }
            }
            catch (BackingStoreException sfsbEx) {
                _logger.log(Level.WARNING, "Exception during checkpointSave", sfsbEx);
            }
            catch (Throwable th) {
                _logger.log(Level.WARNING, "Exception during checkpointSave", th);
            }
        }
        for (i = 0; i < size; ++i) {
            ctx = contexts[i];
            container = (StatefulSessionContainer)ctx.getContainer();
            container.txCheckpointCompleted(ctx);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class StoreAndBeanState {
        Serializable key;
        BackingStore<Serializable, SimpleMetadata> store;
        SimpleMetadata state;
        boolean isNew;

        StoreAndBeanState(Serializable key, BackingStore<Serializable, SimpleMetadata> store, SimpleMetadata state, boolean isNew) {
            this.key = key;
            this.store = store;
            this.state = state;
            this.isNew = isNew;
        }
    }
}

