/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.appserv.connectors.internal.api.ConnectorRuntime;
import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.EJBTimerSchedule;
import com.sun.ejb.containers.EJBTimerService;
import com.sun.ejb.containers.RuntimeTimerState;
import com.sun.ejb.containers.TimerLocal;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.ejb.containers.TimerState;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import com.sun.enterprise.transaction.api.JavaEETransactionManager;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.TimerConfig;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import org.glassfish.ejb.config.EjbContainer;
import org.glassfish.ejb.config.EjbTimerService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceEJBTimerService
extends EJBTimerService {
    private TimerLocal timerLocal_;
    private static final Logger logger = LogDomains.getLogger(PersistenceEJBTimerService.class, (String)"javax.enterprise.system.container.ejb");
    private boolean performDBReadBeforeTimeout = false;
    private static final String strDBReadBeforeTimeout = "com.sun.ejb.timer.ReadDBBeforeTimeout";
    private boolean foundSysPropDBReadBeforeTimeout = false;
    private DataSource timerDataSource = null;
    private static final String ON_CONECTION_FAILURE = "operation-on-connection-failure";
    private static final String OP_REDELIVER = "redeliver";
    private static final String OP_STOP = "stop";
    private String operationOnConnectionFailure = null;

    public PersistenceEJBTimerService(String appID, TimerLocal timerLocal) throws Exception {
        this.timerLocal_ = timerLocal;
        this.appID = appID;
        this.lookupTimerResource();
        this.initProperties();
    }

    private void initProperties() {
        try {
            EjbContainer ejbc = this.ejbContainerUtil.getEjbContainer();
            EjbTimerService ejbt = ejbc.getEjbTimerService();
            if (ejbt != null) {
                this.foundSysPropDBReadBeforeTimeout = this.getDBReadBeforeTimeoutProperty();
                this.setPerformDBReadBeforeTimeout(false);
                this.operationOnConnectionFailure = ejbt.getPropertyValue(ON_CONECTION_FAILURE);
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception converting timer service domain.xml properties.  Defaults will be used instead.", e);
        }
    }

    @Override
    public String[] listTimers(String[] serverIds) {
        String[] totalTimers = null;
        try {
            totalTimers = this.timerLocal_.countTimersOwnedByServerIds(serverIds);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception in listTimers() : ", ex);
            EJBException ejbEx = this.createEJBException(ex);
            throw ejbEx;
        }
        return totalTimers;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int migrateTimers(String fromOwnerId) {
        String ownerIdOfThisServer = this.getOwnerIdOfThisServer();
        if (fromOwnerId.equals(ownerIdOfThisServer)) {
            logger.log(Level.WARNING, "Attempt to migrate timers from an active server instance " + ownerIdOfThisServer);
            throw new IllegalStateException("Attempt to migrate timers from  an active server instance " + ownerIdOfThisServer);
        }
        logger.log(Level.INFO, "Beginning timer migration process from owner " + fromOwnerId + " to " + ownerIdOfThisServer);
        JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
        Set toRestore = null;
        int totalTimersMigrated = 0;
        try {
            tm.begin();
            toRestore = this.timerLocal_.findTimersOwnedBy(fromOwnerId);
            totalTimersMigrated = this.timerLocal_.migrateTimers(fromOwnerId, ownerIdOfThisServer);
            tm.commit();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "timer migration error", e);
            try {
                tm.rollback();
            }
            catch (Exception re) {
                logger.log(Level.FINE, "timer migration rollback error", re);
            }
            EJBException ejbEx = this.createEJBException(e);
            throw ejbEx;
        }
        if (totalTimersMigrated <= 0) {
            logger.log(Level.INFO, fromOwnerId + " has 0 timers in need " + "of migration");
            return totalTimersMigrated;
        }
        boolean success = false;
        try {
            try {
                logger.log(Level.INFO, "Timer migration phase 1 complete. Changed ownership of " + toRestore.size() + " timers.  Now reactivating timers...");
                this._notifyContainers(toRestore);
                tm.begin();
                this._restoreTimers(toRestore);
                success = true;
            }
            catch (Exception e) {
                logger.log(Level.FINE, "timer restoration error", e);
                EJBException ejbEx = this.createEJBException(e);
                throw ejbEx;
            }
            Object var10_11 = null;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            try {
                tm.commit();
                throw throwable;
            }
            catch (Exception re) {
                logger.log(Level.FINE, "timer migration error", re);
                if (!success) throw throwable;
                EJBException ejbEx = this.createEJBException(re);
                throw ejbEx;
            }
        }
        try {}
        catch (Exception re) {
            logger.log(Level.FINE, "timer migration error", re);
            if (!success) return totalTimersMigrated;
            EJBException ejbEx = this.createEJBException(re);
            throw ejbEx;
        }
        tm.commit();
        return totalTimersMigrated;
    }

    public void setPerformDBReadBeforeTimeout(boolean defaultDBReadValue) {
        if (!this.foundSysPropDBReadBeforeTimeout) {
            this.performDBReadBeforeTimeout = defaultDBReadValue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "EJB Timer Service property : \nread DB before timeout delivery = " + this.performDBReadBeforeTimeout);
            }
        }
    }

    private boolean getDBReadBeforeTimeoutProperty() {
        boolean result = false;
        try {
            String str = System.getProperty(strDBReadBeforeTimeout);
            if (null != str) {
                this.performDBReadBeforeTimeout = Boolean.valueOf(str);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "EJB Timer Service property : \nread DB before timeout delivery = " + this.performDBReadBeforeTimeout);
                }
                result = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "ContainerFactoryImpl.getDebugMonitoringDetails(),  Exception when trying to get the System property - ", e);
        }
        return result;
    }

    @Override
    public boolean restoreEJBTimers() {
        boolean rc = false;
        try {
            if (this.totalTimedObjectsInitialized_ > 0L) {
                this.restoreTimers();
                rc = true;
            } else {
                int s = this.timerLocal_.findActiveTimersOwnedByThisServer().size();
                if (s > 0) {
                    logger.log(Level.INFO, "[" + s + "] EJB Timers owned by this server will be restored when timeout beans are loaded");
                } else {
                    logger.log(Level.INFO, "There are no EJB Timers owned by this server");
                }
                rc = true;
            }
        }
        catch (Exception ex) {
            this.ejbContainerUtil.setEJBTimerService(null);
            logger.log(Level.WARNING, "ejb.timer_service_init_error", ex);
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreTimers() throws Exception {
        if (this.totalTimedObjectsInitialized_ == 0L) {
            return;
        }
        JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
        try {
            tm.begin();
            this._restoreTimers(this.timerLocal_.findActiveTimersOwnedByThisServer());
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            try {
                tm.commit();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "ejb.timer_service_init_error", e);
            }
            throw throwable;
        }
        try {
            tm.commit();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "ejb.timer_service_init_error", e);
        }
    }

    private void _notifyContainers(Set<TimerState> timers) {
        for (TimerState timer : timers) {
            long containerId;
            BaseContainer container;
            EJBTimerSchedule ts = timer.getTimerSchedule();
            if (ts == null || !ts.isAutomatic() || (container = this.getContainer(containerId = timer.getContainerId())) == null) continue;
            TimerPrimaryKey timerId = this.getPrimaryKey(timer);
            container.addSchedule(timerId, ts);
        }
    }

    private Set<TimerState> _restoreTimers(Set<TimerState> timersEligibleForRestoration) {
        HashMap<RuntimeTimerState, Date> timersToRestore = new HashMap<RuntimeTimerState, Date>();
        HashSet<TimerPrimaryKey> timerIdsToRemove = new HashSet<TimerPrimaryKey>();
        HashSet<TimerState> result = new HashSet<TimerState>();
        for (TimerState timer : timersEligibleForRestoration) {
            TimerPrimaryKey timerId = this.getPrimaryKey(timer);
            if (this.getTimerState(timerId) != null) {
                logger.log(Level.FINE, "@@@ Timer already restored: " + timer);
                result.add(timer);
                continue;
            }
            long containerId = timer.getContainerId();
            BaseContainer container = this.getContainer(containerId);
            if (container != null) {
                long appid = timer.getApplicationId();
                if (appid == 0L) {
                    timer.setApplicationId(container.getApplicationId());
                }
                Date initialExpiration = timer.getInitialExpiration();
                Object timedObjectPrimaryKey = null;
                if (container.containerType == BaseContainer.ContainerType.ENTITY) {
                    timedObjectPrimaryKey = timer.getTimedObjectPrimaryKey();
                }
                RuntimeTimerState timerState = new RuntimeTimerState(timerId, initialExpiration, timer.getIntervalDuration(), container, timedObjectPrimaryKey, timer.getTimerSchedule(), null, true);
                this.timerCache_.addTimer(timerId, timerState);
                Date expirationTime = initialExpiration;
                Date now = new Date();
                if (timerState.isPeriodic()) {
                    Date lastExpiration = timer.getLastExpiration();
                    EJBTimerSchedule ts = timer.getTimerSchedule();
                    if (lastExpiration == null && now.after(initialExpiration)) {
                        if (!timerState.isExpired()) {
                            logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer " + timerState + ". Timer expirations should " + " have been delivered starting at " + initialExpiration);
                        }
                    } else if (lastExpiration != null && (ts != null && ts.getNextTimeout(lastExpiration).getTimeInMillis() < now.getTime() || ts == null && now.getTime() - lastExpiration.getTime() > timer.getIntervalDuration())) {
                        logger.log(Level.INFO, "Rescheduling missed expiration for periodic timer " + timerState + ".  Last timer expiration " + "occurred at " + lastExpiration);
                    } else {
                        expirationTime = this.calcNextFixedRateExpiration(timerState);
                    }
                } else if (now.after(initialExpiration)) {
                    logger.log(Level.INFO, "Rescheduling missed expiration for single-action timer " + timerState + ". Timer expiration should " + " have been delivered at " + initialExpiration);
                }
                if (expirationTime == null) {
                    logger.log(Level.INFO, "Removing schedule-based timer " + timerState + " that will never expire again");
                    timerIdsToRemove.add(timerId);
                    continue;
                }
                timersToRestore.put(timerState, expirationTime);
                result.add(timer);
                continue;
            }
            logger.log(Level.FINE, "Skipping timer " + timerId + " for container that is not up: " + containerId);
        }
        if (timerIdsToRemove.size() > 0) {
            this.timerLocal_.remove(timerIdsToRemove);
        }
        for (Map.Entry next : timersToRestore.entrySet()) {
            RuntimeTimerState nextTimer = (RuntimeTimerState)next.getKey();
            TimerPrimaryKey timerId = nextTimer.getTimerId();
            Date expiration = (Date)next.getValue();
            this.scheduleTask(timerId, expiration);
            logger.log(Level.FINE, "EJBTimerService.restoreTimers(), scheduling timer " + nextTimer);
        }
        logger.log(Level.FINE, "DONE EJBTimerService.restoreTimers()");
        return result;
    }

    void cancelEntityBeanTimers(long containerId, Object primaryKey) {
        try {
            Collection<TimerState> timers = this.getTimers(containerId, primaryKey);
            if (logger.isLoggable(Level.FINE) && timers.isEmpty()) {
                logger.log(Level.FINE, "0 cancelEntityBeanTimers for " + containerId + ", " + primaryKey);
            }
            this.timerLocal_.cancelTimers(timers);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "ejb.cancel_entity_timers", new Object[]{String.valueOf(containerId), primaryKey});
            logger.log(Level.WARNING, "", e);
        }
    }

    @Override
    void stopTimers(long containerId) {
        super.stopTimers(containerId);
        this.stopTimers(this.timerLocal_.findTimerIdsByContainer(containerId));
    }

    @Override
    void _destroyTimers(long id, boolean all) {
        int count;
        Object timerIds = null;
        int n = count = all ? this.timerLocal_.countTimersByApplication(id) : this.timerLocal_.countTimersByContainer(id);
        if (count == 0) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "No timers to be deleted for id: " + id);
            }
            return;
        }
        try {
            int deleted;
            int n2 = deleted = all ? this.timerLocal_.deleteTimersByApplication(id) : this.timerLocal_.deleteTimersByContainer(id);
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "[" + deleted + "] timers deleted for id: " + id);
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "ejb.destroy_timers_error", new Object[]{String.valueOf(id)});
            logger.log(Level.WARNING, "", ex);
        }
    }

    @Override
    void _createTimer(TimerPrimaryKey timerId, long containerId, long applicationId, Object timedObjectPrimaryKey, String server_name, Date initialExpiration, long intervalDuration, EJBTimerSchedule schedule, TimerConfig timerConfig) throws Exception {
        try {
            if (timerConfig.isPersistent()) {
                this.timerLocal_.createTimer(timerId.getTimerId(), containerId, applicationId, server_name, timedObjectPrimaryKey, initialExpiration, intervalDuration, schedule, timerConfig);
            } else {
                this.addTimerSynchronization(null, timerId.getTimerId(), initialExpiration, containerId, this.ownerIdOfThisServer_, false);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "ejb.create_timer_failure", new Object[]{String.valueOf(containerId), timedObjectPrimaryKey, timerConfig.getInfo()});
            logger.log(Level.SEVERE, "", e);
            this.timerCache_.removeTimer(timerId);
            if (e instanceof CreateException) {
                throw (CreateException)((Object)e);
            }
            EJBException ejbEx = new EJBException();
            ejbEx.initCause((Throwable)e);
            throw ejbEx;
        }
    }

    @Override
    Map<TimerPrimaryKey, Method> recoverAndCreateSchedules(long containerId, long applicationId, Map<Method, List<ScheduledTimerDescriptor>> schedules, boolean deploy) {
        HashMap<TimerPrimaryKey, Method> result = new HashMap<TimerPrimaryKey, Method>();
        JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
        try {
            tm.begin();
            Set<TimerState> timers = this._restoreTimers(this.timerLocal_.findActiveTimersOwnedByThisServerByContainer(containerId));
            if (timers.size() > 0) {
                logger.log(Level.FINE, "Found " + timers.size() + " persistent timers for containerId: " + containerId);
            }
            boolean schedulesExist = schedules.size() > 0;
            for (TimerState timer : timers) {
                EJBTimerSchedule ts = timer.getTimerSchedule();
                if (ts == null || !ts.isAutomatic() || !schedulesExist) continue;
                for (Map.Entry<Method, List<ScheduledTimerDescriptor>> entry : schedules.entrySet()) {
                    Method m = entry.getKey();
                    if (!m.getName().equals(ts.getTimerMethodName()) || m.getParameterTypes().length != ts.getMethodParamCount()) continue;
                    result.put(new TimerPrimaryKey(timer.getTimerId()), m);
                    if (!logger.isLoggable(Level.FINE)) continue;
                    logger.log(Level.FINE, "@@@ FOUND existing schedule: " + ts.getScheduleAsString() + " FOR method: " + m);
                }
            }
            this.createSchedules(containerId, applicationId, schedules, result, this.ownerIdOfThisServer_, true, deploy && this.isDas);
            tm.commit();
        }
        catch (Exception e) {
            this.recoverAndCreateSchedulesError(e, (TransactionManager)tm);
        }
        return result;
    }

    @Override
    public void createSchedules(long containerId, long applicationId, Map<MethodDescriptor, List<ScheduledTimerDescriptor>> methodDescriptorSchedules, String server_name) {
        JavaEETransactionManager tm = this.ejbContainerUtil.getTransactionManager();
        try {
            tm.begin();
            int count = this.timerLocal_.countTimersByContainer(containerId);
            if (count == 0) {
                this.createSchedules(containerId, applicationId, methodDescriptorSchedules, null, server_name, false, true);
            }
            tm.commit();
        }
        catch (Exception e) {
            this.recoverAndCreateSchedulesError(e, (TransactionManager)tm);
        }
    }

    private void recoverAndCreateSchedulesError(Exception e, TransactionManager tm) {
        logger.log(Level.WARNING, "Timer restore or schedule creation error", e);
        try {
            tm.rollback();
        }
        catch (Exception re) {
            logger.log(Level.FINE, "Timer restore or schedule creation rollback error", re);
        }
        EJBException ejbEx = this.createEJBException(e);
        throw ejbEx;
    }

    private Collection<TimerState> getTimers(long containerId, Object timedObjectPrimaryKey) {
        HashSet<TimerState> activeTimers;
        HashSet<TimerState> timersForTimedObject = activeTimers = this.timerLocal_.findActiveTimersByContainer(containerId);
        if (timedObjectPrimaryKey != null) {
            timersForTimedObject = new HashSet<TimerState>();
            for (TimerState timer : activeTimers) {
                Object nextTimedObjectPrimaryKey = timer.getTimedObjectPrimaryKey();
                if (!nextTimedObjectPrimaryKey.equals(timedObjectPrimaryKey)) continue;
                timersForTimedObject.add(timer);
            }
        }
        return timersForTimedObject;
    }

    @Override
    Collection<TimerPrimaryKey> getTimerIds(long containerId, Object timedObjectPrimaryKey) {
        Set<TimerPrimaryKey> timerIdsForTimedObject = new HashSet();
        if (timedObjectPrimaryKey == null) {
            timerIdsForTimedObject = this.timerLocal_.findActiveTimerIdsByContainer(containerId);
        } else {
            Collection<TimerState> timersForTimedObject = this.getTimers(containerId, timedObjectPrimaryKey);
            for (TimerState timer : timersForTimedObject) {
                timerIdsForTimedObject.add(this.getPrimaryKey(timer));
            }
        }
        timerIdsForTimedObject.addAll(super.getTimerIds(containerId, null));
        return timerIdsForTimedObject;
    }

    @Override
    void cancelTimer(TimerPrimaryKey timerId) throws FinderException, Exception {
        if (!this.cancelNonPersistentTimer(timerId)) {
            this.timerLocal_.cancel(timerId);
        }
    }

    @Override
    Date getNextTimeout(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        if (rt != null) {
            return this._getNextTimeout(rt);
        }
        TimerState timer = this.getPersistentTimer(timerId);
        Date initialExpiration = timer.getInitialExpiration();
        long intervalDuration = timer.getIntervalDuration();
        EJBTimerSchedule ts = timer.getTimerSchedule();
        Date nextTimeout = null;
        nextTimeout = ts != null ? this.getNextScheduledTimeout(ts) : (intervalDuration > 0L ? this.calcNextFixedRateExpiration(initialExpiration, intervalDuration) : initialExpiration);
        return nextTimeout;
    }

    @Override
    Serializable getInfo(TimerPrimaryKey timerId) throws FinderException {
        if (!super.isPersistent(timerId)) {
            return super.getInfo(timerId);
        }
        TimerState timer = this.getPersistentTimer(timerId);
        return timer.getInfo();
    }

    @Override
    boolean isPersistent(TimerPrimaryKey timerId) throws FinderException {
        if (!super.isPersistent(timerId)) {
            return false;
        }
        this.getPersistentTimer(timerId);
        return true;
    }

    @Override
    boolean timerExists(TimerPrimaryKey timerId) {
        TimerState timer;
        boolean exists = super.timerExists(timerId);
        if (!exists && (timer = this.timerLocal_.findTimer(timerId)) != null) {
            exists = timer.isActive();
        }
        return exists;
    }

    @Override
    EJBTimerSchedule getTimerSchedule(TimerPrimaryKey timerId) throws FinderException {
        EJBTimerSchedule ts = null;
        if (!super.isPersistent(timerId)) {
            ts = super.getTimerSchedule(timerId);
        } else {
            TimerState timer = this.getPersistentTimer(timerId);
            ts = timer.getTimerSchedule();
        }
        return ts;
    }

    private void removeTimerBean(TimerPrimaryKey timerId) {
        try {
            this.timerLocal_.remove(timerId);
        }
        catch (Throwable t) {
            logger.log(Level.WARNING, "ejb.remove_timer_failure", new Object[]{timerId});
            logger.log(Level.WARNING, "", t);
        }
    }

    private TimerState getPersistentTimer(TimerPrimaryKey timerId) throws FinderException {
        TimerState timer = this.timerLocal_.findTimer(timerId);
        if (timer == null || timer.isCancelled()) {
            throw new FinderException("timer " + timerId + " does not exist");
        }
        return timer;
    }

    @Override
    boolean isCancelledByAnotherInstance(RuntimeTimerState timerState) {
        if (timerState.isPersistent() && this.performDBReadBeforeTimeout) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "For Timer :" + timerState.getTimerId() + ": check the database to ensure that the timer is still " + " valid, before delivering the ejbTimeout call");
            }
            if (!this.checkForTimerValidity(timerState.getTimerId())) {
                return true;
            }
        }
        return false;
    }

    @Override
    boolean redeliverTimeout(RuntimeTimerState timerState) {
        return (long)timerState.getNumFailedDeliveries() < this.getMaxRedeliveries() || this.redeliverOnFailedConnection();
    }

    @Override
    boolean isValidTimerForThisServer(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
        return !timerState.isPersistent() || this.getValidTimerFromDB(timerId) != null;
    }

    @Override
    void resetLastExpiration(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
        if (timerState.isPersistent()) {
            TimerState timer = this.getValidTimerFromDB(timerId);
            if (null == timer) {
                return;
            }
            Date now = new Date();
            timer.setLastExpiration(now);
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Setting last expiration  for periodic timer " + timerState + " to " + now);
            }
        }
    }

    private boolean checkForTimerValidity(TimerPrimaryKey timerId) {
        boolean result = true;
        TimerState timer = this.getValidTimerFromDB(timerId);
        if (null == timer) {
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerState getValidTimerFromDB(TimerPrimaryKey timerId) {
        boolean result = true;
        TimerState timer = this.timerLocal_.findTimer(timerId);
        try {
            if (timer != null) {
                if (!timer.getOwnerId().equals(this.ownerIdOfThisServer_)) {
                    logger.log(Level.WARNING, "The timer (" + timerId + ") is not owned by " + "server (" + this.ownerIdOfThisServer_ + ") that " + "initiated the ejbTimeout. This timer is now " + "owned by (" + timer.getOwnerId() + "). \n" + "Hence delete the timer from " + this.ownerIdOfThisServer_ + "'s cache.");
                    result = false;
                }
            } else {
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Timer :" + timerId + ": has been cancelled by another server instance. " + "Expunging the timer from " + this.ownerIdOfThisServer_ + "'s cache.");
                }
                result = false;
            }
            Object var5_4 = null;
            if (!result) {
                this.expungeTimer(timerId, false);
                timer = null;
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "The Timer :" + timerId + ": is a valid timer for the server (" + this.ownerIdOfThisServer_ + ")");
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!result) {
                this.expungeTimer(timerId, false);
                timer = null;
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "The Timer :" + timerId + ": is a valid timer for the server (" + this.ownerIdOfThisServer_ + ")");
            }
            throw throwable;
        }
        return timer;
    }

    @Override
    void expungeTimer(TimerPrimaryKey timerId, boolean removeTimerBean) {
        if (removeTimerBean) {
            this.removeTimerBean(timerId);
        }
        super.expungeTimer(timerId, removeTimerBean);
    }

    TimerLocal getTimerLocal() {
        return this.timerLocal_;
    }

    @Override
    boolean stopOnFailure() {
        return this.stopOnFailedConnection();
    }

    private boolean redeliverOnFailedConnection() {
        return this.operationOnConnectionFailure != null && this.operationOnConnectionFailure.equalsIgnoreCase(OP_REDELIVER) && this.failedConnection();
    }

    private boolean stopOnFailedConnection() {
        return this.operationOnConnectionFailure != null && this.operationOnConnectionFailure.equalsIgnoreCase(OP_STOP) && this.failedConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean failedConnection() {
        boolean failed;
        block15: {
            failed = false;
            Connection c = null;
            if (this.timerDataSource == null) {
                this.lookupTimerResource();
            }
            failed = !(c = this.timerDataSource.getConnection()).isValid(0);
            Object var5_3 = null;
            try {
                if (c != null) {
                    c.close();
                }
                break block15;
            }
            catch (Exception e2) {}
            break block15;
            {
                catch (Exception e) {
                    failed = true;
                    Object var5_4 = null;
                    try {
                        if (c != null) {
                            c.close();
                        }
                        break block15;
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                try {
                    if (c != null) {
                        c.close();
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        if (failed) {
            logger.log(Level.WARNING, "Cannot acquire a connection from the database used by the EJB Timer Service");
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Connection ok");
        }
        return failed;
    }

    private void lookupTimerResource() throws Exception {
        String resource_name = this.ejbContainerUtil.getTimerResource();
        ConnectorRuntime connectorRuntime = (ConnectorRuntime)this.ejbContainerUtil.getServices().forContract(ConnectorRuntime.class).get();
        this.timerDataSource = (DataSource)DataSource.class.cast(connectorRuntime.lookupNonTxResource(resource_name, false));
    }
}

