/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.containers;

import com.sun.ejb.containers.BaseContainer;
import com.sun.ejb.containers.ContainerSynchronization;
import com.sun.ejb.containers.EJBContextImpl;
import com.sun.ejb.containers.EJBTimerSchedule;
import com.sun.ejb.containers.EJBTimerServiceConfigListener;
import com.sun.ejb.containers.EJBTimerTask;
import com.sun.ejb.containers.EjbContainerUtil;
import com.sun.ejb.containers.EjbContainerUtilImpl;
import com.sun.ejb.containers.RuntimeTimerState;
import com.sun.ejb.containers.TimerPrimaryKey;
import com.sun.ejb.containers.TimerState;
import com.sun.enterprise.admin.monitor.callflow.Agent;
import com.sun.enterprise.admin.monitor.callflow.RequestType;
import com.sun.enterprise.deployment.MethodDescriptor;
import com.sun.enterprise.deployment.ScheduledTimerDescriptor;
import com.sun.logging.LogDomains;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ScheduleExpression;
import javax.ejb.TimerConfig;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.ejb.config.EjbContainer;
import org.glassfish.ejb.config.EjbTimerService;
import org.glassfish.server.ServerEnvironmentImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EJBTimerService {
    EjbContainerUtil ejbContainerUtil = EjbContainerUtilImpl.getInstance();
    private long nextTimerIdMillis_ = 0L;
    private long nextTimerIdCounter_ = 0L;
    private String domainName_;
    boolean isDas;
    private static final String TIMER_ID_SEP = "@@";
    String ownerIdOfThisServer_;
    TimerCache timerCache_;
    private boolean shutdown_ = false;
    long totalTimedObjectsInitialized_ = 0L;
    private static final Logger logger = LogDomains.getLogger(EJBTimerService.class, (String)"javax.enterprise.system.container.ejb");
    private static final int MAX_REDELIVERIES = 1;
    private static final long REDELIVERY_INTERVAL = 5000L;
    String appID;
    private long minimumDeliveryInterval_ = 1000L;
    private long maxRedeliveries_ = 1L;
    private long redeliveryInterval_ = 5000L;
    private static final String TIMER_SERVICE_FILE = "__timer_service_shutdown__.dat";
    private static final String TIMER_SERVICE_DOWNTIME_FORMAT = "yyyy/MM/dd HH:mm:ss";
    private Agent agent = this.ejbContainerUtil.getCallFlowAgent();
    private static final String RESCHEDULE_FAILED_TIMER = "reschedule-failed-timer";
    private boolean rescheduleFailedTimer = false;

    public EJBTimerService() throws Exception {
        this.timerCache_ = new TimerCache();
        ServerEnvironmentImpl env = this.ejbContainerUtil.getServerEnvironment();
        this.ownerIdOfThisServer_ = env.getInstanceName();
        this.domainName_ = env.getDomainName();
        this.isDas = env.isDas() || env.isEmbedded();
        this.initProperties();
    }

    private void initProperties() {
        try {
            EjbContainer ejbc = this.ejbContainerUtil.getEjbContainer();
            EjbTimerService ejbt = ejbc.getEjbTimerService();
            if (ejbt != null) {
                long val;
                String valString = ejbt.getMinimumDeliveryIntervalInMillis();
                long l = val = valString != null ? Long.parseLong(valString) : -1L;
                if (val > 0L) {
                    this.minimumDeliveryInterval_ = val;
                }
                long l2 = val = (valString = ejbt.getMaxRedeliveries()) != null ? Long.parseLong(valString) : -1L;
                if (val > 0L) {
                    this.maxRedeliveries_ = val;
                }
                long l3 = val = (valString = ejbt.getRedeliveryIntervalInternalInMillis()) != null ? Long.parseLong(valString) : -1L;
                if (val > 0L) {
                    this.redeliveryInterval_ = val;
                }
                this.rescheduleFailedTimer = Boolean.valueOf(ejbt.getPropertyValue(RESCHEDULE_FAILED_TIMER));
                this.ejbContainerUtil.getServices().byType(EJBTimerServiceConfigListener.class).get();
            }
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Exception converting timer service domain.xml properties.  Defaults will be used instead.", e);
        }
        logger.log(Level.FINE, "EJB Timer Service properties : min delivery interval = " + this.getMinimumDeliveryInterval() + "\nmax redeliveries = " + this.maxRedeliveries_ + "\nredelivery interval = " + this.getRedeliveryInterval());
    }

    synchronized void timedObjectCount() {
        ++this.totalTimedObjectsInitialized_;
    }

    String getOwnerIdOfThisServer() {
        return this.ownerIdOfThisServer_;
    }

    public String[] listTimers(String[] serverIds) {
        String[] result = new String[serverIds.length];
        for (int i = 0; i < serverIds.length; ++i) {
            result[i] = "0";
        }
        return result;
    }

    public int migrateTimers(String fromOwnerId) {
        throw new IllegalStateException("Non-persistent timers cannot be migrated");
    }

    EJBException createEJBException(Exception ex) {
        EJBException ejbEx = new EJBException();
        ejbEx.initCause((Throwable)ex);
        return ejbEx;
    }

    public boolean restoreEJBTimers() {
        return true;
    }

    void shutdown() {
        this.shutdown_ = true;
    }

    public void destroyTimers(long containerId) {
        this._destroyTimers(containerId, false);
    }

    public void destroyAllTimers(long applicationId) {
        this._destroyTimers(applicationId, true);
    }

    void _destroyTimers(long id, boolean all) {
    }

    void stopTimers(long containerId) {
        this.stopTimers(this.timerCache_.getNonPersistentTimerIdsForContainer(containerId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopTimers(Set<TimerPrimaryKey> timerIds) {
        for (TimerPrimaryKey nextTimerId : timerIds) {
            Object var9_8;
            RuntimeTimerState nextTimerState = null;
            try {
                try {
                    nextTimerState = this.getTimerState(nextTimerId);
                    if (nextTimerState != null) {
                        RuntimeTimerState runtimeTimerState = nextTimerState;
                        synchronized (runtimeTimerState) {
                            if (nextTimerState.isScheduled()) {
                                EJBTimerTask timerTask = nextTimerState.getCurrentTimerTask();
                                timerTask.cancel();
                            }
                        }
                    }
                    var9_8 = null;
                    if (nextTimerState == null) continue;
                    this.timerCache_.removeTimer(nextTimerId);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "ejb.destroy_timer_error", new Object[]{nextTimerId});
                    logger.log(Level.WARNING, "", e);
                    var9_8 = null;
                    if (nextTimerState == null) continue;
                    this.timerCache_.removeTimer(nextTimerId);
                }
            }
            catch (Throwable throwable) {
                var9_8 = null;
                if (nextTimerState != null) {
                    this.timerCache_.removeTimer(nextTimerId);
                }
                throw throwable;
            }
        }
    }

    void rescheduleTask(TimerPrimaryKey timerId, Date expiration) {
        this.scheduleTask(timerId, expiration, true);
    }

    void scheduleTask(TimerPrimaryKey timerId, Date expiration) {
        this.scheduleTask(timerId, expiration, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleTask(TimerPrimaryKey timerId, Date expiration, boolean rescheduled) {
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                Date cutoff;
                Date timerExpiration = expiration;
                if (!rescheduled && expiration.before(cutoff = new Date(new Date().getTime() + this.getMinimumDeliveryInterval()))) {
                    timerExpiration = cutoff;
                }
                EJBTimerTask timerTask = new EJBTimerTask(timerExpiration, timerId, this);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, (rescheduled ? "RE-" : "") + "Scheduling " + timerState + " for timeout at " + timerExpiration);
                }
                if (rescheduled) {
                    timerState.rescheduled(timerTask);
                } else {
                    timerState.scheduled(timerTask);
                }
                Timer jdkTimer = this.ejbContainerUtil.getTimer();
                jdkTimer.schedule((TimerTask)timerTask, timerExpiration);
            }
        } else {
            logger.log(Level.FINE, "No timer state found for " + (rescheduled ? "RE-schedule" : "schedule") + " request of " + timerId + " for timeout at " + expiration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Date cancelTask(TimerPrimaryKey timerId) {
        Date timeout = null;
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                if (timerState.isCreated()) {
                    timeout = timerState.getInitialExpiration();
                } else if (timerState.isScheduled()) {
                    EJBTimerTask timerTask = timerState.getCurrentTimerTask();
                    timeout = timerTask.getTimeout();
                    timerTask.cancel();
                }
                timerState.cancelled();
            }
        } else {
            logger.log(Level.FINE, "No timer state found for cancelTask request of " + timerId);
        }
        return timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreTaskToDelivered(TimerPrimaryKey timerId) {
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                timerState.restoredToDelivered();
            }
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Restoring " + timerId + " to delivered state after it was cancelled and " + " rolled back from within its own ejbTimeout method");
            }
        } else {
            logger.log(Level.FINE, "No timer state found for restoreTaskToDelivered request of " + timerId);
        }
    }

    void expungeTimer(TimerPrimaryKey timerId) {
        this.expungeTimer(timerId, false);
    }

    private Date calcInitialFixedRateExpiration(long timerServiceWentDownAt, RuntimeTimerState timerState) {
        long now2initialDiff;
        long count;
        if (!timerState.isPeriodic()) {
            throw new IllegalStateException();
        }
        Date now = new Date();
        long nowMillis = now.getTime();
        long initialExpiration = timerState.getInitialExpiration().getTime();
        long previousExpiration = initialExpiration + (count = (now2initialDiff = nowMillis - initialExpiration) / timerState.getIntervalDuration()) * timerState.getIntervalDuration();
        if (previousExpiration >= timerServiceWentDownAt && previousExpiration <= nowMillis) {
            logger.log(Level.INFO, "ejb.deliver_missed_timer", new Object[]{timerState.getTimerId(), new Date(previousExpiration)});
            return now;
        }
        return this.calcNextFixedRateExpiration(timerState);
    }

    Date calcNextFixedRateExpiration(RuntimeTimerState timerState) {
        if (!timerState.isPeriodic()) {
            throw new IllegalStateException("Timer " + timerState + " is " + "not a periodic timer");
        }
        EJBTimerSchedule ts = timerState.getTimerSchedule();
        if (ts != null) {
            return this.getNextScheduledTimeout(ts);
        }
        Date initialExpiration = timerState.getInitialExpiration();
        long intervalDuration = timerState.getIntervalDuration();
        return this.calcNextFixedRateExpiration(initialExpiration, intervalDuration);
    }

    Date calcNextFixedRateExpiration(Date initialExpiration, long intervalDuration) {
        Date now = new Date();
        long nowMillis = now.getTime();
        Date nextExpirationTime = initialExpiration;
        if (now.after(initialExpiration)) {
            long timeSinceInitialExpire = nowMillis - initialExpiration.getTime();
            long numIntervals = timeSinceInitialExpire / intervalDuration;
            nextExpirationTime = new Date(initialExpiration.getTime() + (numIntervals + 1L) * intervalDuration);
        }
        return nextExpirationTime;
    }

    void expungeTimer(TimerPrimaryKey timerId, boolean removeTimerBean) {
        this.timerCache_.removeTimer(timerId);
    }

    TimerPrimaryKey createTimer(long containerId, long applicationId, Object timedObjectPrimaryKey, long initialDuration, long intervalDuration, TimerConfig timerConfig) throws CreateException {
        Date now = new Date();
        Date initialExpiration = new Date(now.getTime() + initialDuration);
        return this.createTimer(containerId, applicationId, timedObjectPrimaryKey, initialExpiration, intervalDuration, timerConfig);
    }

    TimerPrimaryKey createTimer(long containerId, long applicationId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, TimerConfig timerConfig) throws CreateException {
        return this.createTimer(containerId, applicationId, timedObjectPrimaryKey, initialExpiration, intervalDuration, null, timerConfig);
    }

    TimerPrimaryKey createTimer(long containerId, long applicationId, EJBTimerSchedule schedule, TimerConfig timerConfig, String server_name) throws CreateException {
        return this.createTimer(containerId, applicationId, null, null, 0L, schedule, timerConfig, server_name);
    }

    TimerPrimaryKey createTimer(long containerId, long applicationId, Object timedObjectPrimaryKey, EJBTimerSchedule schedule, TimerConfig timerConfig) throws CreateException {
        return this.createTimer(containerId, applicationId, timedObjectPrimaryKey, null, 0L, schedule, timerConfig, this.ownerIdOfThisServer_);
    }

    private TimerPrimaryKey createTimer(long containerId, long applicationId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, EJBTimerSchedule schedule, TimerConfig timerConfig) throws CreateException {
        return this.createTimer(containerId, applicationId, timedObjectPrimaryKey, initialExpiration, intervalDuration, schedule, timerConfig, this.ownerIdOfThisServer_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimerPrimaryKey createTimer(long containerId, long applicationId, Object timedObjectPrimaryKey, Date initialExpiration, long intervalDuration, EJBTimerSchedule schedule, TimerConfig timerConfig, String server_name) throws CreateException {
        RuntimeTimerState timerState;
        BaseContainer container = this.getContainer(containerId);
        boolean startTimers = this.ownerIdOfThisServer_.equals(server_name);
        if (startTimers) {
            if (container == null) {
                throw new CreateException("invalid container id " + containerId + " in createTimer request");
            }
            Class ejbClass = container.getEJBClass();
            if (!container.isTimedObject()) {
                throw new CreateException("Attempt to create an EJB Timer from a bean that is not a Timed Object.  EJB class " + ejbClass + " must implement javax.ejb.TimedObject or " + " annotation a timeout method with @Timeout");
            }
        }
        TimerPrimaryKey timerId = new TimerPrimaryKey(this.getNextTimerId());
        if (schedule != null) {
            Calendar next = schedule.getNextTimeout();
            initialExpiration = !schedule.isValid(next) ? new Date() : next.getTime();
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "@@@ Created timer [" + timerId + "] with the first expiration set to: " + initialExpiration);
        }
        if (timerConfig == null) {
            timerConfig = new TimerConfig();
        }
        RuntimeTimerState runtimeTimerState = timerState = new RuntimeTimerState(timerId, initialExpiration, intervalDuration, containerId, container, timedObjectPrimaryKey, schedule, timerConfig.getInfo(), timerConfig.isPersistent());
        synchronized (runtimeTimerState) {
            if (startTimers) {
                this.timerCache_.addTimer(timerId, timerState);
            }
            try {
                this._createTimer(timerId, containerId, applicationId, timedObjectPrimaryKey, server_name, initialExpiration, intervalDuration, schedule, timerConfig);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "ejb.create_timer_failure", new Object[]{String.valueOf(containerId), timedObjectPrimaryKey, timerConfig.getInfo()});
                logger.log(Level.SEVERE, "", e);
                this.timerCache_.removeTimer(timerId);
                if (e instanceof CreateException) {
                    throw (CreateException)((Object)e);
                }
                EJBException ejbEx = new EJBException();
                ejbEx.initCause((Throwable)e);
                throw ejbEx;
            }
        }
        return timerId;
    }

    void _createTimer(TimerPrimaryKey timerId, long containerId, long applicationId, Object timedObjectPrimaryKey, String server_name, Date initialExpiration, long intervalDuration, EJBTimerSchedule schedule, TimerConfig timerConfig) throws Exception {
        if (timerConfig.isPersistent()) {
            throw new CreateException("Persistent timers are not supported in this setup");
        }
        this.addTimerSynchronization(null, timerId.getTimerId(), initialExpiration, containerId, this.ownerIdOfThisServer_, false);
    }

    Map<TimerPrimaryKey, Method> recoverAndCreateSchedules(long containerId, long applicationId, Map<Method, List<ScheduledTimerDescriptor>> schedules, boolean deploy) {
        HashMap<TimerPrimaryKey, Method> result = new HashMap<TimerPrimaryKey, Method>();
        try {
            this.createSchedules(containerId, applicationId, schedules, result, this.ownerIdOfThisServer_, true, deploy && this.isDas);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            EJBException ejbEx = this.createEJBException(e);
            throw ejbEx;
        }
        return result;
    }

    public void createSchedules(long containerId, long applicationId, Map<MethodDescriptor, List<ScheduledTimerDescriptor>> methodDescriptorSchedules, String server_name) {
        try {
            this.createSchedules(containerId, applicationId, methodDescriptorSchedules, null, server_name, false, true);
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            EJBException ejbEx = this.createEJBException(e);
            throw ejbEx;
        }
    }

    void createSchedules(long containerId, long applicationId, Map<?, List<ScheduledTimerDescriptor>> schedules, Map<TimerPrimaryKey, Method> result, String server_name, boolean startTimers, boolean deploy) throws Exception {
        for (Map.Entry<?, List<ScheduledTimerDescriptor>> entry : schedules.entrySet()) {
            Object key = entry.getKey();
            String mname = null;
            int args_length = 0;
            if (key instanceof Method) {
                mname = ((Method)key).getName();
                args_length = ((Method)key).getParameterTypes().length;
            } else {
                mname = ((MethodDescriptor)key).getName();
                args_length = ((MethodDescriptor)key).getJavaParameterClassNames().length;
            }
            for (ScheduledTimerDescriptor sch : entry.getValue()) {
                boolean persistent = sch.getPersistent();
                if (persistent && !deploy || !persistent && !startTimers) continue;
                EJBTimerSchedule ts = new EJBTimerSchedule(sch, mname, args_length);
                TimerConfig tc = new TimerConfig();
                String info = sch.getInfo();
                if (info != null && !info.equals("")) {
                    tc.setInfo((Serializable)((Object)info));
                }
                tc.setPersistent(persistent);
                TimerPrimaryKey tpk = this.createTimer(containerId, applicationId, ts, tc, server_name);
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "@@@ CREATED new schedule: " + ts.getScheduleAsString() + " FOR method: " + key);
                }
                if (!startTimers || result == null) continue;
                result.put(tpk, (Method)key);
            }
        }
    }

    Collection<TimerPrimaryKey> getTimerIds(long containerId, Object timedObjectPrimaryKey) {
        HashSet<TimerPrimaryKey> timerIdsForTimedObject = new HashSet<TimerPrimaryKey>();
        timerIdsForTimedObject.addAll(this.timerCache_.getNonPersistentActiveTimerIdsForContainer(containerId));
        return timerIdsForTimedObject;
    }

    ClassLoader getTimerClassLoader(long containerId) {
        BaseContainer container = this.getContainer(containerId);
        return container != null ? container.getClassLoader() : null;
    }

    RuntimeTimerState getTimerState(TimerPrimaryKey timerId) {
        return this.timerCache_.getTimerState(timerId);
    }

    private RuntimeTimerState getNonPersistentTimerState(TimerPrimaryKey timerId) {
        return this.timerCache_.getNonPersistentTimerState(timerId);
    }

    public Set<TimerPrimaryKey> getNonPersistentActiveTimerIdsByThisServer() {
        return this.timerCache_.getNonPersistentActiveTimerIdsByThisServer();
    }

    void cancelTimer(TimerPrimaryKey timerId) throws FinderException, Exception {
        this.cancelNonPersistentTimer(timerId);
    }

    boolean cancelNonPersistentTimer(TimerPrimaryKey timerId) throws FinderException, Exception {
        RuntimeTimerState rt = this.getNonPersistentTimerState(timerId);
        if (rt != null) {
            if (rt.isCancelled()) {
                return true;
            }
            this.cancelTimerSynchronization(null, timerId, rt.getContainerId(), this.ownerIdOfThisServer_, false);
        }
        return rt != null;
    }

    Date getNextTimeout(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        if (rt != null) {
            return this._getNextTimeout(rt);
        }
        throw new FinderException("Timer does not exist");
    }

    Date _getNextTimeout(RuntimeTimerState rt) {
        Date initialExpiration = rt.getInitialExpiration();
        long intervalDuration = rt.getIntervalDuration();
        EJBTimerSchedule ts = rt.getTimerSchedule();
        Date nextTimeout = initialExpiration;
        if (ts != null) {
            nextTimeout = this.getNextScheduledTimeout(ts);
        } else if (intervalDuration > 0L) {
            nextTimeout = this.calcNextFixedRateExpiration(initialExpiration, intervalDuration);
        }
        return nextTimeout;
    }

    Serializable getInfo(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        if (rt != null) {
            return rt.getInfo();
        }
        return null;
    }

    ScheduleExpression getScheduleExpression(TimerPrimaryKey timerId) throws FinderException {
        EJBTimerSchedule ts = this.getTimerSchedule(timerId);
        return ts == null ? null : ts.getScheduleExpression();
    }

    boolean isCalendarTimer(TimerPrimaryKey timerId) throws FinderException {
        EJBTimerSchedule ts = this.getTimerSchedule(timerId);
        return ts != null;
    }

    boolean isPersistent(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        return rt == null;
    }

    boolean timerExists(TimerPrimaryKey timerId) {
        boolean exists = false;
        RuntimeTimerState rt = this.getNonPersistentTimerState(timerId);
        if (rt != null) {
            exists = rt.isActive();
        }
        return exists;
    }

    EJBTimerSchedule getTimerSchedule(TimerPrimaryKey timerId) throws FinderException {
        EJBTimerSchedule ts = null;
        RuntimeTimerState rt = this.getNonPersistentTimer(timerId);
        if (rt != null) {
            ts = rt.getTimerSchedule();
        }
        return ts;
    }

    RuntimeTimerState getNonPersistentTimer(TimerPrimaryKey timerId) throws FinderException {
        RuntimeTimerState rt = this.getNonPersistentTimerState(timerId);
        if (rt != null && rt.isCancelled()) {
            throw new FinderException("Non-persistent timer " + timerId + " does not exist");
        }
        return rt;
    }

    BaseContainer getContainer(long containerId) {
        return this.ejbContainerUtil.getContainer(containerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void deliverTimeout(TimerPrimaryKey timerId) {
        BaseContainer container;
        block31: {
            block29: {
                block28: {
                    block27: {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "EJBTimerService.deliverTimeout(): work thread is processing work for timerId = " + timerId);
                        }
                        if (this.shutdown_) {
                            if (!logger.isLoggable(Level.FINE)) return;
                            logger.log(Level.FINE, "Cancelling timeout for " + timerId + " due to server shutdown.  Expiration " + " will occur when server is restarted.");
                            return;
                        }
                        RuntimeTimerState timerState = this.getTimerState(timerId);
                        if (timerState == null) {
                            logger.log(Level.FINE, "Timer state is NULL for timer " + timerId + " in deliverTimeout");
                            return;
                        }
                        container = this.getContainer(timerState.getContainerId());
                        RuntimeTimerState runtimeTimerState = timerState;
                        synchronized (runtimeTimerState) {
                            if (container == null) {
                                logger.log(Level.FINE, "Unknown container for timer " + timerId + " in deliverTimeout.  Expunging timer.");
                                this.expungeTimer(timerId, true);
                                return;
                            }
                            if (!timerState.isBeingDelivered()) {
                                logger.log(Level.FINE, "Timer state = " + timerState.stateToString() + "for timer " + timerId + " before callEJBTimeout");
                                return;
                            }
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Calling ejbTimeout for timer " + timerState);
                            }
                        }
                        try {
                            try {
                                boolean redeliver;
                                this.agent.requestStart(RequestType.TIMER_EJB);
                                container.onEnteringContainer();
                                if (this.isCancelledByAnotherInstance(timerState)) {
                                    Object var12_7 = null;
                                    container.onLeavingContainer();
                                    break block27;
                                }
                                boolean bl = redeliver = timerState.isExpired() ? false : container.callEJBTimeout(timerState, this);
                                if (this.shutdown_) {
                                    if (logger.isLoggable(Level.FINE)) {
                                        logger.log(Level.FINE, "Cancelling timeout for " + timerId + " due to server shutdown. Expiration will " + " occur on server restart");
                                    }
                                    break block28;
                                }
                                timerState = this.getTimerState(timerId);
                                if (timerState == null) {
                                    logger.log(Level.FINE, "Timer no longer exists for " + timerId + " after callEJBTimeout");
                                    break block29;
                                }
                                RuntimeTimerState runtimeTimerState2 = timerState;
                                synchronized (runtimeTimerState2) {
                                    boolean reschedule;
                                    block30: {
                                        block33: {
                                            int numDeliv;
                                            block34: {
                                                Date now;
                                                block32: {
                                                    now = new Date();
                                                    reschedule = false;
                                                    if (timerState.isCancelled()) break block30;
                                                    if (!timerState.isExpired()) break block32;
                                                    this.cancelTimer(timerId);
                                                    break block30;
                                                }
                                                if (!redeliver) break block33;
                                                numDeliv = timerState.getNumFailedDeliveries() + 1;
                                                if (!this.redeliverTimeout(timerState)) break block34;
                                                Date redeliveryTimeout = new Date(now.getTime() + this.getRedeliveryInterval());
                                                if (logger.isLoggable(Level.FINE)) {
                                                    logger.log(Level.FINE, "Redelivering " + timerState);
                                                }
                                                this.rescheduleTask(timerId, redeliveryTimeout);
                                                break block30;
                                            }
                                            if (this.stopOnFailure()) {
                                                this.shutdown();
                                                break block30;
                                            } else if (this.rescheduleFailedTimer) {
                                                logger.log(Level.INFO, "ejb.timer_reschedule_after_max_deliveries", new Object[]{timerState.toString(), numDeliv});
                                                reschedule = true;
                                                break block30;
                                            } else {
                                                logger.log(Level.INFO, "ejb.timer_exceeded_max_deliveries", new Object[]{timerState.toString(), numDeliv});
                                                this.expungeTimer(timerId, true);
                                            }
                                            break block30;
                                        }
                                        reschedule = true;
                                    }
                                    if (reschedule && (redeliver || timerState.isPeriodic())) {
                                        Date expiration = this.calcNextFixedRateExpiration(timerState);
                                        if (expiration != null) {
                                            this.scheduleTask(timerId, expiration);
                                        } else {
                                            this.cancelTimer(timerId);
                                        }
                                    }
                                    break block31;
                                }
                            }
                            catch (Exception e) {
                                logger.log(Level.FINE, "callEJBTimeout threw exception for timer id " + timerId, e);
                                this.expungeTimer(timerId, true);
                                Object var12_11 = null;
                                container.onLeavingContainer();
                                this.agent.requestEnd();
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_12 = null;
                            container.onLeavingContainer();
                            this.agent.requestEnd();
                            throw throwable;
                        }
                    }
                    this.agent.requestEnd();
                    return;
                }
                Object var12_8 = null;
                container.onLeavingContainer();
                this.agent.requestEnd();
                return;
            }
            Object var12_9 = null;
            container.onLeavingContainer();
            this.agent.requestEnd();
            return;
        }
        Object var12_10 = null;
        container.onLeavingContainer();
        this.agent.requestEnd();
    }

    boolean isCancelledByAnotherInstance(RuntimeTimerState timerState) {
        return false;
    }

    boolean redeliverTimeout(RuntimeTimerState timerState) {
        return (long)timerState.getNumFailedDeliveries() < this.getMaxRedeliveries();
    }

    boolean stopOnFailure() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean postEjbTimeout(TimerPrimaryKey timerId) {
        boolean success = true;
        if (this.shutdown_) {
            return success;
        }
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            BaseContainer container = this.getContainer(timerState.getContainerId());
            container.incrementDeliveredTimedObject();
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                if (!timerState.isCancelled()) {
                    try {
                        if (!this.isValidTimerForThisServer(timerId, timerState)) {
                            return false;
                        }
                        if (timerState.isPeriodic()) {
                            this.resetLastExpiration(timerId, timerState);
                        } else {
                            if (logger.isLoggable(Level.FINE)) {
                                logger.log(Level.FINE, "Single-action timer " + timerState + " was successfully delivered. " + " Removing...");
                            }
                            this.cancelTimer(timerId);
                        }
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Error in post-ejbTimeout timer processing for " + timerState, e);
                        success = false;
                    }
                }
            }
        }
        return success;
    }

    boolean isValidTimerForThisServer(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
        return true;
    }

    void resetLastExpiration(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void taskExpired(TimerPrimaryKey timerId) {
        RuntimeTimerState timerState = this.getTimerState(timerId);
        if (timerState != null) {
            RuntimeTimerState runtimeTimerState = timerState;
            synchronized (runtimeTimerState) {
                if (timerState.isScheduled()) {
                    timerState.delivered();
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Adding work pool task for timer " + timerId);
                    }
                    TaskExpiredWork work = new TaskExpiredWork(this, timerId);
                    this.ejbContainerUtil.addWork(work);
                } else {
                    logger.log(Level.FINE, "Timer " + timerId + " is not in scheduled state.  Current state = " + timerState.stateToString());
                }
            }
        } else {
            logger.log(Level.FINE, "null timer state for timer id " + timerId);
        }
    }

    private synchronized String getNextTimerId() {
        if (this.nextTimerIdCounter_ <= 0L) {
            this.nextTimerIdMillis_ = System.currentTimeMillis();
            this.nextTimerIdCounter_ = 1L;
        } else {
            ++this.nextTimerIdCounter_;
        }
        return "" + this.nextTimerIdCounter_ + TIMER_ID_SEP + this.nextTimerIdMillis_ + TIMER_ID_SEP + this.ownerIdOfThisServer_ + TIMER_ID_SEP + this.domainName_;
    }

    private long getMinimumDeliveryInterval() {
        return this.minimumDeliveryInterval_;
    }

    long getMaxRedeliveries() {
        return this.maxRedeliveries_;
    }

    private long getRedeliveryInterval() {
        return this.redeliveryInterval_;
    }

    TimerPrimaryKey getPrimaryKey(TimerState timer) {
        return new TimerPrimaryKey(timer.getTimerId());
    }

    void addTimerSynchronization(EJBContextImpl context_, String timerId, Date initialExpiration, long containerId, String ownerId) throws Exception {
        this.addTimerSynchronization(context_, timerId, initialExpiration, containerId, ownerId, true);
    }

    void addTimerSynchronization(EJBContextImpl context_, String timerId, Date initialExpiration, long containerId, String ownerId, boolean persistent) throws Exception {
        if (context_ == null || this.timerOwnedByThisServer(ownerId)) {
            TimerPrimaryKey pk = new TimerPrimaryKey(timerId);
            ContainerSynchronization containerSynch = this.getContainerSynch(context_, timerId, persistent);
            if (containerSynch == null) {
                this.scheduleTask(pk, initialExpiration);
                this.ejbContainerUtil.getContainer(containerId).incrementCreatedTimedObject();
            } else {
                TimerSynch timerSynch = new TimerSynch(pk, 0, initialExpiration, this.ejbContainerUtil.getContainer(containerId), this);
                containerSynch.addTimerSynchronization(pk, timerSynch);
            }
        }
    }

    void cancelTimerSynchronization(EJBContextImpl context_, TimerPrimaryKey timerId, long containerId, String ownerId) throws Exception {
        this.cancelTimerSynchronization(context_, timerId, containerId, ownerId, true);
    }

    void cancelTimerSynchronization(EJBContextImpl context_, TimerPrimaryKey timerId, long containerId, String ownerId, boolean persistent) throws Exception {
        if (context_ == null || this.timerOwnedByThisServer(ownerId)) {
            Date nextTimeout = this.cancelTask(timerId);
            ContainerSynchronization containerSynch = this.getContainerSynch(context_, timerId.getTimerId(), persistent);
            if (containerSynch == null) {
                this.expungeTimer(timerId);
                this.ejbContainerUtil.getContainer(containerId).incrementRemovedTimedObject();
            } else {
                Synchronization timerSynch = containerSynch.getTimerSynchronization(timerId);
                if (timerSynch != null) {
                    containerSynch.removeTimerSynchronization(timerId);
                    this.expungeTimer(timerId);
                } else {
                    timerSynch = new TimerSynch(timerId, 1, nextTimeout, this.ejbContainerUtil.getContainer(containerId), this);
                    containerSynch.addTimerSynchronization(timerId, timerSynch);
                }
            }
        }
    }

    private boolean timerOwnedByThisServer(String ownerId) {
        String ownerIdOfThisServer = this.getOwnerIdOfThisServer();
        return ownerIdOfThisServer != null && ownerIdOfThisServer.equals(ownerId);
    }

    Date getNextScheduledTimeout(EJBTimerSchedule ts) {
        Calendar next = ts.getNextTimeout();
        if (ts.isValid(next)) {
            return next.getTime();
        }
        return null;
    }

    ContainerSynchronization getContainerSynch(EJBContextImpl context_, String timerId, boolean persistent) throws Exception {
        Transaction transaction = null;
        if (context_ != null) {
            transaction = context_.getTransaction();
        }
        if (transaction == null) {
            ComponentInvocation i = this.ejbContainerUtil.getCurrentInvocation();
            if (i == null) {
                transaction = this.ejbContainerUtil.getTransactionManager().getTransaction();
            } else {
                transaction = (Transaction)i.getTransaction();
                if (context_ != null && transaction != null) {
                    logger.log(Level.WARNING, "Context transaction in TimerBean = null. Using invocation instead.");
                }
            }
        }
        if (transaction == null) {
            if (persistent) {
                throw new Exception("transaction = null in getContainerSynch for timerId = " + timerId);
            }
            return null;
        }
        return this.ejbContainerUtil.getContainerSync(transaction);
    }

    static String txStatusToString(int txStatus) {
        String txStatusStr = "UNMATCHED TX STATUS";
        switch (txStatus) {
            case 0: {
                txStatusStr = "TX_STATUS_ACTIVE";
                break;
            }
            case 3: {
                txStatusStr = "TX_STATUS_COMMITTED";
                break;
            }
            case 8: {
                txStatusStr = "TX_STATUS_COMMITTING";
                break;
            }
            case 1: {
                txStatusStr = "TX_STATUS_MARKED_ROLLBACK";
                break;
            }
            case 6: {
                txStatusStr = "TX_STATUS_NO_TRANSACTION";
                break;
            }
            case 2: {
                txStatusStr = "TX_STATUS_PREPARED";
                break;
            }
            case 7: {
                txStatusStr = "TX_STATUS_PREPARING";
                break;
            }
            case 4: {
                txStatusStr = "TX_STATUS_ROLLEDBACK";
                break;
            }
            case 9: {
                txStatusStr = "TX_STATUS_ROLLING_BACK";
                break;
            }
            case 5: {
                txStatusStr = "TX_STATUS_UNKNOWN";
                break;
            }
            default: {
                txStatusStr = "UNMATCHED TX STATUS";
            }
        }
        return txStatusStr;
    }

    public void onShutdown() {
        this.shutdown();
        SimpleDateFormat dateFormat = new SimpleDateFormat(TIMER_SERVICE_DOWNTIME_FORMAT);
        String downTimeStr = dateFormat.format(new Date());
        logger.log(Level.INFO, "ejb.timer_service_shutdown_msg", new Object[]{downTimeStr});
    }

    private static class TimerSynch
    implements Synchronization {
        private TimerPrimaryKey timerId_;
        private int state_;
        private Date timeout_;
        private BaseContainer container_;
        private EJBTimerService timerService_;

        public TimerSynch(TimerPrimaryKey timerId, int state, Date timeout, BaseContainer container, EJBTimerService timerService) {
            this.timerId_ = timerId;
            this.state_ = state;
            this.timeout_ = timeout;
            this.container_ = container;
            this.timerService_ = timerService;
        }

        public void afterCompletion(int status) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "TimerSynch::afterCompletion. timer state = " + TimerState.stateToString(this.state_) + " , " + "timer id = " + this.timerId_ + " , JTA TX status = " + EJBTimerService.txStatusToString(status) + " , " + "timeout = " + this.timeout_);
            }
            switch (this.state_) {
                case 0: {
                    if (status == 3) {
                        this.timerService_.scheduleTask(this.timerId_, this.timeout_);
                        this.container_.incrementCreatedTimedObject();
                        break;
                    }
                    this.timerService_.expungeTimer(this.timerId_);
                    break;
                }
                case 1: {
                    if (status == 4) {
                        if (this.timeout_ != null) {
                            this.timerService_.scheduleTask(this.timerId_, this.timeout_);
                            break;
                        }
                        this.timerService_.restoreTaskToDelivered(this.timerId_);
                        break;
                    }
                    this.timerService_.expungeTimer(this.timerId_);
                    this.container_.incrementRemovedTimedObject();
                    break;
                }
            }
        }

        public void beforeCompletion() {
        }
    }

    private static class TaskExpiredWork
    implements Runnable {
        private EJBTimerService timerService_;
        private TimerPrimaryKey timerId_;

        public TaskExpiredWork(EJBTimerService timerService, TimerPrimaryKey timerId) {
            this.timerService_ = timerService;
            this.timerId_ = timerId;
        }

        public void run() {
            this.timerService_.deliverTimeout(this.timerId_);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TimerCache {
        private Map timers_ = new HashMap();
        private Map containerTimers_ = new HashMap();
        private Map<TimerPrimaryKey, RuntimeTimerState> nonpersistentTimers_ = new HashMap<TimerPrimaryKey, RuntimeTimerState>();

        public synchronized void addTimer(TimerPrimaryKey timerId, RuntimeTimerState timerState) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Adding timer " + timerState);
            }
            this.timers_.put(timerId, timerState);
            if (!timerState.isPersistent()) {
                this.nonpersistentTimers_.put(timerId, timerState);
            }
            Long containerId = timerState.getContainerId();
            Object containerInfo = this.containerTimers_.get(containerId);
            if (timerState.timedObjectIsEntity()) {
                ArrayList<Object> entityBeans;
                if (containerInfo == null) {
                    entityBeans = new ArrayList<Object>();
                    this.containerTimers_.put(containerId, entityBeans);
                } else {
                    entityBeans = (ArrayList<Object>)containerInfo;
                }
                entityBeans.add(timerState.getTimedObjectPrimaryKey());
            } else {
                Long timerCount = containerInfo == null ? 1L : (Long)containerInfo + 1L;
                this.containerTimers_.put(containerId, timerCount);
            }
        }

        public synchronized void removeTimer(TimerPrimaryKey timerId) {
            Long containerId;
            Object containerInfo;
            RuntimeTimerState timerState;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Removing timer " + timerId);
            }
            if ((timerState = (RuntimeTimerState)this.timers_.remove(timerId)) == null) {
                return;
            }
            if (!timerState.isPersistent()) {
                this.nonpersistentTimers_.remove(timerId);
            }
            if ((containerInfo = this.containerTimers_.get(containerId = Long.valueOf(timerState.getContainerId()))) != null) {
                if (timerState.timedObjectIsEntity()) {
                    Collection entityBeans = (Collection)containerInfo;
                    if (entityBeans.size() == 1) {
                        this.containerTimers_.remove(containerId);
                    } else {
                        entityBeans.remove(timerState.getTimedObjectPrimaryKey());
                    }
                } else {
                    long timerCount = (Long)containerInfo;
                    if (timerCount == 1L) {
                        this.containerTimers_.remove(containerId);
                    } else {
                        Long newCount = timerCount - 1L;
                        this.containerTimers_.put(containerId, newCount);
                    }
                }
            }
        }

        public synchronized RuntimeTimerState getTimerState(TimerPrimaryKey timerId) {
            return (RuntimeTimerState)this.timers_.get(timerId);
        }

        public synchronized RuntimeTimerState getNonPersistentTimerState(TimerPrimaryKey timerId) {
            return this.nonpersistentTimers_.get(timerId);
        }

        public synchronized boolean entityBeanHasTimers(long containerId, Object pkey) {
            Object containerInfo = this.containerTimers_.get(containerId);
            return containerInfo != null ? ((Collection)containerInfo).contains(pkey) : false;
        }

        public synchronized boolean containerHasTimers(long containerId) {
            return this.containerTimers_.containsKey(containerId);
        }

        public synchronized void validate() {
        }

        public synchronized Set<TimerPrimaryKey> getNonPersistentTimerIdsForContainer(long containerId_) {
            HashSet<TimerPrimaryKey> result = new HashSet<TimerPrimaryKey>();
            for (Map.Entry<TimerPrimaryKey, RuntimeTimerState> entry : this.nonpersistentTimers_.entrySet()) {
                TimerPrimaryKey key = entry.getKey();
                RuntimeTimerState rt = entry.getValue();
                if (rt.getContainerId() != containerId_) continue;
                result.add(key);
            }
            return result;
        }

        public synchronized Set<TimerPrimaryKey> getNonPersistentActiveTimerIdsForContainer(long containerId_) {
            HashSet<TimerPrimaryKey> result = new HashSet<TimerPrimaryKey>();
            for (Map.Entry<TimerPrimaryKey, RuntimeTimerState> entry : this.nonpersistentTimers_.entrySet()) {
                TimerPrimaryKey key = entry.getKey();
                RuntimeTimerState rt = entry.getValue();
                if (rt.getContainerId() != containerId_ || !rt.isActive()) continue;
                result.add(key);
            }
            return result;
        }

        public synchronized Set<TimerPrimaryKey> getNonPersistentActiveTimerIdsByThisServer() {
            HashSet<TimerPrimaryKey> result = new HashSet<TimerPrimaryKey>();
            for (Map.Entry<TimerPrimaryKey, RuntimeTimerState> entry : this.nonpersistentTimers_.entrySet()) {
                TimerPrimaryKey key = entry.getKey();
                RuntimeTimerState rt = entry.getValue();
                if (!rt.isActive()) continue;
                result.add(key);
            }
            return result;
        }
    }
}

