/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.codegen;

import com.sun.ejb.EJBUtils;
import com.sun.ejb.codegen.ClassGeneratorFactory;
import com.sun.ejb.codegen.Generator;
import com.sun.ejb.codegen.GeneratorException;
import com.sun.ejb.codegen.InvalidBean;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.lang.reflect.Method;
import java.util.LinkedList;
import org.glassfish.pfl.dynamic.codegen.spi.Type;
import org.glassfish.pfl.dynamic.codegen.spi.Wrapper;

public class RemoteGenerator
extends Generator
implements ClassGeneratorFactory {
    private static LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RemoteGenerator.class);
    private Class businessInterface;
    private Method[] bizMethods;
    private String remoteInterfacePackageName;
    private String remoteInterfaceSimpleName;
    private String remoteInterfaceName;

    public String getGeneratedClass() {
        return this.remoteInterfaceName;
    }

    public String className() {
        return this.getGeneratedClass();
    }

    public RemoteGenerator(ClassLoader cl, String businessIntf) throws GeneratorException {
        try {
            this.businessInterface = cl.loadClass(businessIntf);
        }
        catch (ClassNotFoundException ex) {
            throw new InvalidBean(localStrings.getLocalString("generator.remote_interface_not_found", "Remote interface not found "));
        }
        this.remoteInterfaceName = EJBUtils.getGeneratedRemoteIntfName(this.businessInterface.getName());
        this.remoteInterfacePackageName = this.getPackageName(this.remoteInterfaceName);
        this.remoteInterfaceSimpleName = this.getBaseName(this.remoteInterfaceName);
        this.bizMethods = this.removeDups(this.businessInterface.getMethods());
    }

    public void evaluate() {
        Wrapper._clear();
        if (this.remoteInterfacePackageName != null) {
            Wrapper._package((String)this.remoteInterfacePackageName);
        } else {
            Wrapper._package();
        }
        Wrapper._interface((int)1, (String)this.remoteInterfaceSimpleName, (Type[])new Type[]{Wrapper._t((String)"java.rmi.Remote"), Wrapper._t((String)"com.sun.ejb.containers.RemoteBusinessObject")});
        for (int i = 0; i < this.bizMethods.length; ++i) {
            this.printMethod(this.bizMethods[i]);
        }
        Wrapper._end();
        Wrapper._classGenerator();
    }

    private void printMethod(Method m) {
        boolean throwsRemoteException = false;
        LinkedList<Type> exceptionList = new LinkedList<Type>();
        for (Class<?> exception : m.getExceptionTypes()) {
            exceptionList.add(Type.type(exception));
            if (!exception.getName().equals("java.rmi.RemoteException")) continue;
            throwsRemoteException = true;
        }
        if (!throwsRemoteException) {
            exceptionList.add(Wrapper._t((String)"java.rmi.RemoteException"));
        }
        exceptionList.add(Wrapper._t((String)"com.sun.ejb.containers.InternalEJBContainerException"));
        Wrapper._method((int)1025, (Type)Type.type(m.getReturnType()), (String)m.getName(), exceptionList);
        int i = 0;
        for (Class<?> param : m.getParameterTypes()) {
            Wrapper._arg((Type)Type.type(param), (String)("param" + i));
            ++i;
        }
        Wrapper._end();
    }
}

