/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.sfsb.util;

import com.sun.enterprise.config.serverbeans.Applications;
import com.sun.enterprise.config.serverbeans.AvailabilityService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.runtime.IASEjbExtraDescriptors;
import com.sun.logging.LogDomains;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.ejb.config.EjbContainer;
import org.glassfish.ejb.config.EjbContainerAvailability;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
public final class EJBServerConfigLookup {
    private final String DEFAULT_STORE_POOL_JNDI_NAME = "jdbc/hastore";
    private final String DEFAULT_SFSB_HA_PERSISTENCE_TYPE = "file";
    private final String DEFAULT_SFSB_NON_HA_PERSISTENCE_TYPE = "file";
    private static final String REPLICATED_TYPE = "replicated";
    @Inject
    @Named(value="default-instance-name")
    AvailabilityService availabilityService;
    @Inject
    @Named(value="default-instance-name")
    EjbContainer ejbContainer;
    @Inject
    Applications applications;
    @Inject
    @Named(value="default-instance-name")
    Server server;
    private EjbDescriptor _ejbDescriptor = null;
    private boolean _haEnabled = false;
    private static boolean _isDebugMonitoringEnabled = false;
    private static final Logger _logger;

    public void initWithEjbDescriptor(EjbDescriptor ejbDescriptor) {
        this._ejbDescriptor = ejbDescriptor;
    }

    public static boolean isMonitoringEnabled() {
        return EJBServerConfigLookup.isDebugMonitoringEnabled();
    }

    public static boolean isDebugMonitoringEnabled() {
        return _isDebugMonitoringEnabled;
    }

    public boolean getAvailabilityEnabledFromConfig() {
        if (this.availabilityService == null) {
            _logger.fine("AvailabilityService was not defined - check domain.xml");
            return false;
        }
        return Boolean.valueOf(this.availabilityService.getAvailabilityEnabled());
    }

    private String getServerName() {
        return this.server != null ? this.server.getName() : null;
    }

    public boolean calculateEjbAvailabilityEnabledFromConfig() {
        _logger.finest("in EJBServerConfigLookup>>calculateEjbAvailabilityEnabledFromConfig");
        boolean isVirtual = this.isVirtualApplication();
        String appName = this.getApplicationName();
        boolean globalAvailability = this.getAvailabilityEnabledFromConfig();
        boolean ejbContainerAvailability = this.getEjbContainerAvailabilityEnabledFromConfig(globalAvailability);
        boolean ejbDescriptorAvailability = true;
        if (isVirtual) {
            ejbDescriptorAvailability = this.getAvailabilityEnabledFromEjbDescriptor();
            this._haEnabled = globalAvailability && ejbContainerAvailability && ejbDescriptorAvailability;
        } else {
            ejbDescriptorAvailability = this.getAvailabilityEnabledFromEjbDescriptor();
            this._haEnabled = globalAvailability && ejbContainerAvailability && ejbDescriptorAvailability;
        }
        return this._haEnabled;
    }

    public String getPersistenceStoreType() {
        return this._haEnabled ? this.getSfsbHaPersistenceTypeFromConfig() : this.getSfsbNonHaPersistenceTypeFromConfig();
    }

    private boolean isVirtualApplication() {
        Application application = this._ejbDescriptor.getApplication();
        return application.isVirtual();
    }

    private String getApplicationName() {
        Application application = this._ejbDescriptor.getApplication();
        return application.getRegistrationName();
    }

    public boolean getEjbContainerAvailabilityEnabledFromConfig() {
        boolean globalAvailabilityEnabled = this.getAvailabilityEnabledFromConfig();
        _logger.finest("in EJBServerConfigLookup>>getEjbContainerAvailabilityEnabledFromConfig");
        EjbContainerAvailability eas = this.getEjbContainerAvailability();
        if (eas == null) {
            _logger.fine("EjbContainerAvailability was not defined - check domain.xml");
            return globalAvailabilityEnabled;
        }
        String easString = eas.getAvailabilityEnabled();
        Boolean bool = this.toBoolean(easString);
        if (bool == null) {
            return globalAvailabilityEnabled;
        }
        return bool;
    }

    public boolean getEjbContainerAvailabilityEnabledFromConfig(boolean inheritedValue) {
        _logger.finest("in EJBServerConfigLookup>>getEjbContainerAvailabilityEnabledFromConfig");
        EjbContainerAvailability eas = this.getEjbContainerAvailability();
        if (eas == null) {
            _logger.fine("EjbContainerAvailability was not defined - check domain.xml");
            return inheritedValue;
        }
        String easString = eas.getAvailabilityEnabled();
        Boolean bool = this.toBoolean(easString);
        if (bool == null) {
            return inheritedValue;
        }
        return bool;
    }

    private EjbContainerAvailability getEjbContainerAvailability() {
        if (this.availabilityService == null) {
            return null;
        }
        return (EjbContainerAvailability)this.availabilityService.getExtensionByType(EjbContainerAvailability.class);
    }

    public boolean getAvailabilityEnabledFromEjbDescriptor() {
        _logger.finest("in EJBServerConfigLookup>>getAvailabilityEnabledFromEjbDescriptor");
        IASEjbExtraDescriptors extraDescriptors = this._ejbDescriptor.getIASEjbExtraDescriptors();
        if (extraDescriptors == null) {
            return true;
        }
        String availabilityEnabledString = extraDescriptors.getAttributeValue("AvailabilityEnabled");
        Boolean bool = this.toBoolean(availabilityEnabledString);
        if (bool == null) {
            return true;
        }
        return bool;
    }

    public boolean getAvailabilityEnabledFromEjbDescriptor(boolean inheritedValue) {
        _logger.finest("in EJBServerConfigLookup>>getAvailabilityEnabledFromEjbDescriptor");
        IASEjbExtraDescriptors extraDescriptors = this._ejbDescriptor.getIASEjbExtraDescriptors();
        if (extraDescriptors == null) {
            return inheritedValue;
        }
        String availabilityEnabledString = extraDescriptors.getAttributeValue("AvailabilityEnabled");
        Boolean bool = this.toBoolean(availabilityEnabledString);
        if (bool == null) {
            return inheritedValue;
        }
        return bool;
    }

    public String getStorePoolJndiNameFromConfig() {
        _logger.finest("in ServerConfigLookup>>getStorePoolJndiNameFromConfig");
        String result = "jdbc/hastore";
        if (this.availabilityService == null) {
            return result;
        }
        String storePoolJndiName = this.availabilityService.getStorePoolName();
        if (storePoolJndiName != null) {
            result = storePoolJndiName;
        }
        return result;
    }

    public String getHaStorePoolJndiNameFromConfig() {
        _logger.finest("in EJBServerConfigLookup>>getHaStorePoolJndiNameFromConfig");
        String result = this.getStorePoolJndiNameFromConfig();
        EjbContainerAvailability ejbContainerAvailabilityBean = this.getEjbContainerAvailability();
        if (ejbContainerAvailabilityBean == null) {
            return result;
        }
        String result2 = ejbContainerAvailabilityBean.getSfsbStorePoolName();
        if (result2 != null) {
            result = result2;
        }
        return result;
    }

    public String getSfsbHaPersistenceTypeFromConfig() {
        _logger.finest("in EJBServerConfigLookup>>getSfsbHaPersistenceTypeFromConfig");
        String result = "file";
        EjbContainerAvailability ejbContainerAvailabilityBean = this.getEjbContainerAvailability();
        if (ejbContainerAvailabilityBean == null) {
            return result;
        }
        String result2 = ejbContainerAvailabilityBean.getSfsbHaPersistenceType();
        if (result2 != null) {
            result = result2;
        }
        return result;
    }

    public String getSfsbNonHaPersistenceTypeFromConfig() {
        _logger.finest("in EJBServerConfigLookup>>getSfsbNonHaPersistenceTypeFromConfig");
        String result = "file";
        EjbContainerAvailability ejbContainerAvailabilityBean = this.getEjbContainerAvailability();
        if (ejbContainerAvailabilityBean == null) {
            return result;
        }
        String result2 = ejbContainerAvailabilityBean.getSfsbPersistenceType();
        if (result2 != null) {
            result = result2;
        }
        return result;
    }

    public static boolean checkDebugMonitoringEnabled() {
        boolean result = false;
        try {
            Properties props = System.getProperties();
            String str = props.getProperty("MONITOR_EJB_CONTAINER");
            if (null != str && str.equalsIgnoreCase("TRUE")) {
                result = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    protected Boolean toBoolean(String value) {
        if (value == null) {
            return null;
        }
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("yes")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("on")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("1")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private boolean isReplicationTypeMemory() {
        return REPLICATED_TYPE.equalsIgnoreCase(this.getSfsbHaPersistenceTypeFromConfig());
    }

    public boolean needToAddSFSBVersionInterceptors() {
        boolean result;
        boolean isClustered = false;
        boolean isEJBAvailabilityEnabled = false;
        boolean isStoreTypeMemory = false;
        try {
            isEJBAvailabilityEnabled = this.getEjbContainerAvailabilityEnabledFromConfig();
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, "EJBSCLookup:: sc.getEjbContainerAvailabilityEnabledFromConfig() ==> " + isEJBAvailabilityEnabled);
            }
            isStoreTypeMemory = this.isReplicationTypeMemory();
        }
        catch (Exception ex) {
            _logger.log(Level.FINE, "Got exception in needToAddSFSBVersionInterceptors (" + ex + "). SFSBVersionInterceptors not added");
            _logger.log(Level.FINE, "Exception in needToAddSFSBVersionInterceptors", ex);
        }
        boolean bl = result = isClustered && isEJBAvailabilityEnabled && isStoreTypeMemory;
        if (_logger.isLoggable(Level.FINE)) {
            _logger.log(Level.FINE, "EJBServerConfigLookup::==> isClustered:" + isClustered + " ; isEJBAvailabilityEnabled: " + isEJBAvailabilityEnabled + " ; isStoreTypeMemory ==> " + isStoreTypeMemory + " ; result: " + result);
        }
        return result;
    }

    static {
        _isDebugMonitoringEnabled = EJBServerConfigLookup.checkDebugMonitoringEnabled();
        _logger = LogDomains.getLogger(EJBServerConfigLookup.class, (String)"javax.enterprise.system.container.ejb");
    }
}

