/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ejb.base.io;

import com.sun.ejb.spi.io.SerializableObjectFactory;
import com.sun.enterprise.naming.util.ObjectInputOutputStreamFactory;
import com.sun.enterprise.naming.util.ObjectInputOutputStreamFactoryFactory;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.enterprise.iiop.api.GlassFishORBHelper;
import org.glassfish.enterprise.iiop.api.ProtocolManager;
import org.glassfish.internal.api.Globals;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EJBObjectInputStream
extends ObjectInputStream {
    private ClassLoader appLoader;
    private static final Logger _ejbLogger = LogDomains.getLogger(EJBObjectInputStream.class, (String)"javax.enterprise.system.container.ejb");
    private ObjectInputOutputStreamFactory inputStreamHelper;

    EJBObjectInputStream(InputStream in, ClassLoader appCl, boolean resolve) throws IOException, StreamCorruptedException {
        super(in);
        this.appLoader = appCl;
        if (resolve) {
            this.enableResolveObject(resolve);
        }
        this.inputStreamHelper = ObjectInputOutputStreamFactoryFactory.getFactory();
    }

    @Override
    protected Object resolveObject(Object obj) throws IOException {
        ProtocolManager protocolMgr = this.getProtocolManager();
        try {
            if (protocolMgr != null && protocolMgr.isStub(obj)) {
                protocolMgr.connectObject((Remote)obj);
                return obj;
            }
            if (obj instanceof SerializableObjectFactory) {
                return ((SerializableObjectFactory)obj).createObject();
            }
            return obj;
        }
        catch (IOException ioEx) {
            _ejbLogger.log(Level.SEVERE, "ejb.resolve_object_exception", ioEx);
            throw ioEx;
        }
        catch (Exception ex) {
            _ejbLogger.log(Level.SEVERE, "ejb.resolve_object_exception", ex);
            IOException ioe = new IOException();
            ioe.initCause(ex);
            throw ioe;
        }
    }

    private ProtocolManager getProtocolManager() {
        GlassFishORBHelper orbHelper = (GlassFishORBHelper)Globals.getDefaultHabitat().getComponent(GlassFishORBHelper.class);
        return orbHelper.isORBInitialized() ? orbHelper.getProtocolManager() : null;
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] classObjs = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            Class<?> cl = Class.forName(interfaces[i], false, this.appLoader);
            if ((cl.getModifiers() & 1) == 0) {
                return super.resolveProxyClass(interfaces);
            }
            classObjs[i] = cl;
        }
        try {
            return Proxy.getProxyClass(this.appLoader, classObjs);
        }
        catch (IllegalArgumentException e) {
            throw new ClassNotFoundException(null, e);
        }
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        Class<?> clazz = this.inputStreamHelper.resolveClass((ObjectInputStream)this, desc);
        if (clazz == null) {
            try {
                clazz = this.appLoader.loadClass(desc.getName());
            }
            catch (ClassNotFoundException e) {
                clazz = super.resolveClass(desc);
            }
        }
        return clazz;
    }
}

