# Eclipse GlassFish 7.x Downloads

## Eclipse GlassFish 7.0.24

Eclipse GlassFish is an application server, implementing Jakarta EE. This release is corresponding with the Jakarta EE 10 specification, which is a major new feature release. Jakarta EE 10 requires JDK 11 as a minimum, but also works on JDK 17 and JDK 21.

GlassFish 7.0.24 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 24. MicroProfile support requires JDK 17 or higher.

This release marks an important step forward by introducing support for JDK 24 in GlassFish 7 — a capability that had previously only been available in milestone builds of GlassFish 8. Achieving this required new versions of CORBA, ORB, and PFL, the result of many months of dedicated work by the team.

The team also undertook a significant revision of how scripts are used across the project. All Linux scripts now consistently use Bash, and a unified method has been adopted for resolving the AS_INSTALL path across all platforms. Additionally, an issue on Windows related to the %t placeholder—used in JDK log formatting—was resolved by ensuring it is properly escaped.

Faster Deployment was achieved by improved file handling; the team replaced custom file discovery with Files.walkFileTree and switched from URI to Path, also adopting try-with-resources for better resource management. On Windows 11, deployment time for specifically selected huge applications dropped from 110s to 100s, with potential for 92s using caching. YourKit profiling showed a 19s improvement in FileSystem.hasBooleanAttributes.

Download:

* [Eclipse GlassFish 7.0.24, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.24.zip) (zip)
  * [Maven coordinates](https://central.sonatype.com/artifact/org.glassfish.main.distributions/glassfish/7.0.24)
* [Eclipse GlassFish 7.0.24, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.24.zip) (zip)
  * [Maven coordinates](https://central.sonatype.com/artifact/org.glassfish.main.distributions/web/7.0.24)
* [Eclipse GlassFish Embedded 7.0.24, Jakarta EE Platform, 10](https://repo1.maven.org/maven2/org/glassfish/main/extras/glassfish-embedded-all/7.0.24/glassfish-embedded-all-7.0.24.jar) (jar)
  * [Maven coordinates](https://central.sonatype.com/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.24)
* [Eclipse GlassFish Embedded 7.0.24, Jakarta EE Web Profile, 10](https://repo1.maven.org/maven2/org/glassfish/main/extras/glassfish-embedded-web/7.0.24/glassfish-embedded-web-7.0.24.jar) (jar)
  * [Maven coordinates](https://central.sonatype.com/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.24)

More details:

* [Eclipse GlassFish 7.0.24 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.24)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE

## Eclipse GlassFish 7.0.23

Eclipse GlassFish is an application server, implementing Jakarta EE. This release is corresponding with the Jakarta EE 10 specification, which is a major new feature release. Jakarta EE 10 requires JDK 11 as a minimum, but also works on JDK 17 and JDK 21.

GlassFish 7.0.23 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 23. MicroProfile support requires JDK 17 or higher.

The key feature for this release is making SSH nodes work on the Windows operating system, and while at it improve the way they work on Linux. The team mainly focussed on this work, and a lot of effort went into it. We're really happy to have achieved the goal to have it fully working. Next to that some important fixes were done for logging and specifically a regression for the security principal was fixed.

Download:

* [Eclipse GlassFish 7.0.23, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.23.zip)
* [Eclipse GlassFish 7.0.23, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.23.zip)
* [Eclipse GlassFish Embedded 7.0.23, Jakarta EE Platform, 10](https://central.sonatype.com/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.23)
* [Eclipse GlassFish Embedded 7.0.23, Jakarta EE Web Profile, 10](https://central.sonatype.com/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.23)

More details:

* [Eclipse GlassFish 7.0.23 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.23)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE

## Eclipse GlassFish 7.0.22

Eclipse GlassFish is an application server, implementing Jakarta EE. This release is corresponding with the Jakarta EE 10 specification, which is a major new feature release. Jakarta EE 10 requires JDK 11 as a minimum, but also works on JDK 17 and JDK 21.

GlassFish 7.0.22 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 23. MicroProfile support requires JDK 17 or higher.

A smaller release while the OmniFish team is working on perfecting SSH in a separate feature branch. Still, a few important dependencies have been updated; notably Concurrō (Concurrency), EclipseLink (Persistence) and Jersey (REST). Furthermore, GlassFish has received a few security improvements: the admin flow login was improved by Alexander Pinčuk, and the OmniFish team improved the command logger, which now hides passwords in logged messages.

Download:

* [Eclipse GlassFish 7.0.22, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.22.zip)
* [Eclipse GlassFish 7.0.22, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.22.zip)
* [Eclipse GlassFish Embedded 7.0.22, Jakarta EE Platform, 10](https://central.sonatype.com/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.22)
* [Eclipse GlassFish Embedded 7.0.22, Jakarta EE Web Profile, 10](https://central.sonatype.com/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.22)

More details:

* [Eclipse GlassFish 7.0.22 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.22)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE

## Eclipse GlassFish 7.0.21

Eclipse GlassFish is an application server, implementing Jakarta EE. This release is corresponding with the Jakarta EE 10 specification, which is a major new feature release. Jakarta EE 10 requires JDK 11 as a minimum, but also works on JDK 17 and JDK 21.

GlassFish 7.0.21 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 23. MicroProfile support requires JDK 17 or higher.

This release was all about hunting down a few nasty bugs reported by GlassFish users: restart hanging on fast machines (including ephemeral ports appearing when stopping GlassFish), random 403 responses for authenticated sessions and Faces that was failing to initialize on GlassFish embedded. We're proud to announce that after a lot of research and a lot of work, we were able to squash them all. A special thanks to our users for reporting these and helping us to narrow them down!

Download:

* [Eclipse GlassFish 7.0.21, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.21.zip)
* [Eclipse GlassFish 7.0.21, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.21.zip)
* [Eclipse GlassFish Embedded 7.0.21, Jakarta EE Platform, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.21/jar)
* [Eclipse GlassFish Embedded 7.0.21, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.21/jar)

More details:

* [Eclipse GlassFish 7.0.21 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.21)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


## Eclipse GlassFish 7.0.20

Eclipse GlassFish is an application server, implementing Jakarta EE. This release is corresponding with the Jakarta EE 10 specification, which is a major new feature release. Jakarta EE 10 requires JDK 11 as a minimum, but also works on JDK 17 and JDK 21.

GlassFish 7.0.20 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 23. MicroProfile support requires JDK 17 or higher.

While working on GlassFish 7.1.0 and GlassFish 8, we didn't leave the stable 7.0.x series in the dark. In this release we updated a lot of our dependencies to their latest versions and did a large amount of testing to ensure everything worked as required. We also improved stability again by squashing a number of outstanding bugs.

Download:

* [Eclipse GlassFish 7.0.20, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.20.zip)
* [Eclipse GlassFish 7.0.20, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.20.zip)
* [Eclipse GlassFish Embedded 7.0.20, Jakarta EE Platform, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.20/jar)
* [Eclipse GlassFish Embedded 7.0.20, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.20/jar)

More details:

* [Eclipse GlassFish 7.0.20 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.20)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


## GlassFish 7.0.19

Eclipse GlassFish is an application server, implementing Jakarta EE. This release is corresponding with the Jakarta EE 10 specification, which is a major new feature release. Jakarta EE 10 requires JDK 11 as a minimum, but also works on JDK 17 and JDK 21.

GlassFish 7.0.19 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 23. MicroProfile support requires JDK 17 or higher.

This release is mostly just maintenance. It contains some updates, some code cleanup, few very important bug fixes and few new features to make your life easier.

Download:

* [Eclipse GlassFish 7.0.19, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.19.zip)
* [Eclipse GlassFish 7.0.19, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.19.zip)
* [Eclipse GlassFish Embedded 7.0.19, Jakarta EE Platform, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.19/jar)
* [Eclipse GlassFish Embedded 7.0.19, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.19/jar)

More details:

* [Eclipse GlassFish 7.0.19 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.19)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE

## GlassFish 7.0.18

Eclipse GlassFish is an application server, implementing Jakarta EE. This release is corresponding with the Jakarta EE 10 specification, which is a major new feature release. Jakarta EE 10 requires JDK 11 as a minimum, but also works on JDK 17 and JDK 21.

GlassFish 7.0.18 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 23. MicroProfile support requires JDK 17 or higher.

This release is all about an exciting new feature that allows running GlassFish Embedded from the command line using `java -jar glassfish-embedded.jar`. It supports configuration via command line arguments and/or config files in the current directory, such as setting the HTTP port, deploying applications passed as arguments and running arbitrary AsAdmin commands at boot. Aside of that we did a large amount of maintenance for the internal modules `nucleus-admin` and `glassfish`, and fixed various issues that were reported by users.

Download:

* [Eclipse GlassFish 7.0.18, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.18.zip)
* [Eclipse GlassFish 7.0.18, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.18.zip)
* [Eclipse GlassFish Embedded 7.0.18, Jakarta EE Platform, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.18/jar)
* [Eclipse GlassFish Embedded 7.0.18, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.18/jar)

More details:

* [Eclipse GlassFish 7.0.18 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.18)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE

### GlassFish 7.0.17

GlassFish 7.0.17 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 23. MicroProfile support requires JDK 17 or higher.

In this summer 2024 release of GlassFish we did a lot of maintenance in which we will continue in future releases. We fixed several security issues and the build now passes also in Java 23. We welcome feedback - if you notice that something doesn't work as expected, feel free to create an issue or even better create your own pull request.

Download:

* [Eclipse GlassFish 7.0.17, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.17.zip)
* [Eclipse GlassFish 7.0.17, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.17.zip)
* [Eclipse GlassFish Embedded 7.0.17, Jakarta EE Platform, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.17/jar)
* [Eclipse GlassFish Embedded 7.0.17, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.17/jar)

More details:

* [Eclipse GlassFish 7.0.17 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.17)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


### GlassFish 7.0.16

GlassFish 7.0.16 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 21. MicroProfile support requires JDK 17 or higher.

GlassFish 7.0.16 compiles and passes all internal tests using OpenJDK 21. The Jakarta EE 10 TCKs passed on JDK 21 as well. The Jakarta EE 10 TCK as a whole is now also JDK 21 compatible and it's possible to run all the Jakarta EE TCK tests.

In this summer 2024 release of GlassFish we added several new features. Specifically new is an admin command logger, which logs graphical interactions with the admin UI for usage in scripts. GlassFish now also allows resource references in persistence.xml, and we added a great new feature where we are creating temporary snapshots of the external application libraries during application startup, so any update of these is not longer system dependent. We also did a major refactoring of the aging TLS code and optimized the GJULE logging.

Download:

* [Eclipse GlassFish 7.0.16, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.16.zip)
* [Eclipse GlassFish 7.0.16, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.16.zip)
* [Eclipse GlassFish Embedded 7.0.16, Jakarta EE Platform, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.16/jar)
* [Eclipse GlassFish Embedded 7.0.16, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.16/jar)

More details:

* [Eclipse GlassFish 7.0.16 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.16)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


### GlassFish 7.0.15

GlassFish 7.0.15 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 21. MicroProfile support requires JDK 17 or higher.

GlassFish 7.0.15 compiles and passes all internal tests using OpenJDK 21. Several Jakarta EE 10 TCKs passed on JDK 21 as well. The Jakarta EE 10 TCK as a whole is not JDK 21 compatible and it's not possible to run all the Jakarta EE TCK tests.

In this release we updated and thoroughly tested a lot of important components, including Exousia (Security), Mojarra (Faces), Jersey (REST) and Yasson/Parsson (JSON).

Testing has been improved by fixing a number of issues within the tests itself.

Finally, we fixed a number of errors in the documentation.

Download:

* [Eclipse GlassFish 7.0.15, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.15.zip)
* [Eclipse GlassFish 7.0.15, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.15.zip)
* [Eclipse GlassFish Embedded 7.0.15, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.15/jar)
* [Eclipse GlassFish Embedded 7.0.15, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.15/jar)

More details:

* [Eclipse GlassFish 7.0.15 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.15)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


### GlassFish 7.0.14

GlassFish 7.0.14 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 21. MicroProfile support requires JDK 17 or higher.

GlassFish 7.0.14 compiles and passes all internal tests using OpenJDK 21. Several Jakarta EE 10 TCKs passed on JDK 21 as well. The Jakarta EE 10 TCK as a whole is not JDK 21 compatible and it's not possible to run all the Jakarta EE TCK tests.

This release features among others an important NPE fix for the SSHLauncher and is highly recommended for our users who make use of this launcher.

The thread safety of transactions was improved, and the JDBC connection pool sizing logic was also improved, fixing an annoying bug.

To maintain future quality of GlassFish, many fixes to the internal TCKs tests were done.

As a new feature, command completion is now enabled in the OSGi interactive console.

Download:

* [Eclipse GlassFish 7.0.14, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.14.zip)
* [Eclipse GlassFish 7.0.14, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.14.zip)
* [Eclipse GlassFish Embedded 7.0.14, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.14/jar)
* [Eclipse GlassFish Embedded 7.0.14, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.14/jar)

More details:

* [Eclipse GlassFish 7.0.14 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.14)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


### GlassFish 7.0.13

GlassFish 7.0.13 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 21. MicroProfile support requires JDK 17 or higher.

GlassFish 7.0.13 compiles and passes all internal tests using OpenJDK 21. Several Jakarta EE 10 TCKs passed on JDK 21 as well. The Jakarta EE 10 TCK as a whole is not JDK 21 compatible and it's not possible to run all the Jakarta EE TCK tests.

In the release for this month we replaced many synchronized blocks by reentrant locks (to accommodate JDK 21 virtual threads).

We also looked at SSO between clusters, and fixed a long standing bug there.

A long running investigation into potential resource leaks finally came to a conclusion, and resulted in many fixes throughout the code base. The admin console also saw various improvements, specifically with respect to loading.

Download:

* [Eclipse GlassFish 7.0.13, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.13.zip)
* [Eclipse GlassFish 7.0.13, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.13.zip)
* [Eclipse GlassFish Embedded 7.0.13, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.13/jar)
* [Eclipse GlassFish Embedded 7.0.13, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.13/jar)

More details:

* [Eclipse GlassFish 7.0.13 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.13)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


### GlassFish 7.0.12

GlassFish 7.0.12 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 21. MicroProfile support requires JDK 17 or higher.

GlassFish 7.0.12 compiles and passes all internal tests using OpenJDK 21. Several Jakarta EE 10 TCKs passed on JDK 21 as well. The Jakarta EE 10 TCK as a whole is not JDK 21 compatible and it's not possible to run all the Jakarta EE TCK tests.

This release we focused on finding and fixing the root cause of several "strange" WebSocket related bugs that we witnessed in the past. We also did a similar thing related to several issues with running apps on the default context root, especially where after authentication redirects happened to another URL.

Furthermore we looked into problems with authentication and SSO in a cluster and did some initial fixes. Handling and processing of logging was looked at once again, something we have been improving a lot step by step through various iterations of releases.

Finally but not least a nasty ConcurrentModificationException was fixed, and a memory leak (via HK2) was solved.

Download:

* [Eclipse GlassFish 7.0.12, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.12.zip)
* [Eclipse GlassFish 7.0.12, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.12.zip)
* [Eclipse GlassFish Embedded 7.0.12, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.12/jar)
* [Eclipse GlassFish Embedded 7.0.12, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.12/jar)

More details:

* [Eclipse GlassFish 7.0.12 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.12)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE

### GlassFish 7.0.11

GlassFish 7.0.11 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 21. MicroProfile support requires JDK 17 or higher.

GlassFish 7.0.11 compiles and passes all internal tests using OpenJDK 21. Several Jakarta EE 10 TCKs passed on JDK 21 as well. The Jakarta EE 10 TCK as a whole is not JDK 21 compatible and it's not possible to run all the Jakarta EE TCK tests.

This release sees an important fix where WebSockets would not work at all for applications on the default context root (e.g. https://example.com vs https://example.com/myapp).

This month we have concentrated on the AdminGUI and fixed an assortment of small but annoying defects in it. Various major components were updated, such as Jersey (Jakarta REST), Tyrus (Jakarta WebSockets) and Mojarra (Jakarta Faces).

To keep the project maintainable and well tested, several tests were added and improved as well.

Download:

* [Eclipse GlassFish 7.0.11, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.11.zip)
* [Eclipse GlassFish 7.0.11, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.11.zip)
* [Eclipse GlassFish Embedded 7.0.11, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.11/jar)
* [Eclipse GlassFish Embedded 7.0.11, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.11/jar)

More details:

* [Eclipse GlassFish 7.0.11 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.11)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


### GlassFish 7.0.10

GlassFish 7.0.10 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 21. MicroProfile support requires JDK 17 or higher.

This release is the second GlassFish release after OpenJDK 21 was released. GlassFish 7.0.10 compiles and passes all internal tests using OpenJDK 21. Several Jakarta EE 10 TCKs passed on JDK 21 as well. The Jakarta EE 10 TCK as a whole is not JDK 21 compatible and it's not possible to run all the Jakarta EE TCK tests.

In this release a 10 months long operation to get an internal dependency to the slf4j-api removed finally got to fruition. This involved the intense cooperation of multiple teams, and we're exceptionally happy to have finally been able to do this.

We also did a lot of work to make our builds repeatable, and we did a ton of refactoring to the internal security packages of GlassFish, making them easier to understand and therefore easier to maintain. Any external code depending on these internal packages (such as potentially custom LoginModules/Realms) may have to update (we recommend of course not depending on internal packages and using public APIs).

As every release, we integrated many component updates, and did a number of smaller fixes.

Download:

* [Eclipse GlassFish 7.0.10, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.10.zip)
* [Eclipse GlassFish 7.0.10, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.10.zip)
* [Eclipse GlassFish Embedded 7.0.10, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.10/jar)
* [Eclipse GlassFish Embedded 7.0.10, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.10/jar)

More details:

* [Eclipse GlassFish 7.0.10 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.10)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE

### GlassFish 7.0.9

GlassFish 7.0.9 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 21. MicroProfile support requires JDK 17 or higher.

This release is the first GlassFish release after OpenJDK 21 was released. GlassFish 7.0.9 compiles and passes all internal tests using OpenJDK 21. Several Jakarta EE 10 TCKs passed on JDK 21 as well. The Jakarta EE 10 TCK as a whole is not JDK 21 compatible and it's not possible to run all the Jakarta EE TCK tests.

In this release the modularity of GlassFish is once again increased by moving the Jakarta Authentication implementation code to a new standalone project: [Epicyro](https://github.com/eclipse-ee4j/epicyro). We also enabled the GlassFish embedded tests again, which were dormant for a long time. Among the many updated components, Exousia was updated specifically to fix a bug with deployments on virtual servers, and the ORB was updated to fix a somewhat obscure bug where a remote EJB returned a JDK defined enum type.

Download:

* [Eclipse GlassFish 7.0.9, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.9.zip)
* [Eclipse GlassFish 7.0.9, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.9.zip)
* [Eclipse GlassFish Embedded 7.0.9, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.9/jar)
* [Eclipse GlassFish Embedded 7.0.9, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.9/jar)

More details:

* [Eclipse GlassFish 7.0.9 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.9)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE

### GlassFish 7.0.8

GlassFish 7.0.8 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 21ea33. MicroProfile support requires JDK 17 or higher.

This release prepares GlassFish for the upcoming JDK 21; it compiles and passes all internal tests using OpenJDK 21ea35. Several TCKs passed on JDK 21 as well, but the TCK as a whole is not JDK 21 compatible yet.

This release fixes multi-jar compatibility in GlassFish and does further preparations for JDK 21. It includes various component updates among which those for CDI, Faces, and JSON. Test coverage is improved by adding the TCKs for REST Client and Connectors. Finally, various CDI extensions have been optimised to reduce excessive and unnecessary calls to them.

Download:

* [Eclipse GlassFish 7.0.8, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.8.zip)
* [Eclipse GlassFish 7.0.8, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.8.zip)
* [Eclipse GlassFish Embedded 7.0.8, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.8/jar)
* [Eclipse GlassFish Embedded 7.0.8, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.8/jar)

More details:

* [Eclipse GlassFish 7.0.8 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.8)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE




### GlassFish 7.0.7

GlassFish 7.0.7 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 21ea33. MicroProfile support requires JDK 17 or higher.

This release prepares GlassFish for the upcoming JDK 21; it compiles and passes all internal tests using OpenJDK 21ea33. Several TCKs passed on JDK 21 as well, but the TCK as a whole is not JDK 21 compatible yet.

This release also adds support for MicroProfile JWT 2.1, and has many components updated to their latest version. Several issues have again been fixed in the Admin Console. An important bug regarding Enterprise Beans method generation has been fixed, as has a remote access issue for Enterprise Beans.

Download:

* [Eclipse GlassFish 7.0.7, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.7.zip)
* [Eclipse GlassFish 7.0.7, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.7.zip)
* [Eclipse GlassFish Embedded 7.0.7, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.7/jar)
* [Eclipse GlassFish Embedded 7.0.7, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.7/jar)

More details:

* [Eclipse GlassFish 7.0.7 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.7)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


### GlassFish 7.0.6

GlassFish 7.0.6 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 20. MicroProfile support requires JDK 17 or higher.

The main features of this release are the newly added support of the MicroProfile REST Client and a new way to start GlassFish, which is a preparation for Docker images that will run GlassFish in the foreground in a single JVM process to save memory consumed by Docker containers.

This release also contains the usual amount of fixes, and a number of important component updates. Specifically the EclipseLink and Soteria updates fix important bugs (see their release notes).

Download:

* [Eclipse GlassFish 7.0.6, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.6.zip)
* [Eclipse GlassFish 7.0.6, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.6.zip)
* [Eclipse GlassFish Embedded 7.0.6, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.6/jar)
* [Eclipse GlassFish Embedded 7.0.6, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.6/jar)

More details:

* [Eclipse GlassFish 7.0.6 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.6)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


### GlassFish 7.0.5

GlassFish 7.0.5 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 20. MicroProfile support requires JDK 17 or higher.

The main features of this release are a number of important bug fixes such as one in deployment-time recursive bytecode, resetting the security context if a principal has not changed, and several fixes in clustering.

Jakarta EE components have been updated for Mail, JSON Processing, and REST. Auxiliary components such as Jackson and Commons IO have also been updated to their latest version.

Download:

* [Eclipse GlassFish 7.0.5, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.5.zip)
* [Eclipse GlassFish 7.0.5, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.5.zip)
* [Eclipse GlassFish Embedded 7.0.5, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.5/jar)
* [Eclipse GlassFish Embedded 7.0.5, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.5/jar)

More details:

* [Eclipse GlassFish 7.0.5 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.5)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


### GlassFish 7.0.4

GlassFish 7.0.4 is a final release, containing final Jakarta EE 10 APIs. It compiles and runs on JDK 11 to JDK 20. MicroProfile support requires JDK 17 or higher.

The main features of this release are important bug fixes for things like a class loader leak, and again several fixes in the admin console such as the ability to upload a war file.

A new feature for ScatteredArchive has been added to GlassFsih Embedded.

Download:

* [Eclipse GlassFish 7.0.4, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.4.zip)
* [Eclipse GlassFish 7.0.4, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.4.zip)
* [Eclipse GlassFish Embedded 7.0.4, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.4/jar)
* [Eclipse GlassFish Embedded 7.0.4, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.4/jar)

More details:

* [Eclipse GlassFish 7.0.4 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.4)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


### GlassFish 7.0.3

Eclipse GlassFish 7.0.3 is the third maintenance update of GlassFish 7. It compiles and runs on JDK 11 to JDK 20. MicroProfile support requires JDK 17 or higher.

Download:

* [Eclipse GlassFish 7.0.3, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.3.zip)
* [Eclipse GlassFish 7.0.3, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.3.zip)
* [Eclipse GlassFish Embedded 7.0.3, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.3/jar)
* [Eclipse GlassFish Embedded 7.0.3, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.3/jar)

More details:

* [Eclipse GlassFish 7.0.3 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.3)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


### GlassFish 7.0.2

Eclipse GlassFish 7.0.2 is the second maintenance update of GlassFish 7. It compiles and runs on JDK 11 to JDK 19. MicroProfile support requires JDK 17 or higher. Compiling and running on JDK 20ea has been sucesfully tested, but is not yet officially supported.

Download:

* [Eclipse GlassFish 7.0.2, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.2.zip)
* [Eclipse GlassFish 7.0.2, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.2.zip)
* [Eclipse GlassFish Embedded 7.0.2, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.2/jar)
* [Eclipse GlassFish Embedded 7.0.2, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.2/jar)

More details:

* [Eclipse GlassFish 7.0.2 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.2)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


### GlassFish 7.0.1

Eclipse GlassFish 7.0.1 is the first maintenance update of GlassFish 7. It compiles and runs on JDK 11 to JDK 19. MicroProfile support requires JDK 17 or higher. Compiling and running on JDK 20ea has been sucesfully tested, but is not yet officially supported.

Download:

* [Eclipse GlassFish 7.0.1, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.1.zip)
* [Eclipse GlassFish 7.0.1, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.1.zip)
* [Eclipse GlassFish Embedded 7.0.1, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.1/jar)
* [Eclipse GlassFish Embedded 7.0.1, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.1/jar)

More details:

* [Eclipse GlassFish 7.0.1 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.1)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE


### GlassFish 7.0.0

Eclipse GlassFish 7.0.0 is a final release, containing final [Jakarta EE 10](https://jakarta.ee/specifications/platform/10) APIs and final Jakarta EE 10 implementation components. It compiles and runs on JDK 11 to JDK 19. MicroProfile support requires JDK 17 or higher.

Download:

* [Eclipse GlassFish 7.0.0, Jakarta EE Platform, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/glassfish-7.0.0.zip)
* [Eclipse GlassFish 7.0.0, Jakarta EE Web Profile, 10](https://www.eclipse.org/downloads/download.php?file=/ee4j/glassfish/web-7.0.0.zip)
* [Eclipse GlassFish Embedded 7.0.0, Jakarta EE Full Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-all/7.0.0/jar)
* [Eclipse GlassFish Embedded 7.0.0, Jakarta EE Web Profile, 10](https://search.maven.org/artifact/org.glassfish.main.extras/glassfish-embedded-web/7.0.0/jar)

More details:

* [Eclipse GlassFish 7.0.0 Release Notes](https://github.com/eclipse-ee4j/glassfish/releases/tag/7.0.0)
* [Jakarte EE Specifications](https://jakarta.ee/specifications/) for more info about Jakarta EE
