/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.diagnostics.context.impl;

import java.util.EnumSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.contextpropagation.Location;
import org.glassfish.contextpropagation.PropagationMode;
import org.glassfish.contextpropagation.View;
import org.glassfish.contextpropagation.ViewCapable;
import org.glassfish.diagnostics.context.Context;
import org.glassfish.diagnostics.context.ContextManager;
import org.glassfish.diagnostics.context.impl.ContextManagerImpl;

public class ContextImpl
implements Context,
ViewCapable {
    private static final Logger LOGGER = ContextManager.LOGGER;
    private static final String CLASS_NAME = ContextImpl.class.getName();
    private final View mView;
    private final Location mLocation;

    ContextImpl(View view, Location location) {
        if (view == null || location == null) {
            throw new IllegalArgumentException((view == null ? "View must not be null. " : "") + (location == null ? "Location must not be null" : ""));
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "<init>", "(view, location{" + location.getOrigin() + "," + location.getLocationId() + "})");
        }
        this.mView = view;
        this.mLocation = location;
    }

    @Override
    public Location getLocation() {
        return this.mLocation;
    }

    @Override
    public <T> T put(String name, String value, boolean propagates) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "put(String, String, boolean)", "{" + this.mLocation.getOrigin() + "," + this.mLocation.getLocationId() + "}(" + name + "," + value + "," + Boolean.toString(propagates) + ")");
        }
        EnumSet<PropagationMode> propagationModes = propagates ? ContextManagerImpl.sfGlobalPropagationModes : ContextManagerImpl.sfLocalPropagationModes;
        Object retVal = this.mView.put(name, value, propagationModes);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "put(String, String, boolean)", "{" + this.mLocation.getOrigin() + "," + this.mLocation.getLocationId() + "} returning " + String.valueOf(retVal));
        }
        return (T)retVal;
    }

    @Override
    public <T> T put(String name, Number value, boolean propagates) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "put(String, Number, boolean)", "{" + this.mLocation.getOrigin() + "," + this.mLocation.getLocationId() + "}(" + name + "," + String.valueOf(value) + "," + Boolean.toString(propagates) + ")");
        }
        EnumSet<PropagationMode> propagationModes = propagates ? ContextManagerImpl.sfGlobalPropagationModes : ContextManagerImpl.sfLocalPropagationModes;
        Object retVal = this.mView.put(name, value, propagationModes);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "put(String, Number, boolean)", "{" + this.mLocation.getOrigin() + "," + this.mLocation.getLocationId() + "} returning " + String.valueOf(retVal));
        }
        return (T)retVal;
    }

    @Override
    public <T> T get(String name) {
        Object retVal = this.mView.get(name);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "get(String)", "{" + this.mLocation.getOrigin() + "," + this.mLocation.getLocationId() + "}(" + name + ") returning " + String.valueOf(retVal));
        }
        return (T)retVal;
    }

    @Override
    public <T> T remove(String name) {
        Object retVal = this.mView.remove(name);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.logp(Level.FINER, CLASS_NAME, "remove(String)", "{" + this.mLocation.getOrigin() + "," + this.mLocation.getLocationId() + "}(" + name + ") returning " + String.valueOf(retVal));
        }
        return (T)retVal;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ContextImpl:");
        sb.append("{location:").append(this.mLocation.getOrigin()).append(",").append(this.mLocation.getLocationId()).append("}");
        sb.append("}");
        return sb.toString();
    }
}

