/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.diagnostics.context.impl;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.logging.Level;
import org.glassfish.contextpropagation.ContextMap;
import org.glassfish.contextpropagation.ContextViewFactory;
import org.glassfish.contextpropagation.InsufficientCredentialException;
import org.glassfish.contextpropagation.Location;
import org.glassfish.contextpropagation.PropagationMode;
import org.glassfish.contextpropagation.View;
import org.glassfish.contextpropagation.spi.ContextMapHelper;
import org.glassfish.diagnostics.context.Context;
import org.glassfish.diagnostics.context.ContextManager;
import org.glassfish.diagnostics.context.impl.ContextImpl;
import org.glassfish.hk2.api.Rank;
import org.jvnet.hk2.annotations.Service;

@Service
@Rank(value=500)
public class ContextManagerImpl
implements ContextManager {
    private static final String CLASS_NAME = ContextManagerImpl.class.getName();
    private static final Context dummyContextInstance = new Context(){
        private final Location sLocation = new HackedUnavailableLocation();

        @Override
        public Location getLocation() {
            return this.sLocation;
        }

        @Override
        public <T> T put(String name, String value, boolean propagates) {
            return null;
        }

        @Override
        public <T> T put(String name, Number value, boolean propagates) {
            return null;
        }

        @Override
        public <T> T remove(String name) {
            return null;
        }

        @Override
        public <T> T get(String name) {
            return null;
        }
    };
    private static final String CAN_NOT_GET_CONTEXT_AS_DIAG_3000 = "AS-DIAG-3000";
    private static final String EXCEPTION_CREATING_CONTEXT_AS_DIAG_3001 = "AS-DIAG-3001";
    static final EnumSet<PropagationMode> sfGlobalPropagationModes = EnumSet.of(PropagationMode.THREAD, new PropagationMode[]{PropagationMode.RMI, PropagationMode.JMS_QUEUE, PropagationMode.SOAP, PropagationMode.MIME_HEADER, PropagationMode.ONEWAY});
    static final EnumSet<PropagationMode> sfLocalPropagationModes = EnumSet.of(PropagationMode.LOCAL);

    @Override
    public Context getContext() {
        LOGGER.entering(CLASS_NAME, "getContext()");
        Context retVal = null;
        ContextMap contextMap = ContextMapHelper.getScopeAwareContextMap();
        try {
            retVal = (Context)contextMap.get("org.glassfish.diagnostics.context.Context");
            if (retVal == null) {
                LOGGER.logp(Level.FINEST, CLASS_NAME, "getContext()", "No ContextImpl found in ContextMap, creating a new one.");
                ContextImpl contextImpl = (ContextImpl)contextMap.createViewCapable("org.glassfish.diagnostics.context.Context");
                retVal = contextImpl;
            }
        }
        catch (InsufficientCredentialException isce) {
            LOGGER.logp(Level.WARNING, CLASS_NAME, "getContext()", EXCEPTION_CREATING_CONTEXT_AS_DIAG_3001, isce);
            retVal = dummyContextInstance;
        }
        if (retVal == null) {
            LOGGER.logp(Level.WARNING, CLASS_NAME, "getContext()", CAN_NOT_GET_CONTEXT_AS_DIAG_3000);
            retVal = dummyContextInstance;
        }
        LOGGER.exiting(CLASS_NAME, "getContext()", retVal);
        return retVal;
    }

    static {
        HashSet<Object> tmp = new HashSet(PropagationMode.defaultSetOneway());
        tmp.removeAll(sfGlobalPropagationModes);
        if (!tmp.isEmpty()) {
            throw new IllegalStateException("Mismatched propagation modes - PropagationMode.defaultSetOneWay() has more modes than sfGlobalPropagationModes.");
        }
        tmp = new HashSet<PropagationMode>(sfGlobalPropagationModes);
        tmp.removeAll(PropagationMode.defaultSetOneway());
        if (!tmp.isEmpty()) {
            throw new IllegalStateException("Mismatched propagation modes - sfGlobalPropagationModes has more modes than PropagationMode.defaultSetOneWay().");
        }
        LOGGER.entering(CLASS_NAME, "<clinit::registration of DiagnosticContextViewFactory with ContextMapHelper>");
        ContextMapHelper.registerContextFactoryForPrefixNamed((String)"org.glassfish.diagnostics.context.Context", (ContextViewFactory)new DiagnosticContextViewFactory());
        LOGGER.exiting(CLASS_NAME, "<clinit::registration of DiagnosticContextViewFactory with ContextMapHelper>");
    }

    private static class DiagnosticContextViewFactory
    implements ContextViewFactory {
        private DiagnosticContextViewFactory() {
        }

        public ContextImpl createInstance(View view) {
            ContextManager.LOGGER.entering(CLASS_NAME, "createInstance(View)");
            Location location = ContextMapHelper.getScopeAwareContextMap().getLocation();
            ContextImpl retVal = new ContextImpl(view, location);
            ContextManager.LOGGER.exiting(CLASS_NAME, "createInstance(View)", retVal.toString());
            return retVal;
        }

        public EnumSet<PropagationMode> getPropagationModes() {
            return sfGlobalPropagationModes;
        }
    }

    private static class HackedUnavailableLocation
    extends Location {
        HackedUnavailableLocation() {
            super((View)null);
        }

        public String getLocationId() {
            return "<unavailable>";
        }

        public String getOrigin() {
            return "<unavailable>";
        }
    }
}

