/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.javaee.full.deployment;

import com.sun.enterprise.deployment.EarType;
import java.io.IOException;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.deployment.archive.ArchiveDetector;
import org.glassfish.api.deployment.archive.ArchiveHandler;
import org.glassfish.api.deployment.archive.ArchiveType;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.hk2.Services;
import org.glassfish.javaee.full.deployment.EarSniffer;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Singleton;

@Service(name="ear")
@Scoped(value=Singleton.class)
public class EarDetector
implements ArchiveDetector {
    public static final String EAR_DETECTOR_RANK_PROP = "glassfish.ear.detector.rank";
    public static final int DEFAULT_EAR_DETECTOR_RANK = 100;
    public static final String ARCHIVE_TYPE = "ear";
    @Inject
    private Services services;
    @Inject
    private EarSniffer sniffer;
    @Inject
    private EarType archiveType;
    private ArchiveHandler archiveHandler;
    private Logger logger = Logger.getLogger(this.getClass().getPackage().getName());

    public int rank() {
        return Integer.getInteger(EAR_DETECTOR_RANK_PROP, 100);
    }

    public boolean handles(ReadableArchive archive) throws IOException {
        return DeploymentUtils.isEAR((ReadableArchive)archive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArchiveHandler getArchiveHandler() {
        EarDetector earDetector = this;
        synchronized (earDetector) {
            if (this.archiveHandler == null) {
                try {
                    this.sniffer.setup(null, this.logger);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.archiveHandler = (ArchiveHandler)this.services.forContract(ArchiveHandler.class).named(ARCHIVE_TYPE).get();
            }
            return this.archiveHandler;
        }
    }

    public ArchiveType getArchiveType() {
        return this.archiveType;
    }
}

