/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.deploy.shared;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.api.deployment.archive.ReadableArchiveFactory;
import org.glassfish.api.deployment.archive.WritableArchive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.hk2.api.MultiException;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class ArchiveFactory {
    @Inject
    ServiceLocator habitat;
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    private static final String IMPLEMENTATION_NOT_FOUND = "NCLS-DEPLOYMENT-00021";

    public WritableArchive createArchive(File path) throws IOException {
        try {
            return this.createArchive(ArchiveFactory.prepareArchiveURI(path));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public WritableArchive createArchive(String protocol, File path) throws IOException {
        try {
            return this.createArchive(protocol, ArchiveFactory.prepareArchiveURI(path));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public ReadableArchive openArchive(File path) throws IOException {
        try {
            return this.openArchive(ArchiveFactory.prepareArchiveURI(path));
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public WritableArchive createArchive(URI path) throws IOException {
        String protocol = path.getScheme();
        return this.createArchive(protocol, path);
    }

    public WritableArchive createArchive(String protocol, URI path) throws IOException {
        try {
            WritableArchive archive = (WritableArchive)this.habitat.getService(WritableArchive.class, protocol, new Annotation[0]);
            if (archive == null) {
                deplLogger.log(Level.SEVERE, IMPLEMENTATION_NOT_FOUND, protocol);
                throw new MalformedURLException("Protocol not supported : " + protocol);
            }
            archive.create(path);
            return archive;
        }
        catch (MultiException e) {
            LogRecord lr = new LogRecord(Level.SEVERE, IMPLEMENTATION_NOT_FOUND);
            lr.setParameters(new Object[]{protocol});
            lr.setThrown(e);
            deplLogger.log(lr);
            throw new MalformedURLException("Protocol not supported : " + protocol);
        }
    }

    public ReadableArchive openArchive(File path, DeployCommandParameters properties) throws IOException {
        URI uri;
        try {
            uri = ArchiveFactory.prepareArchiveURI(path);
        }
        catch (URISyntaxException e) {
            return null;
        }
        for (ReadableArchiveFactory fac : this.habitat.getAllServices(ReadableArchiveFactory.class, new Annotation[0])) {
            ReadableArchive archive = null;
            try {
                archive = fac.open(uri, properties);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (archive == null) continue;
            return archive;
        }
        return this.openArchive(path);
    }

    public ReadableArchive openArchive(URI path) throws IOException {
        String provider = path.getScheme();
        if (provider.equals("file")) {
            File f = new File(path);
            if (!f.exists()) {
                throw new FileNotFoundException(f.getPath());
            }
            if (f.isFile()) {
                provider = "jar";
            }
        }
        try {
            ReadableArchive archive = (ReadableArchive)this.habitat.getService(ReadableArchive.class, provider, new Annotation[0]);
            if (archive == null) {
                deplLogger.log(Level.SEVERE, IMPLEMENTATION_NOT_FOUND, provider);
                throw new MalformedURLException("Protocol not supported : " + provider);
            }
            archive.open(path);
            return archive;
        }
        catch (MultiException e) {
            LogRecord lr = new LogRecord(Level.SEVERE, IMPLEMENTATION_NOT_FOUND);
            lr.setParameters(new Object[]{provider});
            lr.setThrown(e);
            deplLogger.log(lr);
            throw new MalformedURLException("Protocol not supported : " + provider);
        }
    }

    static URI prepareArchiveURI(File path) throws URISyntaxException, UnsupportedEncodingException, IOException {
        URI archiveURI = path.toURI();
        URI answer = new URI(archiveURI.getScheme(), null, archiveURI.getPath(), null, null);
        return answer;
    }
}

