/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.autodeploy;

import java.io.File;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.deployment.autodeploy.AutoDeployer;
import org.glassfish.deployment.autodeploy.AutoDeploymentException;
import org.glassfish.deployment.autodeploy.AutoOperation;
import org.glassfish.deployment.autodeploy.AutodeployRetryManager;
import org.glassfish.deployment.common.DeploymentProperties;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service
@PerLookup
public class AutoDeploymentOperation
extends AutoOperation {
    private boolean renameOnSuccess;
    private static final String COMMAND_NAME = "deploy";
    @Inject
    @Named(value="deploy")
    private AdminCommand deployCommand;
    @Inject
    private AutodeployRetryManager retryManager;
    public static final Logger deplLogger = AutoDeployer.deplLogger;
    private static final String CREATE_FILE_FAILED = "NCLS-DEPLOYMENT-00034";

    static AutoDeploymentOperation newInstance(ServiceLocator habitat, boolean renameOnSuccess, File file, boolean enabled, String virtualServer, boolean forceDeploy, boolean verify, boolean preJspCompilation, String target) {
        AutoDeploymentOperation o = (AutoDeploymentOperation)habitat.getService(AutoDeploymentOperation.class, new Annotation[0]);
        o.init(renameOnSuccess, file, enabled, virtualServer, forceDeploy, verify, preJspCompilation, target);
        return o;
    }

    protected AutoDeploymentOperation init(boolean renameOnSuccess, File file, boolean enabled, String virtualServer, boolean forceDeploy, boolean verify, boolean preJspCompilation, String target) {
        super.init(file, AutoDeploymentOperation.getDeployActionProperties(file, enabled, virtualServer, forceDeploy, verify, preJspCompilation, target), COMMAND_NAME, this.deployCommand);
        this.renameOnSuccess = renameOnSuccess;
        return this;
    }

    @Override
    protected String getMessageString(AutoDeployer.AutodeploymentStatus ds, File file) {
        return localStrings.getLocalString(ds.deploymentMessageKey, ds.deploymentDefaultMessage, new Object[]{file});
    }

    @Override
    protected void markFiles(AutoDeployer.AutodeploymentStatus ds, File file) {
        if (ds != AutoDeployer.AutodeploymentStatus.SUCCESS && ds != AutoDeployer.AutodeploymentStatus.WARNING) {
            try {
                this.retryManager.recordFailedDeployment(file);
            }
            catch (AutoDeploymentException ex) {
                this.markDeployFailed(file);
                this.retryManager.endMonitoring(file);
            }
        } else {
            this.retryManager.recordSuccessfulDeployment(file);
            if (ds.status) {
                if (this.renameOnSuccess) {
                    this.markDeployed(file);
                }
            } else {
                this.markDeployFailed(file);
            }
        }
    }

    private void markDeployed(File f) {
        try {
            this.deleteAllMarks(f);
            File deployedFile = this.getDeployedFile(f);
            if (!deployedFile.createNewFile()) {
                deplLogger.log(Level.WARNING, CREATE_FILE_FAILED, deployedFile.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void markDeployFailed(File f) {
        try {
            this.deleteAllMarks(f);
            File deployFailedFile = this.getDeployFailedFile(f);
            if (!deployFailedFile.createNewFile()) {
                deplLogger.log(Level.WARNING, CREATE_FILE_FAILED, deployFailedFile.getAbsolutePath());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static Properties getDeployActionProperties(File deployablefile, boolean enabled, String virtualServer, boolean forceDeploy, boolean verify, boolean jspPreCompilation, String target) {
        DeploymentProperties dProps = new DeploymentProperties();
        dProps.setPath(deployablefile.getAbsolutePath());
        dProps.setEnabled(enabled);
        if (virtualServer != null) {
            dProps.setVirtualServers(virtualServer);
        }
        dProps.setForce(forceDeploy);
        dProps.setVerify(verify);
        dProps.setPrecompileJSP(jspPreCompilation);
        dProps.setProperty("logReportedErrors", "false");
        return dProps;
    }
}

