/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Domain;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.Supplemental;
import org.glassfish.api.deployment.DeployCommandParameters;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.deployment.admin.DeployCommandSupplementalInfo;
import org.glassfish.deployment.admin.InterceptorNotifier;
import org.glassfish.deployment.common.DeploymentUtils;
import org.glassfish.internal.deployment.Deployment;
import org.glassfish.internal.deployment.ExtendedDeploymentContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_postdeploy")
@Supplemental(value="deploy", ifFailure=FailurePolicy.Warn)
@Scoped(value=PerLookup.class)
@ExecuteOn(value={RuntimeType.DAS})
@RestEndpoints(value={@RestEndpoint(configBean=Domain.class, opType=RestEndpoint.OpType.POST, path="_postdeploy", description="_postdeploy")})
public class PostDeployCommand
extends DeployCommandParameters
implements AdminCommand {
    @Inject
    private Habitat habitat;
    @Inject
    private Deployment deployment;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        Logger logger = context.getLogger();
        DeployCommandSupplementalInfo suppInfo = (DeployCommandSupplementalInfo)context.getActionReport().getResultType(DeployCommandSupplementalInfo.class);
        ExtendedDeploymentContext dc = suppInfo.deploymentContext();
        DeployCommandParameters params = (DeployCommandParameters)dc.getCommandParameters(DeployCommandParameters.class);
        InterceptorNotifier notifier = new InterceptorNotifier(this.habitat, (DeploymentContext)dc);
        if (DeploymentUtils.isDASTarget((String)params.target)) {
            return;
        }
        try {
            ParameterMap paramMap = this.deployment.prepareInstanceDeployParamMap((DeploymentContext)dc);
            List<String> targets = new ArrayList<String>();
            if (!DeploymentUtils.isDomainTarget((String)params.target)) {
                targets.add(params.target);
            } else {
                targets = suppInfo.previousTargets();
            }
            ClusterOperationUtil.replicateCommand((String)"_deploy", (FailurePolicy)FailurePolicy.Warn, (FailurePolicy)FailurePolicy.Warn, (FailurePolicy)FailurePolicy.Ignore, targets, (AdminCommandContext)context, (ParameterMap)paramMap, (Habitat)this.habitat);
            notifier.ensureAfterReported(ExtendedDeploymentContext.Phase.REPLICATION);
        }
        catch (Exception e) {
            report.failure(logger, e.getMessage());
        }
    }
}

