/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.HttpService;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.VirtualServer;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.util.StringUtils;
import com.sun.grizzly.config.dom.Http;
import com.sun.grizzly.config.dom.NetworkListener;
import com.sun.grizzly.config.dom.Protocol;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RuntimeType;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_get-host-and-port")
@ExecuteOn(value={RuntimeType.DAS})
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
public class GetHostAndPortCommand
implements AdminCommand {
    @Param(optional=true)
    public String target = "server";
    @Param(optional=true)
    public String virtualServer = null;
    @Param(optional=true, defaultValue="false")
    public Boolean securityEnabled = false;
    @Param(optional=true)
    public String moduleId = null;
    @Inject
    Configs configs;
    @Inject
    Domain domain;
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(GetHostAndPortCommand.class);

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        ActionReport.MessagePart part = report.getTopMessagePart();
        HttpService httpService = null;
        HostAndPort hostAndPort = null;
        try {
            String configName = null;
            Server server = this.domain.getServerNamed(this.target);
            if (server != null) {
                configName = server.getConfigRef();
            } else {
                Cluster cluster = this.domain.getClusterNamed(this.target);
                if (cluster == null) {
                    throw new Exception("No such target:" + this.target);
                }
                configName = cluster.getConfigRef();
            }
            Config config = this.configs.getConfigByName(configName);
            httpService = config.getHttpService();
            if (httpService != null) {
                hostAndPort = this.getHostAndPortForRequest(httpService);
            }
        }
        catch (Exception e) {
            report.setMessage(e.getMessage());
            report.setActionExitCode(ActionReport.ExitCode.FAILURE);
            return;
        }
        if (hostAndPort != null) {
            part.setMessage(hostAndPort.getHost() + ":" + hostAndPort.getPort());
            part.addProperty("host", hostAndPort.getHost());
            part.addProperty("port", "" + hostAndPort.getPort());
        }
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private HostAndPort getHostAndPortForRequest(HttpService httpService) throws Exception {
        if (this.moduleId == null) {
            if (this.virtualServer == null) {
                return this.getHostAndPort(httpService, this.securityEnabled);
            }
            VirtualServer vs = httpService.getVirtualServerByName(this.virtualServer);
            if (vs == null) {
                throw new Exception("Virtual server: " + this.virtualServer + " does not exist!");
            }
            return this.getHostAndPort(httpService, vs, this.securityEnabled);
        }
        ApplicationRef appRef = this.domain.getApplicationRefInTarget(this.moduleId, this.target);
        List vsList = null;
        if (appRef != null) {
            vsList = StringUtils.parseStringList((String)appRef.getVirtualServers(), (String)" ,");
        }
        if (vsList == null) {
            return this.getHostAndPort(httpService, this.securityEnabled);
        }
        for (String virtualServer : vsList) {
            HostAndPort hp = this.getHostAndPort(httpService, httpService.getVirtualServerByName(virtualServer), this.securityEnabled);
            if (hp == null) continue;
            return hp;
        }
        return null;
    }

    private HostAndPort getHostAndPort(HttpService httpService, VirtualServer vs, boolean securityEnabled) {
        List virtualServerList = httpService.getVirtualServer();
        List httpListenerList = ((Config)httpService.getParent(Config.class)).getNetworkConfig().getNetworkListeners().getNetworkListener();
        for (VirtualServer virtualServer : virtualServerList) {
            String vsHttpListeners;
            if (!virtualServer.getId().equals(vs.getId()) || (vsHttpListeners = virtualServer.getNetworkListeners()) == null) continue;
            List vsHttpListenerList = StringUtils.parseStringList((String)vsHttpListeners, (String)" ,");
            for (String vsHttpListener : vsHttpListenerList) {
                for (NetworkListener httpListener : httpListenerList) {
                    Protocol protocol;
                    if (!httpListener.getName().equals(vsHttpListener) || !Boolean.valueOf(httpListener.getEnabled()).booleanValue() || Boolean.valueOf((protocol = httpListener.findHttpProtocol()).getSecurityEnabled()) != securityEnabled) continue;
                    String serverName = protocol.getHttp().getServerName();
                    if (serverName == null || serverName.trim().equals("")) {
                        serverName = this.getDefaultHostName();
                    }
                    String portStr = httpListener.getPort();
                    String redirPort = protocol.getHttp().getRedirectPort();
                    if (redirPort != null && !redirPort.trim().equals("")) {
                        portStr = redirPort;
                    }
                    int port = Integer.parseInt(portStr);
                    return new HostAndPort(serverName, port, securityEnabled);
                }
            }
        }
        return null;
    }

    private HostAndPort getHostAndPort(HttpService httpService, boolean securityEnabled) {
        List httpListenerList = ((Config)httpService.getParent(Config.class)).getNetworkConfig().getNetworkListeners().getNetworkListener();
        for (NetworkListener httpListener : httpListenerList) {
            Protocol protocol;
            Http http;
            if (!Boolean.valueOf(httpListener.getEnabled()).booleanValue() || (http = (protocol = httpListener.findHttpProtocol()).getHttp()).getDefaultVirtualServer().equals("__asadmin") || Boolean.valueOf(protocol.getSecurityEnabled()) != securityEnabled) continue;
            String serverName = http.getServerName();
            if (serverName == null || serverName.trim().equals("")) {
                serverName = this.getDefaultHostName();
            }
            String portStr = httpListener.getPort();
            String redirPort = http.getRedirectPort();
            if (redirPort != null && !redirPort.trim().equals("")) {
                portStr = redirPort;
            }
            int port = Integer.parseInt(portStr);
            return new HostAndPort(serverName, port, securityEnabled);
        }
        return null;
    }

    private String getDefaultHostName() {
        String defaultHostName = "localhost";
        try {
            InetAddress host = InetAddress.getLocalHost();
            defaultHostName = host.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return defaultHostName;
    }
}

