/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.admin;

import com.sun.enterprise.admin.util.ClusterOperationUtil;
import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.FailurePolicy;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.common.util.admin.ParameterMapExtractor;
import org.jvnet.hk2.component.Habitat;

public class DeploymentCommandUtils {
    private static final String COPY_IN_PLACE_ARCHIVE_PROP_NAME = "copy.inplace.archive";

    public static ActionReport.ExitCode replicateEnableDisableToContainingCluster(String commandName, Domain domain, String target, String appName, Habitat habitat, AdminCommandContext context, AdminCommand command) throws IllegalArgumentException, IllegalAccessException {
        Cluster containingCluster = domain.getClusterForInstance(target);
        if (containingCluster != null) {
            ParameterMapExtractor extractor = new ParameterMapExtractor(new Object[]{command});
            ParameterMap pMap = extractor.extract((Collection)Collections.EMPTY_LIST);
            pMap.set((Object)"DEFAULT", (Object)appName);
            return ClusterOperationUtil.replicateCommand((String)commandName, (FailurePolicy)FailurePolicy.Error, (FailurePolicy)FailurePolicy.Warn, (List)containingCluster.getInstances(), (AdminCommandContext)context, (ParameterMap)pMap, (Habitat)habitat);
        }
        return ActionReport.ExitCode.SUCCESS;
    }

    public static File renameUploadedFileOrCopyInPlaceFile(File finalUploadDir, File fileParam, Logger logger, ServerEnvironment env) throws IOException {
        if (fileParam == null) {
            return null;
        }
        File appsDir = env.getApplicationRepositoryPath();
        File result = fileParam;
        if (!fileParam.isDirectory() && !appsDir.toURI().relativize(fileParam.toURI()).isAbsolute()) {
            result = new File(finalUploadDir, fileParam.getName());
            FileUtils.renameFile((File)fileParam, (File)result);
            if (!result.setLastModified(fileParam.lastModified())) {
                logger.log(Level.FINE, "In renaming {0} to {1} could not setLastModified; continuing", new Object[]{fileParam.getAbsolutePath(), result.getAbsolutePath()});
            }
        } else {
            boolean copyInPlaceArchive = Boolean.valueOf(System.getProperty(COPY_IN_PLACE_ARCHIVE_PROP_NAME, "true"));
            if (!fileParam.isDirectory() && copyInPlaceArchive) {
                long startTime = System.currentTimeMillis();
                result = new File(finalUploadDir, fileParam.getName());
                FileUtils.copy((File)fileParam, (File)result);
                if (!result.setLastModified(fileParam.lastModified())) {
                    logger.log(Level.FINE, "Could not set lastModified for {0}; continuing", result.getAbsolutePath());
                }
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "*** In-place archive copy of {0} took {1} ms", new Object[]{fileParam.getAbsolutePath(), System.currentTimeMillis() - startTime});
                }
            }
        }
        return result;
    }
}

