/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.api;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.glassfish.internal.api.LazyEnumeration;

public class CompositeClassLoader
extends ClassLoader {
    private final Set<ClassLoader> classLoaders = Collections.synchronizedSet(new LinkedHashSet());

    public CompositeClassLoader() {
        super(null);
    }

    public void addClassLoader(ClassLoader classLoader) {
        if (classLoader != null) {
            this.classLoaders.add(classLoader);
        }
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        for (ClassLoader cl : this.classLoaders) {
            try {
                return cl.loadClass(name);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        throw new ClassNotFoundException(name);
    }

    @Override
    public URL getResource(String name) {
        for (ClassLoader cl : this.classLoaders) {
            URL resource = cl.getResource(name);
            if (resource == null) continue;
            return resource;
        }
        return null;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        if (this.classLoaders.size() == 1) {
            return this.classLoaders.iterator().next().getResources(name);
        }
        ArrayList enumerations = new ArrayList();
        for (ClassLoader cl : this.classLoaders) {
            enumerations.add(cl.getResources(name));
        }
        return new LazyEnumeration<URL>(enumerations);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        return this.loadClass(name);
    }

    @Override
    protected URL findResource(String name) {
        return this.getResource(name);
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.getResources(name);
    }

    public List<ClassLoader> getClassLoaders() {
        return new ArrayList<ClassLoader>(this.classLoaders);
    }

    static {
        CompositeClassLoader.registerAsParallelCapable();
    }
}

