/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.internal.grizzly;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import org.glassfish.grizzly.http.server.util.Mapper;
import org.glassfish.internal.grizzly.ContextMapper;
import org.jvnet.hk2.annotations.ContractProvided;
import org.jvnet.hk2.annotations.Service;

@Service
@ContractProvided(value=Mapper.class)
public class V3Mapper
extends ContextMapper {
    private static final String ADMIN_LISTENER = "admin-listener";
    private static final String ADMIN_VS = "__asadmin";

    public V3Mapper() {
    }

    public V3Mapper(Logger logger) {
        super(logger);
    }

    public void addWrapper(String hostName, String contextPath, String path, Object wrapper, boolean jspWildCard) {
        super.addWrapper(hostName, contextPath, path, wrapper, jspWildCard);
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Wrapper-Host: " + hostName + " contextPath " + contextPath + " wrapper " + wrapper + " path " + path + " jspWildcard " + jspWildCard);
        }
    }

    public synchronized void addHost(String name, String[] aliases, Object host) {
        if (ADMIN_LISTENER.equals(this.getId()) && !ADMIN_VS.equals(name) || !ADMIN_LISTENER.equals(this.getId()) && ADMIN_VS.equals(name)) {
            return;
        }
        super.addHost(name, aliases, host);
    }

    public void addContext(String hostName, String path, Object context, String[] welcomeResources, Context resources) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Context-Host: " + hostName + " path " + path + " context " + context + " port " + this.getPort());
        }
        if (ADMIN_LISTENER.equals(this.getId()) && !ADMIN_VS.equals(hostName) || !ADMIN_LISTENER.equals(this.getId()) && ADMIN_VS.equals(hostName)) {
            return;
        }
        if (this.adapter != null && "org.apache.catalina.connector.CoyoteAdapter".equals(this.adapter.getClass().getName())) {
            this.removeContext(hostName, path);
        }
        super.addContext(hostName, path, context, welcomeResources, resources);
    }
}

