/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl.managedbean;

import com.sun.enterprise.container.common.impl.managedbean.ManagedBeanNamingProxy;
import com.sun.enterprise.container.common.spi.InterceptorInvoker;
import com.sun.enterprise.container.common.spi.JCDIService;
import com.sun.enterprise.container.common.spi.JavaEEInterceptorBuilder;
import com.sun.enterprise.container.common.spi.JavaEEInterceptorBuilderFactory;
import com.sun.enterprise.container.common.spi.ManagedBeanManager;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.container.common.spi.util.InterceptorInfo;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.LifecycleCallbackDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.logging.LogDomains;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.glassfish.api.Startup;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.deployment.DeploymentContext;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.internal.api.PostStartup;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.deployment.Deployment;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="ManagedBeanManagerImpl")
public class ManagedBeanManagerImpl
implements ManagedBeanManager,
PostStartup,
PostConstruct,
EventListener {
    private static final Logger _logger = LogDomains.getLogger(ManagedBeanManagerImpl.class, (String)"javax.enterprise.system.core");
    @Inject
    private ComponentEnvManager compEnvManager;
    @Inject
    private InjectionManager injectionMgr;
    @Inject
    private GlassfishNamingManager namingManager;
    @Inject
    private Habitat habitat;
    @Inject
    private Events events;
    @Inject
    private ProcessEnvironment processEnv;
    private ProcessEnvironment.ProcessType processType;
    private Map<BundleDescriptor, Map<Object, JCDIService.JCDIInjectionContext>> jcdiManagedBeanInstanceMap = new HashMap<BundleDescriptor, Map<Object, JCDIService.JCDIInjectionContext>>();
    private Map<String, NamingObjectProxy> appClientManagedBeans = new HashMap<String, NamingObjectProxy>();

    public void postConstruct() {
        this.events.register((EventListener)this);
        this.processType = this.processEnv.getProcessType();
    }

    public Startup.Lifecycle getLifecycle() {
        return Startup.Lifecycle.SERVER;
    }

    public void event(EventListener.Event event) {
        if (event.is(Deployment.APPLICATION_LOADED)) {
            ApplicationInfo info = (ApplicationInfo)Deployment.APPLICATION_LOADED.getHook(event);
            this.loadManagedBeans(info);
            this.registerAppLevelDependencies(info);
        } else if (event.is(Deployment.APPLICATION_UNLOADED)) {
            ApplicationInfo info = (ApplicationInfo)Deployment.APPLICATION_UNLOADED.getHook(event);
            Application app = (Application)info.getMetaData(Application.class);
            this.doCleanup(app);
        } else if (event.is(Deployment.DEPLOYMENT_FAILURE)) {
            Application app = (Application)((DeploymentContext)Deployment.DEPLOYMENT_FAILURE.getHook(event)).getModuleMetaData(Application.class);
            this.doCleanup(app);
        }
    }

    private void doCleanup(Application app) {
        if (app != null) {
            this.unloadManagedBeans(app);
            this.unregisterAppLevelDependencies(app);
        }
    }

    private void registerAppLevelDependencies(ApplicationInfo appInfo) {
        Application app = (Application)appInfo.getMetaData(Application.class);
        if (app == null) {
            return;
        }
        try {
            this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)app);
        }
        catch (Exception e) {
            throw new RuntimeException("Error binding app-level env dependencies " + app.getAppName(), e);
        }
    }

    private void unregisterAppLevelDependencies(Application app) {
        if (app != null) {
            try {
                this.compEnvManager.unbindFromComponentNamespace((JndiNameEnvironment)app);
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Exception unbinding app objects", e);
            }
        }
    }

    private void loadManagedBeans(ApplicationInfo appInfo) {
        Application app = (Application)appInfo.getMetaData(Application.class);
        if (app == null) {
            return;
        }
        this.loadManagedBeans(app);
    }

    @Override
    public void loadManagedBeans(Application app) {
        for (BundleDescriptor bundle : app.getBundleDescriptors()) {
            if (!this.bundleEligible(bundle)) continue;
            boolean validationRequired = bundle instanceof EjbBundleDescriptor || bundle instanceof ApplicationClientDescriptor;
            for (ManagedBeanDescriptor next : bundle.getManagedBeans()) {
                try {
                    if (validationRequired) {
                        next.validate();
                    }
                    Set interceptorClasses = next.getAllInterceptorClasses();
                    Class<?> targetClass = bundle.getClassLoader().loadClass(next.getBeanClassName());
                    InterceptorInfo interceptorInfo = new InterceptorInfo();
                    interceptorInfo.setTargetClass(targetClass);
                    interceptorInfo.setInterceptorClassNames(interceptorClasses);
                    interceptorInfo.setPostConstructInterceptors(next.getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType.POST_CONSTRUCT));
                    interceptorInfo.setPreDestroyInterceptors(next.getCallbackInterceptors(LifecycleCallbackDescriptor.CallbackType.PRE_DESTROY));
                    if (next.hasAroundInvokeMethod()) {
                        interceptorInfo.setHasTargetClassAroundInvoke(true);
                    }
                    HashMap<Method, List> interceptorChains = new HashMap<Method, List>();
                    for (Method m : targetClass.getMethods()) {
                        interceptorChains.put(m, next.getAroundInvokeInterceptors(m));
                    }
                    interceptorInfo.setAroundInvokeInterceptorChains(interceptorChains);
                    interceptorInfo.setSupportRuntimeDelegate(true);
                    JavaEEInterceptorBuilderFactory interceptorBuilderFactory = (JavaEEInterceptorBuilderFactory)this.habitat.getByContract(JavaEEInterceptorBuilderFactory.class);
                    JavaEEInterceptorBuilder builder = interceptorBuilderFactory.createBuilder(interceptorInfo);
                    next.setInterceptorBuilder((Object)builder);
                    this.compEnvManager.bindToComponentNamespace((JndiNameEnvironment)next);
                    String jndiName = next.getGlobalJndiName();
                    ManagedBeanNamingProxy namingProxy = new ManagedBeanNamingProxy(next, this.habitat);
                    if (this.processType.isServer()) {
                        this.namingManager.publishObject(jndiName, (Object)namingProxy, true);
                        continue;
                    }
                    this.appClientManagedBeans.put(jndiName, namingProxy);
                }
                catch (Exception e) {
                    throw new RuntimeException("Error binding ManagedBean " + next.getBeanClassName() + " with name = " + next.getName(), e);
                }
            }
            this.jcdiManagedBeanInstanceMap.put(bundle, Collections.synchronizedMap(new HashMap()));
        }
    }

    @Override
    public Object getManagedBean(String globalJndiName) throws Exception {
        NamingObjectProxy proxy = this.appClientManagedBeans.get(globalJndiName);
        Object managedBean = null;
        if (proxy != null) {
            managedBean = proxy.create((Context)new InitialContext());
        }
        return managedBean;
    }

    @Override
    public void registerRuntimeInterceptor(Object interceptorInstance, BundleDescriptor bundle) {
        for (ManagedBeanDescriptor next : bundle.getManagedBeans()) {
            JavaEEInterceptorBuilder interceptorBuilder = (JavaEEInterceptorBuilder)next.getInterceptorBuilder();
            interceptorBuilder.addRuntimeInterceptor(interceptorInstance);
        }
    }

    @Override
    public void unloadManagedBeans(Application app) {
        for (BundleDescriptor bundle : app.getBundleDescriptors()) {
            if (!this.bundleEligible(bundle)) continue;
            Map<Object, JCDIService.JCDIInjectionContext> jcdiInstances = this.jcdiManagedBeanInstanceMap.remove(bundle);
            if (jcdiInstances != null) {
                for (JCDIService.JCDIInjectionContext next : jcdiInstances.values()) {
                    try {
                        next.cleanup(true);
                    }
                    catch (Exception e) {
                        _logger.log(Level.FINE, "Exception during JCDI cleanup for " + next, e);
                    }
                }
            }
            for (JCDIService.JCDIInjectionContext next : bundle.getManagedBeans()) {
                for (Object instance : next.getBeanInstances()) {
                    InterceptorInvoker invoker = (InterceptorInvoker)next.getSupportingInfoForBeanInstance(instance);
                    try {
                        invoker.invokePreDestroy();
                    }
                    catch (Exception e) {
                        _logger.log(Level.FINE, "Managed bean " + next.getBeanClassName() + " PreDestroy", e);
                    }
                }
                ComponentEnvManager compEnvManager = (ComponentEnvManager)this.habitat.getByContract(ComponentEnvManager.class);
                try {
                    compEnvManager.unbindFromComponentNamespace((JndiNameEnvironment)next);
                }
                catch (NamingException ne) {
                    _logger.log(Level.FINE, "Managed bean " + next.getBeanClassName() + " unbind", ne);
                }
                GlassfishNamingManager namingManager = (GlassfishNamingManager)this.habitat.getByContract(GlassfishNamingManager.class);
                String jndiName = next.getGlobalJndiName();
                if (this.processType.isServer()) {
                    try {
                        namingManager.unpublishObject(jndiName);
                    }
                    catch (NamingException ne) {
                        _logger.log(Level.FINE, "Error unpubishing managed bean " + next.getBeanClassName() + " with jndi name " + jndiName, ne);
                    }
                } else {
                    this.appClientManagedBeans.remove(jndiName);
                }
                next.clearAllBeanInstanceInfo();
            }
        }
    }

    private boolean bundleEligible(BundleDescriptor bundle) {
        boolean eligible = false;
        if (this.processType.isServer()) {
            eligible = bundle instanceof WebBundleDescriptor || bundle instanceof EjbBundleDescriptor;
        } else if (this.processType == ProcessEnvironment.ProcessType.ACC) {
            eligible = bundle instanceof ApplicationClientDescriptor;
        }
        return eligible;
    }

    @Override
    public <T> T createManagedBean(Class<T> managedBeanClass) throws Exception {
        ManagedBeanDescriptor managedBeanDesc = null;
        try {
            BundleDescriptor bundle = this.getBundle();
            managedBeanDesc = bundle.getManagedBeanByBeanClass(managedBeanClass.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.createManagedBean(managedBeanDesc, managedBeanClass);
    }

    @Override
    public <T> T createManagedBean(Class<T> managedBeanClass, boolean invokePostConstruct) throws Exception {
        ManagedBeanDescriptor managedBeanDesc = null;
        try {
            BundleDescriptor bundle = this.getBundle();
            managedBeanDesc = bundle.getManagedBeanByBeanClass(managedBeanClass.getName());
        }
        catch (Exception e) {
            // empty catch block
        }
        return this.createManagedBean(managedBeanDesc, managedBeanClass, invokePostConstruct);
    }

    @Override
    public <T> T createManagedBean(ManagedBeanDescriptor desc, Class<T> managedBeanClass) throws Exception {
        JCDIService jcdiService = (JCDIService)this.habitat.getByContract(JCDIService.class);
        BundleDescriptor bundleDescriptor = null;
        bundleDescriptor = desc == null ? this.getBundle() : desc.getBundleDescriptor();
        if (bundleDescriptor == null) {
            throw new IllegalStateException("Class " + managedBeanClass + " is not a valid EE ManagedBean class");
        }
        Object callerObject = null;
        if (jcdiService != null && jcdiService.isJCDIEnabled(bundleDescriptor)) {
            JCDIService.JCDIInjectionContext jcdiContext = jcdiService.createManagedObject(managedBeanClass, bundleDescriptor);
            callerObject = jcdiContext.getInstance();
            Map<Object, JCDIService.JCDIInjectionContext> bundleNonManagedObjs = this.jcdiManagedBeanInstanceMap.get(bundleDescriptor);
            bundleNonManagedObjs.put(callerObject, jcdiContext);
        } else {
            JavaEEInterceptorBuilder interceptorBuilder = (JavaEEInterceptorBuilder)desc.getInterceptorBuilder();
            T managedBean = managedBeanClass.newInstance();
            InterceptorInvoker interceptorInvoker = interceptorBuilder.createInvoker(managedBean);
            callerObject = interceptorInvoker.getProxy();
            Object[] interceptorInstances = interceptorInvoker.getInterceptorInstances();
            this.inject(managedBean, desc);
            for (int i = 0; i < interceptorInstances.length; ++i) {
                this.inject(interceptorInstances[i], desc);
            }
            interceptorInvoker.invokePostConstruct();
            desc.addBeanInstanceInfo(managedBean, (Object)interceptorInvoker);
        }
        return (T)callerObject;
    }

    @Override
    public <T> T createManagedBean(ManagedBeanDescriptor desc, Class<T> managedBeanClass, boolean invokePostConstruct) throws Exception {
        JCDIService jcdiService = (JCDIService)this.habitat.getByContract(JCDIService.class);
        BundleDescriptor bundleDescriptor = null;
        bundleDescriptor = desc == null ? this.getBundle() : desc.getBundleDescriptor();
        if (bundleDescriptor == null) {
            throw new IllegalStateException("Class " + managedBeanClass + " is not a valid EE ManagedBean class");
        }
        Object callerObject = null;
        if (jcdiService != null && jcdiService.isJCDIEnabled(bundleDescriptor)) {
            JCDIService.JCDIInjectionContext jcdiContext = jcdiService.createManagedObject(managedBeanClass, bundleDescriptor, invokePostConstruct);
            callerObject = jcdiContext.getInstance();
            Map<Object, JCDIService.JCDIInjectionContext> bundleNonManagedObjs = this.jcdiManagedBeanInstanceMap.get(bundleDescriptor);
            bundleNonManagedObjs.put(callerObject, jcdiContext);
        } else {
            JavaEEInterceptorBuilder interceptorBuilder = (JavaEEInterceptorBuilder)desc.getInterceptorBuilder();
            T managedBean = managedBeanClass.newInstance();
            InterceptorInvoker interceptorInvoker = interceptorBuilder.createInvoker(managedBean);
            callerObject = interceptorInvoker.getProxy();
            Object[] interceptorInstances = interceptorInvoker.getInterceptorInstances();
            this.inject(managedBean, desc);
            for (int i = 0; i < interceptorInstances.length; ++i) {
                this.inject(interceptorInstances[i], desc);
            }
            interceptorInvoker.invokePostConstruct();
            desc.addBeanInstanceInfo(managedBean, (Object)interceptorInvoker);
        }
        return (T)callerObject;
    }

    @Override
    public boolean isManagedBean(Object object) {
        JavaEEInterceptorBuilderFactory interceptorBuilderFactory = (JavaEEInterceptorBuilderFactory)this.habitat.getByContract(JavaEEInterceptorBuilderFactory.class);
        return interceptorBuilderFactory.isClientProxy(object);
    }

    private void inject(Object instance, ManagedBeanDescriptor managedBeanDesc) throws Exception {
        BundleDescriptor bundle = managedBeanDesc.getBundle();
        if (bundle instanceof EjbBundleDescriptor || bundle instanceof ApplicationClientDescriptor) {
            this.injectionMgr.injectInstance(instance, managedBeanDesc.getGlobalJndiName(), false);
        } else {
            this.injectionMgr.injectInstance(instance, (JndiNameEnvironment)bundle, false);
        }
    }

    @Override
    public void destroyManagedBean(Object managedBean) {
        this.destroyManagedBean(managedBean, true);
    }

    @Override
    public void destroyManagedBean(Object managedBean, boolean validate) {
        BundleDescriptor bundle = this.getBundle();
        JCDIService jcdiService = (JCDIService)this.habitat.getByContract(JCDIService.class);
        if (jcdiService != null && jcdiService.isJCDIEnabled(bundle)) {
            Map<Object, JCDIService.JCDIInjectionContext> bundleNonManagedObjs = this.jcdiManagedBeanInstanceMap.get(bundle);
            JCDIService.JCDIInjectionContext context = bundleNonManagedObjs.remove(managedBean);
            if (context == null) {
                if (validate) {
                    throw new IllegalStateException("Unknown JCDI-enabled managed bean " + managedBean + " of class " + managedBean.getClass());
                }
                _logger.log(Level.FINE, "Unknown JCDI-enabled managed bean " + managedBean + " of class " + managedBean.getClass());
                return;
            }
            context.cleanup(true);
        } else {
            Object managedBeanInstance = null;
            try {
                Field proxyField;
                final Field finalF = proxyField = managedBean.getClass().getDeclaredField("__ejb31_delegate");
                AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (!finalF.isAccessible()) {
                            finalF.setAccessible(true);
                        }
                        return null;
                    }
                });
                Proxy proxy = (Proxy)proxyField.get(managedBean);
                InterceptorInvoker invoker = (InterceptorInvoker)((Object)Proxy.getInvocationHandler(proxy));
                managedBeanInstance = invoker.getTargetInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("invalid managed bean " + managedBean, e);
            }
            ManagedBeanDescriptor desc = bundle.getManagedBeanByBeanClass(managedBeanInstance.getClass().getName());
            if (desc == null) {
                throw new IllegalStateException("Could not retrieve managed bean descriptor for " + managedBean + " of class " + managedBean.getClass());
            }
            InterceptorInvoker invoker = (InterceptorInvoker)desc.getSupportingInfoForBeanInstance(managedBeanInstance);
            try {
                invoker.invokePreDestroy();
            }
            catch (Exception e) {
                _logger.log(Level.FINE, "Managed bean " + desc.getBeanClassName() + " PreDestroy", e);
            }
            desc.clearBeanInstanceInfo(managedBeanInstance);
        }
    }

    private BundleDescriptor getBundle() {
        ComponentEnvManager compEnvManager = (ComponentEnvManager)this.habitat.getByContract(ComponentEnvManager.class);
        JndiNameEnvironment env = compEnvManager.getCurrentJndiNameEnvironment();
        BundleDescriptor bundle = null;
        if (env instanceof BundleDescriptor) {
            bundle = (BundleDescriptor)env;
        } else if (env instanceof EjbDescriptor) {
            bundle = (BundleDescriptor)((EjbDescriptor)env).getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
        }
        if (bundle == null) {
            throw new IllegalStateException("Invalid context for managed bean creation");
        }
        return bundle;
    }
}

