/*
 * Decompiled with CFR 0.152.
 */
package com.sun.logging;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogDomains {
    public static final String DOMAIN_ROOT = "javax.";
    public static final String UPGRADE_LOGGER = "upgradeLogger";
    public static final String PACKAGE_ROOT = "com.sun.logging.";
    public static final String RESOURCE_BUNDLE = "LogStrings";
    public static final String STD_LOGGER = "javax.enterprise.system.std";
    public static final String TOOLS_LOGGER = "javax.enterprise.system.tools";
    public static final String EJB_LOGGER = "javax.enterprise.system.container.ejb";
    public static final String JAVAMAIL_LOGGER = "javax.enterprise.resource.javamail";
    public static final String JMS_LOGGER = "javax.enterprise.resource.jms";
    public static final String WEB_LOGGER = "javax.enterprise.system.container.web";
    public static final String CMP_LOGGER = "javax.enterprise.system.container.cmp";
    public static final String JDO_LOGGER = "javax.enterprise.resource.jdo";
    public static final String ACC_LOGGER = "javax.enterprise.system.container.appclient";
    public static final String MDB_LOGGER = "javax.enterprise.system.container.ejb.mdb";
    public static final String SECURITY_LOGGER = "javax.enterprise.system.core.security";
    public static final String SECURITY_SSL_LOGGER = "javax.enterprise.system.ssl.security";
    public static final String TRANSACTION_LOGGER = "javax.enterprise.system.core.transaction";
    public static final String CORBA_LOGGER = "javax.enterprise.resource.corba";
    public static final String UTIL_LOGGER = "javax.enterprise.system.util";
    public static final String NAMING_LOGGER = "javax.enterprise.system.core.naming";
    public static final String JNDI_LOGGER = "javax.enterprise.system.core.naming";
    public static final String ACTIVATION_LOGGER = "javax.enterprise.system.activation";
    public static final String JTA_LOGGER = "javax.enterprise.resource.jta";
    public static final String RSR_LOGGER = "javax.enterprise.resource.resourceadapter";
    public static final String DPL_LOGGER = "javax.enterprise.system.tools.deployment";
    public static final String DPLAUDIT_LOGGER = "javax.enterprise.system.tools.deployment.audit";
    public static final String DIAGNOSTICS_LOGGER = "javax.enterprise.system.tools.diagnostics";
    public static final String JAXRPC_LOGGER = "javax.enterprise.system.webservices.rpc";
    public static final String JAXR_LOGGER = "javax.enterprise.system.webservices.registry";
    public static final String SAAJ_LOGGER = "javax.enterprise.system.webservices.saaj";
    public static final String SELF_MANAGEMENT_LOGGER = "javax.enterprise.system.core.selfmanagement";
    public static final String SQL_TRACE_LOGGER = "javax.enterprise.resource.sqltrace";
    public static final String ADMIN_LOGGER = "javax.enterprise.system.tools.admin";
    public static final String SERVER_LOGGER = "javax.enterprise.system";
    public static final String CORE_LOGGER = "javax.enterprise.system.core";
    public static final String LOADER_LOGGER = "javax.enterprise.system.core.classloading";
    public static final String CONFIG_LOGGER = "javax.enterprise.system.core.config";
    public static final String PROCESS_LAUNCHER_LOGGER = "javax.enterprise.tools.launcher";
    public static final String GMS_LOGGER = "javax.org.glassfish.gms";
    public static final String AMX_LOGGER = "javax.enterprise.system.amx";
    public static final String JMX_LOGGER = "javax.enterprise.system.jmx";
    public static final String SERVICES_LOGGER = "javax.enterprise.system.core.services";
    public static final String WEBSERVICES_LOGGER = "javax.enterprise.webservices";
    public static final String MONITORING_LOGGER = "javax.enterprise.system.tools.monitor";
    public static final String PERSISTENCE_LOGGER = "javax.org.glassfish.persistence";
    public static final String VIRTUALIZATION_LOGGER = "javax.org.glassfish.virtualization";
    public static final String PAAS_LOGGER = "javax.org.glassfish.paas";
    static Lock lock = new ReentrantLock();
    static Vector<String> vectorClazz = new Vector();

    private static String getLoggerResourceBundleName(String loggerName) {
        String result = loggerName + "." + RESOURCE_BUNDLE;
        return result.replaceFirst(DOMAIN_ROOT, PACKAGE_ROOT);
    }

    public static synchronized Logger getLogger(final Class clazz, final String name) {
        final ClassLoader cloader = clazz.getClassLoader();
        Logger l = LogManager.getLogManager().getLogger(name);
        if (l == null) {
            l = Logger.getLogger(name);
        }
        String pkgName = clazz.getPackage().getName();
        String loggerName = name + "." + pkgName;
        Logger cLogger = LogManager.getLogManager().getLogger(loggerName);
        if (cLogger == null && !LogDomains.addLoggerToLogManager(cLogger = new Logger(loggerName, null){
            final ResourceBundle rb;
            private final int offValue;
            {
                super(x0, x1);
                this.rb = this.initResourceBundle();
                this.offValue = Level.OFF.intValue();
            }

            public void log(LogRecord record) {
                record.getSourceMethodName();
                if (record.getResourceBundle() == null && this.rb != null) {
                    record.setResourceBundle(this.rb);
                }
                if (record.getMessage() == null) {
                    record.setMessage("");
                }
                super.log(record);
            }

            public ResourceBundle getResourceBundle() {
                return this.rb;
            }

            private ResourceBundle initResourceBundle() {
                try {
                    return ResourceBundle.getBundle(LogDomains.getLoggerResourceBundleName(name), Locale.getDefault(), cloader);
                }
                catch (MissingResourceException e) {
                    String root = clazz.getPackage().getName();
                    try {
                        return ResourceBundle.getBundle(root + "." + LogDomains.RESOURCE_BUNDLE, Locale.getDefault(), cloader);
                    }
                    catch (MissingResourceException me) {
                        String p = root;
                        while (p != null) {
                            try {
                                int i = p.lastIndexOf(".");
                                if (i != -1) {
                                    p = p.substring(0, i);
                                    return ResourceBundle.getBundle(p + "." + LogDomains.RESOURCE_BUNDLE, Locale.getDefault(), cloader);
                                }
                                p = null;
                            }
                            catch (MissingResourceException mre) {}
                        }
                        try {
                            return ResourceBundle.getBundle(LogDomains.getLoggerResourceBundleName(name), Locale.getDefault(), LogDomains.class.getClassLoader());
                        }
                        catch (MissingResourceException me2) {
                            if (!vectorClazz.contains(clazz.getName())) {
                                Logger l = LogManager.getLogManager().getLogger(name);
                                if (l != null) {
                                    l.log(Level.FINE, "Can not find resource bundle for this logger.  class name that failed: " + clazz.getName());
                                }
                                vectorClazz.add(clazz.getName());
                            }
                            return null;
                        }
                    }
                }
            }
        })) {
            Logger existing = LogManager.getLogManager().getLogger(name);
            if (existing == null) {
                LogDomains.addLoggerToLogManager(cLogger);
            } else {
                cLogger = existing;
            }
        }
        return cLogger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addLoggerToLogManager(Logger logger) {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return LogManager.getLogManager().addLogger(logger);
        }
    }
}

