/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.xml;

import com.sun.enterprise.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SysPropsHandler {
    private Map<String, String> server = new HashMap<String, String>();
    private Map<String, String> cluster = new HashMap<String, String>();
    private Map<String, String> config = new HashMap<String, String>();
    private Map<String, String> domain = new HashMap<String, String>();

    SysPropsHandler() {
    }

    Map<String, String> getCombinedSysProps() {
        HashMap<String, String> map = new HashMap<String, String>(this.domain);
        map.putAll(this.config);
        map.putAll(this.cluster);
        map.putAll(this.server);
        return map;
    }

    String get(String key) {
        return this.getCombinedSysProps().get(key);
    }

    void add(Type type, Map<String, String> map) {
        if (type == null || map == null) {
            return;
        }
        switch (type) {
            case SERVER: {
                this.server.putAll(map);
                break;
            }
            case CLUSTER: {
                this.cluster.putAll(map);
                break;
            }
            case CONFIG: {
                this.config.putAll(map);
                break;
            }
            case DOMAIN: {
                this.domain.putAll(map);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type");
            }
        }
    }

    void add(Type type, String name, String value) {
        if (type == null || !StringUtils.ok(name)) {
            return;
        }
        switch (type) {
            case SERVER: {
                this.server.put(name, value);
                break;
            }
            case CLUSTER: {
                this.cluster.put(name, value);
                break;
            }
            case CONFIG: {
                this.config.put(name, value);
                break;
            }
            case DOMAIN: {
                this.domain.put(name, value);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown type");
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Type {
        SERVER,
        CLUSTER,
        CONFIG,
        DOMAIN;

    }
}

