/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.j2ee;

import com.sun.enterprise.config.serverbeans.ApplicationRef;
import com.sun.enterprise.config.serverbeans.BindableResource;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Module;
import com.sun.enterprise.config.serverbeans.Resource;
import com.sun.enterprise.config.serverbeans.ResourcePool;
import com.sun.enterprise.config.serverbeans.ResourceRef;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.deployment.archivist.Archivist;
import com.sun.enterprise.deployment.archivist.ArchivistFactory;
import com.sun.enterprise.deployment.io.DeploymentDescriptorFile;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.impl.config.ConfigBeanRegistry;
import org.glassfish.admin.amx.impl.j2ee.AppClientModuleImpl;
import org.glassfish.admin.amx.impl.j2ee.EJBModuleImpl;
import org.glassfish.admin.amx.impl.j2ee.EntityBeanImpl;
import org.glassfish.admin.amx.impl.j2ee.J2EEApplicationImpl;
import org.glassfish.admin.amx.impl.j2ee.J2EEManagedObjectImplBase;
import org.glassfish.admin.amx.impl.j2ee.JCAResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JDBCResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JMSResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JNDIResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JTAResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.JavaMailResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.MessageDrivenBeanImpl;
import org.glassfish.admin.amx.impl.j2ee.Metadata;
import org.glassfish.admin.amx.impl.j2ee.MetadataImpl;
import org.glassfish.admin.amx.impl.j2ee.RMI_IIOPResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.ResourceAdapterImpl;
import org.glassfish.admin.amx.impl.j2ee.ResourceAdapterModuleImpl;
import org.glassfish.admin.amx.impl.j2ee.ServletImpl;
import org.glassfish.admin.amx.impl.j2ee.SingletonSessionBeanImpl;
import org.glassfish.admin.amx.impl.j2ee.StatefulSessionBeanImpl;
import org.glassfish.admin.amx.impl.j2ee.StatelessSessionBeanImpl;
import org.glassfish.admin.amx.impl.j2ee.URLResourceImpl;
import org.glassfish.admin.amx.impl.j2ee.WebModuleImpl;
import org.glassfish.admin.amx.impl.j2ee.loader.J2EEInjectedValues;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.j2ee.AMXEELoggerInfo;
import org.glassfish.admin.amx.j2ee.AppClientModule;
import org.glassfish.admin.amx.j2ee.EJBModule;
import org.glassfish.admin.amx.j2ee.EntityBean;
import org.glassfish.admin.amx.j2ee.J2EEApplication;
import org.glassfish.admin.amx.j2ee.J2EEManagedObject;
import org.glassfish.admin.amx.j2ee.J2EEServer;
import org.glassfish.admin.amx.j2ee.MessageDrivenBean;
import org.glassfish.admin.amx.j2ee.ResourceAdapter;
import org.glassfish.admin.amx.j2ee.ResourceAdapterModule;
import org.glassfish.admin.amx.j2ee.Servlet;
import org.glassfish.admin.amx.j2ee.SingletonSessionBean;
import org.glassfish.admin.amx.j2ee.StatefulSessionBean;
import org.glassfish.admin.amx.j2ee.StatelessSessionBean;
import org.glassfish.admin.amx.j2ee.WebModule;
import org.glassfish.admin.amx.util.ClassUtil;
import org.glassfish.admin.amx.util.MapUtil;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.api.admin.config.Named;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;

final class RegistrationSupport {
    private final Map<ObjectName, ObjectName> mConfigRefTo77 = new HashMap<ObjectName, ObjectName>();
    private final J2EEServer mJ2EEServer;
    private final MBeanServer mMBeanServer;
    private final RefListener mResourceRefListener;
    private final Server mServer;
    private final String mResourceRefType;
    private final String mApplicationRefType;
    private final Logger mLogger = AMXEELoggerInfo.getLogger();
    public static final Map<String, Class> CONFIG_RESOURCE_TYPES = MapUtil.toMap((Object[])new Object[]{"jdbc-resource", JDBCResourceImpl.class, "java-mail-resource", JavaMailResourceImpl.class, "jca-resource", JCAResourceImpl.class, "jms-resource", JMSResourceImpl.class, "jndi-resource", JNDIResourceImpl.class, "jta-resource", JTAResourceImpl.class, "rmi-iiop-resource", RMI_IIOPResourceImpl.class, "url-resource", URLResourceImpl.class}, String.class, Class.class);

    private static void cdebug(Object o) {
        System.out.println("" + o);
    }

    public RegistrationSupport(J2EEServer server) {
        this.mJ2EEServer = server;
        this.mMBeanServer = (MBeanServer)server.extra().mbeanServerConnection();
        this.mResourceRefType = Util.deduceType(ResourceRef.class);
        this.mApplicationRefType = Util.deduceType(ApplicationRef.class);
        this.mServer = this.getDomain().getServers().getServer(this.mJ2EEServer.getName());
        this.mResourceRefListener = new RefListener();
        this.registerApplications();
    }

    protected void cleanup() {
        this.mResourceRefListener.stopListening();
    }

    public void start() {
        this.mResourceRefListener.startListening();
    }

    private Domain getDomain() {
        return (Domain)InjectedValues.getInstance().getHabitat().getService(Domain.class, new Annotation[0]);
    }

    private ObjectName getObjectName(ConfigBeanProxy cbp) {
        return ConfigBeanRegistry.getInstance().getObjectNameForProxy(cbp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDeploymentDescriptor(BundleDescriptor bundleDesc) {
        ArchivistFactory archivistFactory = J2EEInjectedValues.getInstance().getArchivistFactory();
        String dd = "unavailable";
        ByteArrayOutputStream out = null;
        try {
            Archivist moduleArchivist = archivistFactory.getArchivist(bundleDesc.getModuleDescriptor().getModuleType());
            DeploymentDescriptorFile ddFile = moduleArchivist.getStandardDDFile();
            out = new ByteArrayOutputStream();
            ddFile.write((Descriptor)bundleDesc, (OutputStream)out);
            String charsetName = "UTF-8";
            dd = out.toString("UTF-8");
        }
        catch (Exception e) {
            dd = null;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {}
            }
        }
        return dd;
    }

    private ObjectName createAppMBeans(com.sun.enterprise.config.serverbeans.Application appConfig, Application application, MetadataImpl meta) {
        ObjectName objectName;
        String appLocation = appConfig.getLocation();
        boolean isStandalone = application.isVirtual();
        ObjectName parentMBean = null;
        ObjectName top = null;
        if (isStandalone) {
            parentMBean = this.mJ2EEServer.objectName();
        } else {
            String xmlDesc = this.getDeploymentDescriptor((BundleDescriptor)application);
            if (xmlDesc != null) {
                meta.setDeploymentDescriptor(xmlDesc);
            }
            top = parentMBean = this.registerJ2EEChild(this.mJ2EEServer.objectName(), meta, J2EEApplication.class, J2EEApplicationImpl.class, application.getName());
        }
        for (EjbBundleDescriptor desc : application.getBundleDescriptors(EjbBundleDescriptor.class)) {
            objectName = this.registerEjbModuleAndItsComponents(parentMBean, meta, appConfig, desc);
            if (!isStandalone) continue;
            assert (top == null);
            top = objectName;
        }
        for (EjbBundleDescriptor desc : application.getBundleDescriptors(WebBundleDescriptor.class)) {
            objectName = this.registerWebModuleAndItsComponents(parentMBean, meta, appConfig, (WebBundleDescriptor)desc);
            if (!isStandalone) continue;
            assert (top == null);
            top = objectName;
        }
        for (EjbBundleDescriptor desc : application.getBundleDescriptors(ConnectorDescriptor.class)) {
            assert (top == null);
            top = this.registerResourceAdapterModuleAndItsComponents(parentMBean, meta, appConfig, (ConnectorDescriptor)desc, appLocation);
        }
        for (EjbBundleDescriptor desc : application.getBundleDescriptors(ApplicationClientDescriptor.class)) {
            assert (top == null);
            top = this.registerAppClient(parentMBean, meta, appConfig, (ApplicationClientDescriptor)desc);
        }
        this.mLogger.fine("Registered JSR 77 MBeans for application/module: " + top);
        return top;
    }

    private Module getModuleConfig(com.sun.enterprise.config.serverbeans.Application appConfig, String name) {
        if (appConfig.getModule(name) == null) {
            throw new IllegalArgumentException("Can't find module named " + name + " in " + appConfig);
        }
        return appConfig.getModule(name);
    }

    private ObjectName registerEjbModuleAndItsComponents(ObjectName parentMBean, MetadataImpl meta, com.sun.enterprise.config.serverbeans.Application appConfig, EjbBundleDescriptor ejbBundleDescriptor) {
        String xmlDesc = this.getDeploymentDescriptor((BundleDescriptor)ejbBundleDescriptor);
        if (xmlDesc != null) {
            meta.setDeploymentDescriptor(xmlDesc);
        }
        String moduleName = ejbBundleDescriptor.getModuleName();
        Module moduleConfig = this.getModuleConfig(appConfig, moduleName);
        meta.setCorrespondingConfig(this.getObjectName((ConfigBeanProxy)moduleConfig));
        ObjectName ejbModuleObjectName = this.registerJ2EEChild(parentMBean, meta, EJBModule.class, EJBModuleImpl.class, moduleName);
        meta.remove("Config");
        meta.remove("DeploymentDescriptor");
        for (EjbDescriptor desc : ejbBundleDescriptor.getEjbs()) {
            this.createEJBMBean(ejbModuleObjectName, meta, desc);
        }
        return ejbModuleObjectName;
    }

    private ObjectName createEJBMBean(ObjectName parentMBean, MetadataImpl meta, EjbDescriptor ejbDescriptor) {
        String ejbName = ejbDescriptor.getName();
        String ejbType = ejbDescriptor.getType();
        String ejbSessionType = ejbType.equals("Session") ? ((EjbSessionDescriptor)ejbDescriptor).getSessionType() : null;
        Class intf = null;
        Class impl = null;
        if (ejbType.equals("Entity")) {
            intf = EntityBean.class;
            impl = EntityBeanImpl.class;
        } else if (ejbType.equals("Message-driven")) {
            intf = MessageDrivenBean.class;
            impl = MessageDrivenBeanImpl.class;
        } else if (ejbType.equals("Session")) {
            if (ejbSessionType.equals("Stateless")) {
                intf = StatelessSessionBean.class;
                impl = StatelessSessionBeanImpl.class;
            } else if (ejbSessionType.equals("Stateful")) {
                intf = StatefulSessionBean.class;
                impl = StatefulSessionBeanImpl.class;
            } else if (ejbSessionType.equals("Singleton")) {
                intf = SingletonSessionBean.class;
                impl = SingletonSessionBeanImpl.class;
            } else {
                throw new IllegalArgumentException("Unknown ejbSessionType: " + ejbSessionType + ", expected Stateless or Stateful");
            }
        }
        return this.registerJ2EEChild(parentMBean, meta, intf, impl, ejbName);
    }

    private ObjectName registerWebModuleAndItsComponents(ObjectName parentMBean, MetadataImpl meta, com.sun.enterprise.config.serverbeans.Application appConfig, WebBundleDescriptor webBundleDescriptor) {
        String xmlDesc = this.getDeploymentDescriptor((BundleDescriptor)webBundleDescriptor);
        if (xmlDesc != null) {
            meta.setDeploymentDescriptor(xmlDesc);
        }
        String moduleName = webBundleDescriptor.getModuleName();
        Module moduleConfig = this.getModuleConfig(appConfig, moduleName);
        meta.setCorrespondingConfig(this.getObjectName((ConfigBeanProxy)moduleConfig));
        ObjectName webModuleObjectName = this.registerJ2EEChild(parentMBean, meta, WebModule.class, WebModuleImpl.class, moduleName);
        meta.remove("Config");
        meta.remove("DeploymentDescriptor");
        for (WebComponentDescriptor desc : webBundleDescriptor.getWebComponentDescriptors()) {
            String servletName = desc.getCanonicalName();
            this.registerJ2EEChild(webModuleObjectName, meta, Servlet.class, ServletImpl.class, servletName);
        }
        return webModuleObjectName;
    }

    public ObjectName registerResourceAdapterModuleAndItsComponents(ObjectName parentMBean, MetadataImpl meta, com.sun.enterprise.config.serverbeans.Application appConfig, ConnectorDescriptor bundleDesc, String appLocation) {
        meta.setCorrespondingConfig(this.getObjectName((ConfigBeanProxy)appConfig));
        ObjectName objectName = this.createRARModuleMBean(parentMBean, meta, appConfig, bundleDesc);
        Module moduleConfig = this.getModuleConfig(appConfig, bundleDesc.getModuleName());
        meta.setCorrespondingConfig(this.getObjectName((ConfigBeanProxy)moduleConfig));
        this.registerJ2EEChild(objectName, meta, ResourceAdapter.class, ResourceAdapterImpl.class, bundleDesc.getName());
        return objectName;
    }

    private ObjectName createRARModuleMBean(ObjectName parentMBean, MetadataImpl meta, com.sun.enterprise.config.serverbeans.Application appConfig, ConnectorDescriptor bundleDesc) {
        String xmlDesc = this.getDeploymentDescriptor((BundleDescriptor)bundleDesc);
        if (xmlDesc != null) {
            meta.setDeploymentDescriptor(xmlDesc);
        }
        String resAdName = bundleDesc.getModuleName();
        ObjectName objectName = this.registerJ2EEChild(parentMBean, meta, ResourceAdapterModule.class, ResourceAdapterModuleImpl.class, resAdName);
        return objectName;
    }

    public ObjectName registerAppClient(ObjectName parentMBean, MetadataImpl meta, com.sun.enterprise.config.serverbeans.Application appConfig, ApplicationClientDescriptor bundleDesc) {
        String xmlDesc = this.getDeploymentDescriptor((BundleDescriptor)bundleDesc);
        if (xmlDesc != null) {
            meta.setDeploymentDescriptor(xmlDesc);
        }
        String moduleName = bundleDesc.getModuleDescriptor().getModuleName();
        return this.registerJ2EEChild(parentMBean, meta, AppClientModule.class, AppClientModuleImpl.class, moduleName);
    }

    protected void registerApplications() {
        List appRefs = this.mServer.getApplicationRef();
        for (ApplicationRef ref : appRefs) {
            try {
                this.processApplicationRef(ref);
            }
            catch (Exception e) {
                this.mLogger.log(Level.INFO, "AS-AMXEE-001", new Object[]{ref.getRef(), e});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName processApplicationRef(ApplicationRef ref) {
        ApplicationRegistry appRegistry = J2EEInjectedValues.getInstance().getApplicationRegistry();
        MetadataImpl meta = new MetadataImpl();
        meta.setCorrespondingRef(this.getObjectName((ConfigBeanProxy)ref));
        String appName = ref.getRef();
        ApplicationInfo appInfo = appRegistry.get(appName);
        if (appInfo == null) {
            this.mLogger.fine("Unable to get ApplicationInfo for application: " + appName);
            return null;
        }
        Application app = (Application)appInfo.getMetaData(Application.class);
        if (app == null) {
            if (appInfo.isJavaEEApp()) {
                this.mLogger.log(Level.WARNING, "AS-AMXEE-002", appName);
            }
            return null;
        }
        com.sun.enterprise.config.serverbeans.Application appConfig = this.getDomain().getApplications().getApplication(appName);
        if (appConfig == null) {
            this.mLogger.log(Level.WARNING, "AS-AMXEE-003", appName);
            return null;
        }
        meta.setCorrespondingConfig(this.getObjectName((ConfigBeanProxy)appConfig));
        ObjectName mbean77 = this.createAppMBeans(appConfig, app, meta);
        Map<ObjectName, ObjectName> map = this.mConfigRefTo77;
        synchronized (map) {
            this.mConfigRefTo77.put(this.getObjectName((ConfigBeanProxy)ref), mbean77);
        }
        return mbean77;
    }

    protected <I extends J2EEManagedObject, C extends J2EEManagedObjectImplBase> ObjectName registerJ2EEChild(ObjectName parent, Metadata metadataIn, Class<I> intf, Class<C> clazz, String name) {
        ObjectName objectName = null;
        String j2eeType = Util.deduceType(intf);
        MetadataImpl metadata = new MetadataImpl(metadataIn);
        try {
            Constructor<C> c = clazz.getConstructor(ObjectName.class, Metadata.class);
            J2EEManagedObjectImplBase impl = (J2EEManagedObjectImplBase)((Object)c.newInstance(parent, metadata));
            objectName = new ObjectNameBuilder(this.mMBeanServer, parent).buildChildObjectName(j2eeType, name);
            objectName = this.mMBeanServer.registerMBean((Object)impl, objectName).getObjectName();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot register " + j2eeType + "=" + name + " as child of " + parent, e);
        }
        return objectName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectName processResourceRef(ResourceRef ref) {
        if (ref == null) {
            throw new IllegalArgumentException("resource-ref is null");
        }
        if (!this.mServer.getName().equals(((Server)ref.getParent(Server.class)).getName())) {
            RegistrationSupport.cdebug("ResourceRef is not a child of server " + this.getObjectName((ConfigBeanProxy)this.mServer));
            return null;
        }
        Resource res = null;
        List resources = this.getDomain().getResources().getResources();
        for (Resource resource : resources) {
            String name = null;
            if (resource instanceof BindableResource) {
                name = ((BindableResource)resource).getJndiName();
            }
            if (resource instanceof Named) {
                name = ((Named)resource).getName();
            }
            if (resource instanceof ResourcePool) {
                name = ((ResourcePool)resource).getName();
            }
            if (name == null || !name.equals(ref.getRef())) continue;
            res = resource;
        }
        if (res == null) {
            throw new IllegalArgumentException("ResourceRef refers to non-existent resource: " + ref);
        }
        String configType = Util.getTypeProp((ObjectName)this.getObjectName((ConfigBeanProxy)res));
        Class implClass = CONFIG_RESOURCE_TYPES.get(configType);
        if (implClass == null) {
            this.mLogger.fine("Unrecognized resource type for JSR 77 purposes: " + this.getObjectName((ConfigBeanProxy)res));
            return null;
        }
        Class intf = (Class)ClassUtil.getFieldValue((Class)implClass, (String)"INTF");
        ObjectName mbean77 = null;
        try {
            MetadataImpl meta = new MetadataImpl();
            meta.setCorrespondingRef(this.getObjectName((ConfigBeanProxy)ref));
            meta.setCorrespondingConfig(this.getObjectName((ConfigBeanProxy)res));
            mbean77 = this.registerJ2EEChild(this.mJ2EEServer.objectName(), meta, intf, implClass, Util.getNameProp((ObjectName)this.getObjectName((ConfigBeanProxy)res)));
            Map<ObjectName, ObjectName> map = this.mConfigRefTo77;
            synchronized (map) {
                this.mConfigRefTo77.put(this.getObjectName((ConfigBeanProxy)ref), mbean77);
            }
        }
        catch (Exception e) {
            this.mLogger.log(Level.INFO, "AS-AMXEE-004", new Object[]{this.getObjectName((ConfigBeanProxy)ref), e});
        }
        return mbean77;
    }

    private final class RefListener
    implements NotificationListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handleNotification(Notification notifIn, Object handback) {
            if (!(notifIn instanceof MBeanServerNotification)) {
                return;
            }
            MBeanServerNotification notif = (MBeanServerNotification)notifIn;
            ObjectName objectName = notif.getMBeanName();
            if (!RegistrationSupport.this.mJ2EEServer.objectName().getDomain().equals(objectName.getDomain())) {
                return;
            }
            String type = Util.getTypeProp((ObjectName)objectName);
            if (notif.getType().equals("JMX.mbean.registered")) {
                if (type.equals(RegistrationSupport.this.mResourceRefType)) {
                    RegistrationSupport.this.mLogger.fine("New ResourceRef MBEAN registered: " + objectName);
                    ConfigBean configBean = ConfigBeanRegistry.getInstance().getConfigBean(objectName);
                    if (configBean instanceof ResourceRef) {
                        ResourceRef ref = (ResourceRef)configBean;
                        RegistrationSupport.this.processResourceRef(ref);
                    }
                } else if (type.equals(RegistrationSupport.this.mApplicationRefType)) {
                    RegistrationSupport.this.mLogger.fine("NEW ApplicationRef MBEAN registered: " + objectName);
                    ConfigBean configBean = ConfigBeanRegistry.getInstance().getConfigBean(objectName);
                    if (configBean instanceof ApplicationRef) {
                        ApplicationRef ref = (ApplicationRef)configBean;
                        RegistrationSupport.this.processApplicationRef(ref);
                    }
                }
            } else if (notif.getType().equals("JMX.mbean.unregistered")) {
                Map<ObjectName, ObjectName> map = RegistrationSupport.this.mConfigRefTo77;
                synchronized (map) {
                    ObjectName mbean77 = RegistrationSupport.this.mConfigRefTo77.remove(objectName);
                    if (mbean77 != null) {
                        RegistrationSupport.this.mLogger.fine("Unregistering MBEAN for ref: " + objectName);
                        try {
                            RegistrationSupport.this.mMBeanServer.unregisterMBean(mbean77);
                        }
                        catch (Exception e) {
                            RegistrationSupport.this.mLogger.log(Level.WARNING, "AS-AMXEE-005", objectName);
                            RegistrationSupport.this.mLogger.log(Level.WARNING, null, e);
                        }
                    }
                }
            }
        }

        public void startListening() {
            try {
                RegistrationSupport.this.mMBeanServer.addNotificationListener(JMXUtil.getMBeanServerDelegateObjectName(), this, null, null);
            }
            catch (JMException e) {
                throw new RuntimeException(e);
            }
            List resourceRefs = RegistrationSupport.this.mServer.getResourceRef();
            for (ResourceRef ref : resourceRefs) {
                RegistrationSupport.this.processResourceRef(ref);
            }
        }

        public void stopListening() {
            try {
                RegistrationSupport.this.mMBeanServer.removeNotificationListener(JMXUtil.getMBeanServerDelegateObjectName(), this);
            }
            catch (JMException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

