/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.gms;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Clusters;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Node;
import com.sun.enterprise.config.serverbeans.Nodes;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.ServerRef;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.ee.cms.core.AliveAndReadySignal;
import com.sun.enterprise.ee.cms.core.AliveAndReadyView;
import com.sun.enterprise.ee.cms.core.CallBack;
import com.sun.enterprise.ee.cms.core.FailureNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.FailureRecoveryActionFactory;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.FailureSuspectedActionFactory;
import com.sun.enterprise.ee.cms.core.GMSConstants;
import com.sun.enterprise.ee.cms.core.GMSException;
import com.sun.enterprise.ee.cms.core.GMSFactory;
import com.sun.enterprise.ee.cms.core.GroupLeadershipNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.GroupManagementService;
import com.sun.enterprise.ee.cms.core.JoinNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationActionFactory;
import com.sun.enterprise.ee.cms.core.JoinedAndReadyNotificationSignal;
import com.sun.enterprise.ee.cms.core.MessageActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownActionFactory;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.ServiceProviderConfigurationKeys;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.client.FailureNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureRecoveryActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.FailureSuspectedActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.GroupLeadershipNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.JoinedAndReadyNotificationActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.MessageActionFactoryImpl;
import com.sun.enterprise.ee.cms.impl.client.PlannedShutdownActionFactoryImpl;
import com.sun.enterprise.mgmt.transport.NetworkUtility;
import com.sun.enterprise.mgmt.transport.grizzly.GrizzlyConfigConstants;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.EventTypes;
import org.glassfish.api.event.Events;
import org.glassfish.api.logging.LogLevel;
import org.glassfish.gms.bootstrap.GMSAdapter;
import org.glassfish.gms.bootstrap.HealthHistory;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigListener;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.types.Property;

@PerLookup
@Service
public class GMSAdapterImpl
implements GMSAdapter,
PostConstruct,
CallBack {
    private static final String BEGINS_WITH = "^";
    private static final String GMS_PROPERTY_PREFIX = "GMS_";
    private static final String GMS_PROPERTY_PREFIX_REGEXP = "^GMS_";
    private GroupManagementService gms;
    private static final String CORE = "CORE";
    private static final String SPECTATOR = "SPECTATOR";
    private static final String MEMBERTYPE_STRING = "MEMBER_TYPE";
    private String instanceName = null;
    private boolean isDas = false;
    private Cluster cluster = null;
    private String clusterName = null;
    private Config clusterConfig = null;
    private ConcurrentHashMap<CallBack, JoinNotificationActionFactory> callbackJoinActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, JoinedAndReadyNotificationActionFactory> callbackJoinedAndReadyActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, FailureNotificationActionFactory> callbackFailureActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, FailureSuspectedActionFactory> callbackFailureSuspectedActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, GroupLeadershipNotificationActionFactory> callbackGroupLeadershipActionFactoryMapping = new ConcurrentHashMap();
    private ConcurrentHashMap<CallBack, PlannedShutdownActionFactory> callbackPlannedShutdownActionFactoryMapping = new ConcurrentHashMap();
    private EventListener glassfishEventListener = null;
    private boolean aliveAndReadyLoggingEnabled = false;
    private boolean testFailureRecoveryHandler = false;
    @Inject
    Events events;
    @Inject
    ServerEnvironment env;
    @Inject
    @Named(value="default-instance-name")
    Server server;
    @Inject
    ServiceLocator habitat;
    @Inject
    Clusters clusters;
    @Inject
    Nodes nodes;
    @Inject
    Servers servers;
    private HealthHistory hHistory;
    private static final String GMS_LOGGER_NAME = "javax.enterprise.cluster.gms";
    private static final String LOG_MESSAGES_RB = "org.glassfish.cluster.gms.LogMessages";
    static final Logger GMS_LOGGER = Logger.getLogger("javax.enterprise.cluster.gms", "org.glassfish.cluster.gms.LogMessages");
    private static final String GMS_NO_CLUSTER_NAME = "NCLS-CLSTR-10101";
    private static final String GMS_MULTIPLE_ADAPTER = "NCLS-CLSTR-10102";
    private static final String GMS_NO_CLUSTER_WARNING = "NCLS-CLSTR-10103";
    private static final String GMS_STARTED = "NCLS-CLSTR-10104";
    private static final String GMS_JOINED = "NCLS-CLSTR-10105";
    private static final String GMS_ALIVE_AND_READY = "NCLS-CLSTR-10107";
    private static final String GMS_SERVER_SHUTDOWN_RECEIVED = "NCLS-CLSTR-10108";
    private static final String GMS_EXCEPTION_NEW_HEALTH_HISTORY = "NCLS-CLSTR-10109";
    private static final String GMS_EXCEPTION_PROCESSING_CONFIG = "NCLS-CLSTR-10110";
    private static final String GMS_EXCEPTION_IGNORING_PROPERTY = "NCLS-CLSTR-10111";
    private static final String GMS_EXCEPTION_CLUSTER_PROPERTY_ERROR = "NCLS-CLSTR-10112";
    private static final String GMS_EXCEPTION_CANNOT_GET_GROUP_MODULE = "NCLS-CLSTR-10113";
    private static final String GMS_EXCEPTION_UPDATE_HEALTH_HISTORY = "NCLS-CLSTR-10114";
    private static final String GMS_FAILURERECOVERY_START = "NCLS-CLSTR-10115";
    private static final String GMS_FAILURE_RECOVERY_COMPLETED = "NCLS-CLSTR-10116";
    private static final String GMS_FAILED_TO_START = "NCLS-CLSTR-10117";
    private static final String GMS_FAILED_TO_START_UNEXCEPTED = "NCLS-CLSTR-10118";
    private static final String GMS_BIND_INT_ADDRESS_INVALID = "NCLS-CLSTR-10119";
    private static final String GMS_LISTENER_PORT_REQUIRED = "NCLS-CLSTR-10120";
    AtomicBoolean initialized = new AtomicBoolean(false);
    AtomicBoolean initializationComplete = new AtomicBoolean(false);

    public void postConstruct() {
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public boolean initialize(String clusterName) {
        if (this.initialized.compareAndSet(false, true)) {
            this.clusterName = clusterName;
            if (clusterName == null) {
                GMS_LOGGER.log(LogLevel.SEVERE, GMS_NO_CLUSTER_NAME);
                return false;
            }
            try {
                this.gms = GMSFactory.getGMSModule((String)clusterName);
            }
            catch (GMSException ge) {
                // empty catch block
            }
            if (this.gms != null) {
                GMS_LOGGER.log(LogLevel.SEVERE, GMS_MULTIPLE_ADAPTER, clusterName);
                return false;
            }
            Domain domain = (Domain)this.habitat.getService(Domain.class, new Annotation[0]);
            this.instanceName = this.env.getInstanceName();
            this.isDas = this.env.isDas();
            this.cluster = this.server.getCluster();
            if (this.cluster == null && this.clusters != null) {
                for (Cluster clusterI : this.clusters.getCluster()) {
                    if (clusterName.compareTo(clusterI.getName()) != 0) continue;
                    this.cluster = clusterI;
                    break;
                }
            }
            if (this.cluster == null) {
                GMS_LOGGER.log(LogLevel.WARNING, GMS_NO_CLUSTER_WARNING);
                return false;
            }
            if (this.isDas) {
                this.initializeHealthHistory(this.cluster);
            }
            this.clusterConfig = domain.getConfigNamed(clusterName + "-config");
            if (GMS_LOGGER.isLoggable(LogLevel.CONFIG)) {
                GMS_LOGGER.log(LogLevel.CONFIG, "clusterName=" + clusterName + " clusterConfig=" + this.clusterConfig);
            }
            try {
                this.initializeGMS();
            }
            catch (GMSException e) {
                GMS_LOGGER.log(LogLevel.SEVERE, GMS_FAILED_TO_START, e);
                return false;
            }
            catch (Throwable t) {
                GMS_LOGGER.log(LogLevel.SEVERE, GMS_FAILED_TO_START_UNEXCEPTED, t);
                return false;
            }
            this.initializationComplete.set(true);
        }
        return this.initialized.get();
    }

    public void complete() {
        this.initialized.compareAndSet(true, false);
        this.initializationComplete.compareAndSet(true, false);
        this.gms = null;
        GMSFactory.removeGMSModule((String)this.clusterName);
    }

    public HealthHistory getHealthHistory() {
        this.checkInitialized();
        return this.hHistory;
    }

    private void initializeHealthHistory(Cluster cluster) {
        try {
            this.hHistory = new HealthHistory(cluster);
            Dom.unwrap((ConfigBeanProxy)cluster).addListener((ConfigListener)this.hHistory);
        }
        catch (Throwable t) {
            GMS_LOGGER.log(LogLevel.WARNING, GMS_EXCEPTION_NEW_HEALTH_HISTORY, t.getLocalizedMessage());
        }
    }

    private void readGMSConfigProps(Properties configProps) {
        String value;
        String name;
        configProps.put(MEMBERTYPE_STRING, this.isDas ? SPECTATOR : CORE);
        block15: for (ServiceProviderConfigurationKeys key : ServiceProviderConfigurationKeys.values()) {
            String keyName = key.toString();
            try {
                switch (key) {
                    case MULTICASTADDRESS: {
                        String value2;
                        if (this.cluster == null || (value2 = this.cluster.getGmsMulticastAddress()) == null) continue block15;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case MULTICASTPORT: {
                        String value2;
                        if (this.cluster == null || (value2 = this.cluster.getGmsMulticastPort()) == null) continue block15;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case FAILURE_DETECTION_TIMEOUT: {
                        String value2;
                        if (this.clusterConfig == null || (value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getHeartbeatFrequencyInMillis()) == null) continue block15;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case FAILURE_DETECTION_RETRIES: {
                        String value2;
                        if (this.clusterConfig == null || (value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getMaxMissedHeartbeats()) == null) continue block15;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case FAILURE_VERIFICATION_TIMEOUT: {
                        String value2;
                        if (this.clusterConfig == null || (value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getVerifyFailureWaittimeInMillis()) == null) continue block15;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case DISCOVERY_TIMEOUT: {
                        String value2;
                        if (this.clusterConfig == null || (value2 = this.clusterConfig.getGroupManagementService().getGroupDiscoveryTimeoutInMillis()) == null) continue block15;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case IS_BOOTSTRAPPING_NODE: {
                        configProps.put(keyName, this.isDas ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
                        break;
                    }
                    case BIND_INTERFACE_ADDRESS: {
                        if (this.cluster == null) continue block15;
                        String value2 = this.cluster.getGmsBindInterfaceAddress();
                        if (value2 != null) {
                            value2 = value2.trim();
                        }
                        if (value2 == null || value2.length() <= 1 || value2.charAt(0) == '$') continue block15;
                        if (NetworkUtility.isBindAddressValid((String)value2)) {
                            configProps.put(keyName, value2);
                            break;
                        }
                        GMS_LOGGER.log(LogLevel.SEVERE, GMS_BIND_INT_ADDRESS_INVALID, value2);
                        break;
                    }
                    case FAILURE_DETECTION_TCP_RETRANSMIT_TIMEOUT: {
                        String value2;
                        if (this.clusterConfig == null || (value2 = this.clusterConfig.getGroupManagementService().getFailureDetection().getVerifyFailureConnectTimeoutInMillis()) == null) continue block15;
                        configProps.put(keyName, value2);
                        break;
                    }
                    case MULTICAST_POOLSIZE: 
                    case INCOMING_MESSAGE_QUEUE_SIZE: 
                    case FAILURE_DETECTION_TCP_RETRANSMIT_PORT: {
                        if (this.clusterConfig == null) continue block15;
                        Property prop = this.clusterConfig.getGroupManagementService().getProperty(keyName);
                        if (prop == null) {
                            if (!GMS_LOGGER.isLoggable(LogLevel.FINE)) continue block15;
                            GMS_LOGGER.log(LogLevel.FINE, String.format("No config property found for %s", keyName));
                            break;
                        }
                        String value3 = prop.getValue().trim();
                        if (value3 == null) continue block15;
                        configProps.put(keyName, value3);
                        break;
                    }
                    case LOOPBACK: 
                    case VIRTUAL_MULTICAST_URI_LIST: {
                        break;
                    }
                    default: {
                        if (!GMS_LOGGER.isLoggable(LogLevel.FINE)) continue block15;
                        GMS_LOGGER.log(LogLevel.FINE, String.format("service provider key %s ignored", keyName));
                    }
                }
            }
            catch (Throwable t) {
                GMS_LOGGER.log(LogLevel.WARNING, GMS_EXCEPTION_PROCESSING_CONFIG, t.getLocalizedMessage());
            }
        }
        List props = null;
        if (this.clusterConfig != null) {
            props = this.clusterConfig.getGroupManagementService().getProperty();
            for (Property prop : props) {
                name = prop.getName().trim();
                value = prop.getValue().trim();
                if (name == null || value == null) continue;
                if (GMS_LOGGER.isLoggable(LogLevel.CONFIG)) {
                    GMS_LOGGER.log(LogLevel.CONFIG, "processing group-management-service property name=" + name + " value= " + value);
                }
                if (value.startsWith("${")) {
                    if (!GMS_LOGGER.isLoggable(LogLevel.CONFIG)) continue;
                    GMS_LOGGER.log(LogLevel.CONFIG, "skipping group-management-service property name=" + name + " since value is unresolved symbolic token=" + value);
                    continue;
                }
                if (GMS_LOGGER.isLoggable(LogLevel.CONFIG)) {
                    GMS_LOGGER.log(LogLevel.CONFIG, "processing group-management-service property name=" + name + " value= " + value);
                }
                if (name.startsWith(GMS_PROPERTY_PREFIX)) {
                    name = name.replaceFirst(GMS_PROPERTY_PREFIX_REGEXP, "");
                }
                configProps.put(name, value);
                if (this.validateGMSProperty(name)) continue;
                GMS_LOGGER.log(LogLevel.WARNING, GMS_EXCEPTION_IGNORING_PROPERTY, new Object[]{name, value, ""});
            }
        }
        if (this.cluster != null) {
            props = this.cluster.getProperty();
            for (Property prop : props) {
                name = prop.getName().trim();
                value = prop.getValue().trim();
                if (name == null || value == null) continue;
                if (GMS_LOGGER.isLoggable(LogLevel.CONFIG)) {
                    GMS_LOGGER.log(LogLevel.CONFIG, "processing cluster property name=" + name + " value= " + value);
                }
                if (value.startsWith("${")) {
                    if (!GMS_LOGGER.isLoggable(LogLevel.CONFIG)) continue;
                    GMS_LOGGER.log(LogLevel.CONFIG, "skipping cluster property name=" + name + " since value is unresolved symbolic token=" + value);
                    continue;
                }
                if (name.startsWith(GMS_PROPERTY_PREFIX)) {
                    name = name.replaceFirst(GMS_PROPERTY_PREFIX_REGEXP, "");
                }
                if (name.compareTo("ALIVEANDREADY_LOGGING") == 0) {
                    this.aliveAndReadyLoggingEnabled = Boolean.parseBoolean(value);
                    continue;
                }
                if (name.compareTo("LISTENER_PORT") == 0) {
                    configProps.put(GrizzlyConfigConstants.TCPSTARTPORT.toString(), value);
                    configProps.put(GrizzlyConfigConstants.TCPENDPORT.toString(), value);
                    continue;
                }
                if (name.compareTo("TEST_FAILURE_RECOVERY") == 0) {
                    this.testFailureRecoveryHandler = Boolean.parseBoolean(value);
                    continue;
                }
                if (ServiceProviderConfigurationKeys.DISCOVERY_URI_LIST.name().equals(name) && "generate".equals(value)) {
                    value = this.generateDiscoveryUriList();
                    configProps.put(name, value);
                    continue;
                }
                configProps.put(name, value);
                GMS_LOGGER.log(LogLevel.CONFIG, "processing cluster property name=" + name + " value= " + value);
                if (this.validateGMSProperty(name)) continue;
                GMS_LOGGER.log(LogLevel.WARNING, GMS_EXCEPTION_CLUSTER_PROPERTY_ERROR, new Object[]{name, value, ""});
            }
        }
    }

    private String generateDiscoveryUriList() {
        int lastCommaIndex;
        String clusterPort = null;
        Property gmsPortProp = this.cluster.getProperty("GMS_LISTENER_PORT");
        if (gmsPortProp == null || gmsPortProp.getValue() == null || gmsPortProp.getValue().trim().charAt(0) == '$') {
            clusterPort = "9090";
            GMS_LOGGER.log(LogLevel.WARNING, GMS_LISTENER_PORT_REQUIRED, new Object[]{this.cluster.getName(), clusterPort});
        } else {
            clusterPort = gmsPortProp.getValue();
            if (GMS_LOGGER.isLoggable(LogLevel.FINE)) {
                GMS_LOGGER.log(LogLevel.FINE, "will use gms listener port: " + clusterPort);
            }
        }
        HashSet<String> instanceNames = new HashSet<String>();
        if (GMS_LOGGER.isLoggable(LogLevel.FINE)) {
            GMS_LOGGER.log(LogLevel.FINE, String.format("checking cluster.getServerRef() for '%s'", this.cluster.getName()));
        }
        for (ServerRef sRef : this.cluster.getServerRef()) {
            if (GMS_LOGGER.isLoggable(LogLevel.FINE)) {
                GMS_LOGGER.log(LogLevel.FINE, String.format("adding server ref %s to set of instance names", sRef.getRef()));
            }
            instanceNames.add(sRef.getRef());
        }
        StringBuilder sb = new StringBuilder();
        String SEP = ",";
        String scheme = "tcp://";
        for (String name : instanceNames) {
            Node node;
            Server server = this.servers.getServer(name);
            if (server == null) continue;
            if (GMS_LOGGER.isLoggable(LogLevel.FINE)) {
                GMS_LOGGER.log(LogLevel.FINE, String.format("found server for name %s", name));
            }
            if ((node = this.nodes.getNode(server.getNodeRef())) == null) continue;
            String host = "tcp://" + node.getNodeHost() + ":" + clusterPort;
            if (GMS_LOGGER.isLoggable(LogLevel.FINE)) {
                GMS_LOGGER.log(LogLevel.FINE, String.format("Adding host '%s' to discovery list", host));
            }
            sb.append(host).append(",");
        }
        if (this.server.isInstance()) {
            try {
                ServerDirs sDirs = new ServerDirs(this.env.getInstanceRoot());
                File dasPropsFile = sDirs.getDasPropertiesFile();
                if (GMS_LOGGER.isLoggable(LogLevel.FINE)) {
                    GMS_LOGGER.log(LogLevel.FINE, String.format("found das.props file at %s", dasPropsFile.getAbsolutePath()));
                }
                Properties dasProps = this.getProperties(dasPropsFile);
                String host = "tcp://" + dasProps.getProperty("agent.das.host") + ":" + clusterPort;
                if (GMS_LOGGER.isLoggable(LogLevel.FINE)) {
                    GMS_LOGGER.log(LogLevel.FINE, String.format("adding '%s' from das.props file", host));
                }
                sb.append(host).append(",");
            }
            catch (IOException ioe) {
                GMS_LOGGER.log(LogLevel.WARNING, ioe.toString());
            }
        }
        if ((lastCommaIndex = sb.lastIndexOf(",")) != -1) {
            sb.deleteCharAt(lastCommaIndex);
        }
        if (GMS_LOGGER.isLoggable(LogLevel.FINE)) {
            GMS_LOGGER.log(LogLevel.FINE, String.format("returning discovery list '%s'", sb.toString()));
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Properties getProperties(File propFile) throws IOException {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propFile);
            props.load(fis);
            fis.close();
            fis = null;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignored) {}
            }
        }
        return props;
    }

    private boolean validateGMSProperty(String propertyName) {
        boolean result = false;
        GrizzlyConfigConstants key = null;
        try {
            key = GrizzlyConfigConstants.valueOf((String)propertyName);
            result = true;
        }
        catch (Throwable ignored) {
            // empty catch block
        }
        if (key == null) {
            try {
                key = ServiceProviderConfigurationKeys.valueOf((String)propertyName);
                result = true;
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        return key != null && result;
    }

    private void initializeGMS() throws GMSException {
        Properties configProps = new Properties();
        int HA_MAX_GMS_MESSAGE_LENGTH = 0x400800;
        configProps.put(ServiceProviderConfigurationKeys.MAX_MESSAGE_LENGTH.toString(), Integer.toString(HA_MAX_GMS_MESSAGE_LENGTH));
        this.readGMSConfigProps(configProps);
        this.printProps(configProps);
        String memberType = (String)configProps.get(MEMBERTYPE_STRING);
        this.gms = (GroupManagementService)GMSFactory.startGMSModule((String)this.instanceName, (String)this.clusterName, (GroupManagementService.MemberType)GroupManagementService.MemberType.valueOf((String)memberType), (Properties)configProps);
        GMSFactory.setGMSEnabledState((String)this.clusterName, (Boolean)Boolean.TRUE);
        if (this.gms != null) {
            try {
                this.registerJoinedAndReadyNotificationListener(this);
                this.registerJoinNotificationListener(this);
                this.registerFailureNotificationListener(this);
                this.registerPlannedShutdownListener(this);
                this.registerFailureSuspectedListener(this);
                if (this.testFailureRecoveryHandler && !this.env.isDas()) {
                    this.registerFailureRecoveryListener("GlassfishFailureRecoveryHandlerTest", this);
                }
                this.glassfishEventListener = new EventListener(){

                    public void event(EventListener.Event event) {
                        if (GMSAdapterImpl.this.gms == null) {
                            return;
                        }
                        if (event.is(EventTypes.SERVER_SHUTDOWN)) {
                            GMS_LOGGER.log(LogLevel.INFO, GMSAdapterImpl.GMS_SERVER_SHUTDOWN_RECEIVED, new Object[]{GMSAdapterImpl.this.gms.getInstanceName(), GMSAdapterImpl.this.gms.getGroupName(), event.name()});
                            GMSAdapterImpl.this.removeJoinedAndReadyNotificationListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.removeJoinNotificationListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.removeFailureNotificationListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.removeFailureSuspectedListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.gms.shutdown(GMSConstants.shutdownType.INSTANCE_SHUTDOWN);
                            GMSAdapterImpl.this.removePlannedShutdownListener(GMSAdapterImpl.this);
                            GMSAdapterImpl.this.events.unregister(GMSAdapterImpl.this.glassfishEventListener);
                        } else if (event.is(EventTypes.SERVER_READY)) {
                            GMSAdapterImpl.this.gms.reportJoinedAndReadyState();
                        }
                    }
                };
                this.events.register(this.glassfishEventListener);
                this.gms.join();
                GMS_LOGGER.log(LogLevel.INFO, GMS_JOINED, new Object[]{this.instanceName, this.clusterName});
            }
            catch (GMSException e) {
                this.events.unregister(this.glassfishEventListener);
                throw e;
            }
        } else {
            throw new GMSException("gms object is null.");
        }
        GMS_LOGGER.log(LogLevel.INFO, GMS_STARTED, new Object[]{this.instanceName, this.clusterName});
    }

    private void printProps(Properties prop) {
        if (!GMS_LOGGER.isLoggable(LogLevel.CONFIG)) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String key : prop.stringPropertyNames()) {
            sb.append(key).append(" = ").append(prop.get(key)).append("  ");
        }
        GMS_LOGGER.log(LogLevel.CONFIG, "Printing all GMS properties: ", sb.toString());
    }

    private void checkInitialized() {
        if (!this.initialized.get() || !this.initializationComplete.get()) {
            throw new IllegalStateException("GMSAdapter not properly initialized.");
        }
    }

    public GroupManagementService getModule() {
        this.checkInitialized();
        return this.gms;
    }

    public GroupManagementService getGMS(String groupName) {
        try {
            return GMSFactory.getGMSModule((String)groupName);
        }
        catch (GMSException e) {
            GMS_LOGGER.log(LogLevel.SEVERE, GMS_EXCEPTION_CANNOT_GET_GROUP_MODULE, new Object[]{groupName, e.getLocalizedMessage()});
            return null;
        }
    }

    public void processNotification(Signal signal) {
        if (GMS_LOGGER.isLoggable(LogLevel.FINE)) {
            GMS_LOGGER.log(LogLevel.FINE, "GMSService: Received a notification ", signal.getClass().getName());
        }
        try {
            if (this.hHistory != null) {
                this.hHistory.updateHealth(signal);
            }
        }
        catch (Throwable t) {
            GMS_LOGGER.log(LogLevel.WARNING, GMS_EXCEPTION_UPDATE_HEALTH_HISTORY, t.getLocalizedMessage());
        }
        if (this.testFailureRecoveryHandler && signal instanceof FailureRecoverySignal) {
            FailureRecoverySignal frsSignal = (FailureRecoverySignal)signal;
            GMS_LOGGER.log(LogLevel.INFO, GMS_FAILURERECOVERY_START, new Object[]{frsSignal.getComponentName(), frsSignal.getMemberToken()});
            try {
                Thread.sleep(20000L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            GMS_LOGGER.log(LogLevel.INFO, GMS_FAILURE_RECOVERY_COMPLETED, new Object[]{frsSignal.getComponentName(), frsSignal.getMemberToken()});
        }
        if (this.aliveAndReadyLoggingEnabled && (signal instanceof JoinedAndReadyNotificationSignal || signal instanceof FailureNotificationSignal || signal instanceof PlannedShutdownSignal)) {
            PlannedShutdownSignal pssig;
            AliveAndReadySignal arSignal = (AliveAndReadySignal)signal;
            String signalSubevent = "";
            if (signal instanceof JoinedAndReadyNotificationSignal) {
                JoinedAndReadyNotificationSignal jrsig = (JoinedAndReadyNotificationSignal)signal;
                if (jrsig.getEventSubType() == GMSConstants.startupType.GROUP_STARTUP) {
                    signalSubevent = " Subevent: " + GMSConstants.startupType.GROUP_STARTUP;
                } else if (jrsig.getRejoinSubevent() != null) {
                    signalSubevent = " Subevent: " + jrsig.getRejoinSubevent();
                }
            }
            if (signal instanceof PlannedShutdownSignal && (pssig = (PlannedShutdownSignal)signal).getEventSubType() == GMSConstants.shutdownType.GROUP_SHUTDOWN) {
                signalSubevent = " Subevent:" + GMSConstants.shutdownType.GROUP_SHUTDOWN.toString();
            }
            AliveAndReadyView current = arSignal.getCurrentView();
            AliveAndReadyView previous = arSignal.getPreviousView();
            GMS_LOGGER.log(LogLevel.INFO, GMS_ALIVE_AND_READY, new Object[]{signal.getClass().getSimpleName() + signalSubevent, signal.getMemberToken(), signal.getGroupName(), current, previous});
        }
    }

    public void registerJoinNotificationListener(CallBack callback) {
        if (this.gms != null && callback != null) {
            JoinNotificationActionFactoryImpl jnaf = new JoinNotificationActionFactoryImpl(callback);
            this.gms.addActionFactory((JoinNotificationActionFactory)jnaf);
            this.callbackJoinActionFactoryMapping.put(callback, (JoinNotificationActionFactory)jnaf);
        }
    }

    public void registerJoinedAndReadyNotificationListener(CallBack callback) {
        if (this.gms != null && callback != null) {
            JoinedAndReadyNotificationActionFactoryImpl jnaf = new JoinedAndReadyNotificationActionFactoryImpl(callback);
            this.gms.addActionFactory((JoinedAndReadyNotificationActionFactory)jnaf);
            this.callbackJoinedAndReadyActionFactoryMapping.put(callback, (JoinedAndReadyNotificationActionFactory)jnaf);
        }
    }

    public void registerMemberLeavingListener(CallBack callback) {
        if (this.gms != null && callback != null) {
            this.registerFailureNotificationListener(callback);
            this.registerPlannedShutdownListener(callback);
            this.registerJoinNotificationListener(callback);
        }
    }

    public void registerPlannedShutdownListener(CallBack callback) {
        if (this.gms != null && callback != null) {
            PlannedShutdownActionFactoryImpl psaf = new PlannedShutdownActionFactoryImpl(callback);
            this.callbackPlannedShutdownActionFactoryMapping.put(callback, (PlannedShutdownActionFactory)psaf);
            this.gms.addActionFactory((PlannedShutdownActionFactory)psaf);
        }
    }

    public void registerFailureSuspectedListener(CallBack callback) {
        if (this.gms != null) {
            FailureSuspectedActionFactoryImpl fsaf = new FailureSuspectedActionFactoryImpl(callback);
            this.callbackFailureSuspectedActionFactoryMapping.put(callback, (FailureSuspectedActionFactory)fsaf);
            this.gms.addActionFactory((FailureSuspectedActionFactory)fsaf);
        }
    }

    public void registerFailureNotificationListener(CallBack callback) {
        if (this.gms != null) {
            FailureNotificationActionFactoryImpl fnaf = new FailureNotificationActionFactoryImpl(callback);
            this.callbackFailureActionFactoryMapping.put(callback, (FailureNotificationActionFactory)fnaf);
            this.gms.addActionFactory((FailureNotificationActionFactory)fnaf);
        }
    }

    public void registerFailureRecoveryListener(String componentName, CallBack callback) {
        if (this.gms != null) {
            this.gms.addActionFactory(componentName, (FailureRecoveryActionFactory)new FailureRecoveryActionFactoryImpl(callback));
        }
    }

    public void registerMessageListener(String componentName, CallBack messageListener) {
        if (this.gms != null) {
            this.gms.addActionFactory((MessageActionFactory)new MessageActionFactoryImpl(messageListener), componentName);
        }
    }

    public void registerGroupLeadershipNotificationListener(CallBack callback) {
        if (this.gms != null) {
            this.gms.addActionFactory((GroupLeadershipNotificationActionFactory)new GroupLeadershipNotificationActionFactoryImpl(callback));
        }
    }

    public void removeFailureRecoveryListener(String componentName) {
        if (this.gms != null) {
            this.gms.removeFailureRecoveryActionFactory(componentName);
        }
    }

    public void removeMessageListener(String componentName) {
        if (this.gms != null) {
            this.gms.removeMessageActionFactory(componentName);
        }
    }

    public void removeFailureNotificationListener(CallBack callback) {
        FailureNotificationActionFactory fnaf;
        if (this.gms != null && (fnaf = this.callbackFailureActionFactoryMapping.remove(callback)) != null) {
            this.gms.removeActionFactory(fnaf);
        }
    }

    public void removeFailureSuspectedListener(CallBack callback) {
        FailureSuspectedActionFactory fsaf;
        if (this.gms != null && (fsaf = this.callbackFailureSuspectedActionFactoryMapping.remove(callback)) != null) {
            this.gms.removeFailureSuspectedActionFactory(fsaf);
        }
    }

    public void removeJoinNotificationListener(CallBack callback) {
        JoinNotificationActionFactory jaf;
        if (this.gms != null && (jaf = this.callbackJoinActionFactoryMapping.get(callback)) != null) {
            this.gms.removeActionFactory(jaf);
        }
    }

    public void removeJoinedAndReadyNotificationListener(CallBack callback) {
        JoinedAndReadyNotificationActionFactory jaf;
        if (this.gms != null && (jaf = this.callbackJoinedAndReadyActionFactoryMapping.get(callback)) != null) {
            this.gms.removeActionFactory(jaf);
        }
    }

    public void removePlannedShutdownListener(CallBack callback) {
        PlannedShutdownActionFactory psaf;
        if (this.gms != null && (psaf = this.callbackPlannedShutdownActionFactoryMapping.remove(callback)) != null) {
            this.gms.removeActionFactory(psaf);
        }
    }

    public void removeGroupLeadershipLNotificationistener(CallBack callback) {
        GroupLeadershipNotificationActionFactory glnf;
        if (this.gms != null && (glnf = this.callbackGroupLeadershipActionFactoryMapping.get(callback)) != null) {
            this.gms.removeActionFactory(glnf);
        }
    }

    public void removeMemberLeavingListener(CallBack callback) {
        this.removePlannedShutdownListener(callback);
        this.removeFailureNotificationListener(callback);
        this.removeJoinNotificationListener(callback);
    }
}

