/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.Strings;
import com.sun.enterprise.admin.cli.remote.RemoteCLICommand;
import com.sun.enterprise.admin.servermgmt.cli.LocalServerCommand;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.io.InstanceDirs;
import com.sun.enterprise.util.io.ServerDirs;
import com.sun.enterprise.util.net.NetUtils;
import java.io.BufferedOutputStream;
import java.io.Console;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;

public abstract class LocalInstanceCommand
extends LocalServerCommand {
    @Param(name="nodedir", optional=true, alias="agentdir")
    protected String nodeDir;
    @Param(name="node", optional=true, alias="nodeagent")
    protected String node;
    protected String instanceName;
    protected File nodeDirRoot;
    protected File nodeDirChild;
    protected File instanceDir;
    protected String domainName;
    protected boolean isCreateInstanceFilesystem = false;
    private InstanceDirs instanceDirs;
    protected boolean checkOneAndOnly = true;

    protected void validate() throws CommandException, CommandValidationException {
        this.initInstance();
    }

    protected boolean mkdirs(File f) {
        return f.mkdirs();
    }

    protected boolean isDirectory(File f) {
        return f.isDirectory();
    }

    protected boolean setServerDirs() {
        return true;
    }

    protected void initInstance() throws CommandException {
        String nodeDirRootPath = null;
        nodeDirRootPath = LocalInstanceCommand.ok((String)this.nodeDir) ? this.nodeDir : this.getNodeDirRootDefault();
        this.nodeDirRoot = new File(nodeDirRootPath);
        this.mkdirs(this.nodeDirRoot);
        if (LocalInstanceCommand.ok((String)this.nodeDir)) {
            this.nodeDir = this.nodeDirRoot.getAbsolutePath();
        }
        if (!this.isDirectory(this.nodeDirRoot)) {
            throw new CommandException(Strings.get("Instance.badNodeDir", this.nodeDirRoot));
        }
        this.nodeDirChild = this.node != null ? new File(this.nodeDirRoot, this.node) : this.getTheOneAndOnlyNode(this.nodeDirRoot);
        if (this.getInstanceName() != null) {
            this.instanceDir = new File(this.nodeDirChild, this.getInstanceName());
            this.mkdirs(this.instanceDir);
        } else {
            this.instanceDir = this.getTheOneAndOnlyInstance(this.nodeDirChild);
            this.setInstanceName(this.instanceDir.getName());
        }
        if (!this.isDirectory(this.instanceDir)) {
            throw new CommandException(Strings.get("Instance.badInstanceDir", this.instanceDir));
        }
        this.nodeDirChild = SmartFile.sanitize((File)this.nodeDirChild);
        this.instanceDir = SmartFile.sanitize((File)this.instanceDir);
        try {
            if (this.setServerDirs()) {
                this.instanceDirs = new InstanceDirs(this.instanceDir);
                this.setServerDirs(this.instanceDirs.getServerDirs());
            }
        }
        catch (IOException e) {
            throw new CommandException((Throwable)e);
        }
        logger.log(Level.FINER, "nodeDirChild: {0}", this.nodeDirChild);
        logger.log(Level.FINER, "instanceDir: {0}", this.instanceDir);
    }

    protected final InstanceDirs getInstanceDirs() {
        return this.instanceDirs;
    }

    protected final void setDasDefaults(File propfile) throws CommandException {
        Properties dasprops = this.getDasProperties(propfile);
        String p = dasprops.getProperty("agent.das.host");
        if (p != null) {
            this.programOpts.setHost(p);
        }
        p = dasprops.getProperty("agent.das.port");
        int port = -1;
        if (p != null) {
            port = Integer.parseInt(p);
        }
        if ((p = dasprops.getProperty("agent.das.protocol")) != null && p.equals("rmi_jrmp")) {
            this.programOpts.setPort(this.updateDasPort(dasprops, port, propfile));
        } else if (p == null || p.equals("http")) {
            this.programOpts.setPort(port);
        } else {
            throw new CommandException(Strings.get("Instance.badProtocol", propfile.toString(), p));
        }
        p = dasprops.getProperty("agent.das.isSecure");
        if (p != null) {
            this.programOpts.setSecure(Boolean.parseBoolean(p));
        }
        if ((p = dasprops.getProperty("agent.das.user")) != null) {
            this.programOpts.setUser(p);
        }
    }

    protected final void validateDasOptions(String hostOption, String portOption, String isSecureOption, File propfile) throws CommandException {
        Properties dasprops;
        if (propfile != null && !(dasprops = this.getDasProperties(propfile)).isEmpty()) {
            Object errorMsg = "";
            String nodeName = this.nodeDirChild != null ? this.nodeDirChild.getName() : "";
            String hostProp = dasprops.getProperty("agent.das.host");
            String portProp = dasprops.getProperty("agent.das.port");
            String secureProp = dasprops.getProperty("agent.das.isSecure");
            if (!this.matchingHostnames(hostProp, hostOption)) {
                errorMsg = (String)errorMsg + Strings.get("Instance.DasHostInvalid", hostOption, nodeName) + "\n";
            }
            if (portProp != null && !portProp.equals(portOption)) {
                errorMsg = (String)errorMsg + Strings.get("Instance.DasPortInvalid", portOption, nodeName) + "\n";
            }
            if (secureProp != null && !secureProp.equals(isSecureOption)) {
                errorMsg = (String)errorMsg + Strings.get("Instance.DasIsSecureInvalid", isSecureOption, nodeName) + "\n";
            }
            if (!((String)errorMsg).isEmpty()) {
                errorMsg = (String)errorMsg + Strings.get("Instance.DasConfig", nodeName, hostProp, portProp, secureProp);
                throw new CommandException((String)errorMsg);
            }
        }
    }

    private boolean matchingHostnames(String host1, String host2) {
        if (!StringUtils.ok((String)host1) || !StringUtils.ok((String)host2)) {
            return !StringUtils.ok((String)host1) && !StringUtils.ok((String)host2);
        }
        if (host1.equalsIgnoreCase(host2)) {
            return true;
        }
        if (NetUtils.isSameHost((String)host1, (String)host2)) {
            return true;
        }
        return NetUtils.isThisHostLocal((String)host1) && NetUtils.isThisHostLocal((String)host2);
    }

    protected final Properties getDasProperties(File propfile) throws CommandException {
        Properties dasprops = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(propfile);
            dasprops.load(fis);
            fis.close();
            fis = null;
        }
        catch (IOException ioex) {
            throw new CommandException(Strings.get("Instance.cantReadDasProperties", propfile.getPath()));
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return dasprops;
    }

    protected final void whackFilesystem() throws CommandException {
        File tmpwhackee;
        ServerDirs dirs = this.getServerDirs();
        File whackee = dirs.getServerDir();
        File parent = dirs.getServerParentDir();
        File grandParent = dirs.getServerGrandParentDir();
        if (whackee == null || !whackee.isDirectory()) {
            throw new CommandException(Strings.get("DeleteInstance.noWhack", whackee));
        }
        File[] files = whackee.listFiles();
        if (files == null || files.length <= 0) {
            if (files != null) {
                FileUtils.whack((File)whackee);
            }
            throw new CommandException(Strings.get("DeleteInstance.noWhack", whackee));
        }
        try {
            tmpwhackee = File.createTempFile("oldinst", null, parent);
            if (!tmpwhackee.delete()) {
                throw new IOException(Strings.get("cantdelete", tmpwhackee));
            }
            FileUtils.renameFile((File)whackee, (File)tmpwhackee);
            FileUtils.whack((File)tmpwhackee);
        }
        catch (IOException ioe) {
            throw new CommandException(Strings.get("DeleteInstance.badWhackWithException", whackee, ioe, StringUtils.getStackTrace((Throwable)ioe)));
        }
        if (whackee.isDirectory()) {
            StringBuilder sb = new StringBuilder();
            sb.append("whackee=").append(whackee.toString());
            sb.append(", files in parent:");
            for (File f : files = parent.listFiles()) {
                sb.append(f.toString()).append(", ");
            }
            File f1 = new File(whackee.toString());
            sb.append(", new wackee.exists=").append(f1.exists());
            throw new CommandException(Strings.get("DeleteInstance.badWhack", whackee) + ", " + String.valueOf(sb));
        }
        try {
            files = parent.listFiles();
            if (this.noInstancesRemain(files)) {
                tmpwhackee = File.createTempFile("oldnode", null, grandParent);
                if (!tmpwhackee.delete()) {
                    throw new IOException(Strings.get("cantdelete", tmpwhackee));
                }
                FileUtils.renameFile((File)parent, (File)tmpwhackee);
                FileUtils.whack((File)tmpwhackee);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private boolean noInstancesRemain(File[] files) {
        if (files == null || files.length <= 0) {
            return true;
        }
        return files.length == 1 && files[0].isDirectory() && files[0].getName().equals("agent");
    }

    protected String getInstallRootPath() throws CommandException {
        String installRootPath = this.getSystemProperty("com.sun.aas.installRoot");
        if (!StringUtils.ok((String)installRootPath)) {
            installRootPath = System.getProperty("com.sun.aas.installRoot");
        }
        if (!StringUtils.ok((String)installRootPath)) {
            throw new CommandException("noInstallDirPath");
        }
        return installRootPath;
    }

    protected String getProductRootPath() throws CommandException {
        String productRootPath = this.getSystemProperty("com.sun.aas.productRoot");
        if (!StringUtils.ok((String)productRootPath)) {
            productRootPath = System.getProperty("com.sun.aas.productRoot");
        }
        if (!StringUtils.ok((String)productRootPath)) {
            File installRoot = new File(this.getInstallRootPath());
            return installRoot.getParent();
        }
        return productRootPath;
    }

    protected String getNodeInstallDir() throws CommandException {
        String installDir = null;
        try {
            RemoteCLICommand rc = new RemoteCLICommand("get", this.programOpts, this.env);
            String s = rc.executeAndReturnOutput(new String[]{"get", "nodes.node." + this.node + ".install-dir"});
            if (s != null) {
                installDir = s.substring(s.indexOf(61) + 1);
            }
        }
        catch (CommandException commandException) {
            // empty catch block
        }
        return installDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateDasPort(Properties dasprops, int port, File propfile) {
        if (port == 8686) {
            logger.info(Strings.get("Instance.oldDasProperties", propfile.toString(), Integer.toString(port), Integer.toString(this.programOpts.getPort())));
            port = this.programOpts.getPort();
        } else {
            Console cons = System.console();
            if (cons != null) {
                String line = cons.readLine("%s", Strings.get("Instance.oldDasPropertiesPrompt", propfile.toString(), Integer.toString(port), Integer.toString(this.programOpts.getPort())));
                while (line != null && line.length() > 0) {
                    block19: {
                        try {
                            port = Integer.parseInt(line);
                            if (port <= 0 || port > 65535) break block19;
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    line = cons.readLine(Strings.get("Instance.reenterPort"), Integer.toString(this.programOpts.getPort()));
                }
            } else {
                logger.info(Strings.get("Instance.oldDasPropertiesWrong", propfile.toString(), Integer.toString(port), Integer.toString(this.programOpts.getPort())));
                port = this.programOpts.getPort();
            }
        }
        dasprops.setProperty("agent.das.protocol", "http");
        dasprops.setProperty("agent.das.port", Integer.toString(port));
        FilterOutputStream bos = null;
        try {
            bos = new BufferedOutputStream(new FileOutputStream(propfile));
            dasprops.store(bos, "Domain Administration Server Connection Properties");
            bos.close();
            bos = null;
        }
        catch (IOException ex2) {
            logger.info(Strings.get("Instance.dasPropertiesUpdateFailed"));
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException iOException) {}
            }
        }
        logger.log(Level.FINER, "New DAS port number: {0}", port);
        return port;
    }

    private File getTheOneAndOnlyNode(File parent) throws CommandException {
        File[] files = parent.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return LocalInstanceCommand.this.isDirectory(f);
            }
        });
        if (files != null && files.length > 1) {
            throw new CommandException(Strings.get("tooManyNodes", parent));
        }
        if (files != null && files.length == 1) {
            return files[0];
        }
        if (this.isCreateInstanceFilesystem) {
            try {
                File f;
                Object hostname;
                String dashost = null;
                if (this.programOpts != null) {
                    dashost = this.programOpts.getHost();
                }
                if (((String)(hostname = InetAddress.getLocalHost().getHostName())).equals(dashost) || NetUtils.isThisHostLocal((String)dashost)) {
                    hostname = "localhost-" + this.domainName;
                }
                if (!this.mkdirs(f = new File(parent, (String)hostname)) && !this.isDirectory(f)) {
                    throw new CommandException(Strings.get("cantCreateNodeDirChild", f));
                }
                return f;
            }
            catch (UnknownHostException ex) {
                throw new CommandException(Strings.get("cantGetHostName", ex));
            }
        }
        throw new CommandException(Strings.get("DeleteInstance.noInstance"));
    }

    private File getTheOneAndOnlyInstance(File parent) throws CommandException {
        File[] files = parent.listFiles(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return LocalInstanceCommand.this.isDirectory(f);
            }
        });
        if (files == null || files.length == 0) {
            throw new CommandException(Strings.get("Instance.noInstanceDirs", parent));
        }
        if (files.length > 2 && this.checkOneAndOnly) {
            throw new CommandException(Strings.get("Instance.tooManyInstanceDirs", parent));
        }
        for (File f : files) {
            if (f.getName().equals("agent")) continue;
            return f;
        }
        throw new CommandException(Strings.get("Instance.noInstanceDirs", parent));
    }

    private String getNodeDirRootDefault() throws CommandException {
        String nodeDirDefault = this.getSystemProperty("com.sun.aas.agentRoot");
        if (StringUtils.ok((String)nodeDirDefault)) {
            return nodeDirDefault;
        }
        String installRootPath = this.getInstallRootPath();
        return installRootPath + "/nodes";
    }

    protected File getMasterPasswordFile() {
        if (this.nodeDirChild == null) {
            return null;
        }
        File mp = new File(new File(this.nodeDirChild, "agent"), "master-password");
        if (!mp.canRead()) {
            return null;
        }
        return mp;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }
}

