/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.cluster;

import com.sun.enterprise.admin.cli.cluster.NativeRemoteCommandsBase;
import com.sun.enterprise.admin.cli.cluster.Strings;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service
@Scoped(value=PerLookup.class)
abstract class UninstallNodeBaseCommand
extends NativeRemoteCommandsBase {
    @Param(name="installdir", optional=true, defaultValue="${com.sun.aas.productRoot}")
    private String installDir;
    @Param(optional=true, defaultValue="false")
    private boolean force;
    @Inject
    private Habitat habitat;

    UninstallNodeBaseCommand() {
    }

    abstract void deleteFromHosts() throws CommandException;

    protected void validate() throws CommandException {
        super.validate();
        Globals.setDefaultHabitat((Habitat)this.habitat);
        this.installDir = this.resolver.resolve(this.installDir);
        if (!this.force) {
            for (String host : this.hosts) {
                if (!this.checkIfNodeExistsForHost(host, this.installDir)) continue;
                throw new CommandException(Strings.get("call.delete.node.ssh", host));
            }
        }
    }

    protected final int executeCommand() throws CommandException {
        this.deleteFromHosts();
        return 0;
    }

    final String getInstallDir() {
        return this.installDir;
    }

    final boolean getForce() {
        return this.force;
    }
}

