/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.cluster;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.v3.admin.cluster.Strings;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.I18n;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandLock;
import org.glassfish.api.admin.ExecuteOn;
import org.glassfish.api.admin.RestEndpoint;
import org.glassfish.api.admin.RestEndpoints;
import org.glassfish.api.admin.RuntimeType;
import org.glassfish.api.admin.config.ReferenceContainer;
import org.glassfish.config.support.CommandTarget;
import org.glassfish.config.support.TargetType;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="list-configs")
@I18n(value="list.configs.command")
@Scoped(value=PerLookup.class)
@CommandLock(value=CommandLock.LockType.NONE)
@ExecuteOn(value={RuntimeType.DAS})
@TargetType(value={CommandTarget.CLUSTER, CommandTarget.CONFIG, CommandTarget.DAS, CommandTarget.DOMAIN, CommandTarget.STANDALONE_INSTANCE, CommandTarget.CLUSTERED_INSTANCE})
@RestEndpoints(value={@RestEndpoint(configBean=Configs.class, opType=RestEndpoint.OpType.GET, path="list-configs", description="list-configs")})
public final class ListConfigsCommand
implements AdminCommand {
    @Inject
    private Domain domain;
    @Param(optional=true, primary=true, defaultValue="domain")
    private String target;
    private ActionReport report;
    @Inject
    private Configs allConfigs;

    public void execute(AdminCommandContext context) {
        ActionReport report = context.getActionReport();
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
        List configList = null;
        if (this.target.equals("domain")) {
            Configs configs = this.domain.getConfigs();
            configList = configs.getConfig();
        } else {
            configList = this.createConfigList();
            if (configList == null) {
                this.fail(Strings.get("list.instances.badTarget", this.target));
                return;
            }
        }
        StringBuffer sb = new StringBuffer();
        for (Config config : configList) {
            sb.append(config.getName()).append('\n');
        }
        String output = sb.toString();
        report.addSubActionsReport().setMessage(output.substring(0, output.length() - 1));
        report.setActionExitCode(ActionReport.ExitCode.SUCCESS);
    }

    private void fail(String s) {
        this.report.setActionExitCode(ActionReport.ExitCode.FAILURE);
        this.report.setMessage(s);
    }

    private List<Config> createConfigList() {
        if (!StringUtils.ok((String)this.target)) {
            return this.allConfigs.getConfig();
        }
        Config c = this.domain.getConfigNamed(this.target);
        if (c != null) {
            LinkedList<Config> cl = new LinkedList<Config>();
            cl.add(c);
            return cl;
        }
        ReferenceContainer rc = this.domain.getReferenceContainerNamed(this.target);
        if (rc == null) {
            return null;
        }
        if (rc.isServer()) {
            Server s = (Server)rc;
            LinkedList<Config> cl = new LinkedList<Config>();
            cl.add(s.getConfig());
            return cl;
        }
        if (rc.isCluster()) {
            Cluster cluster = (Cluster)rc;
            LinkedList<Config> cl = new LinkedList<Config>();
            cl.add(this.domain.getConfigNamed(cluster.getConfigRef()));
            return cl;
        }
        return null;
    }
}

