/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.batch;

import com.sun.enterprise.config.serverbeans.Server;
import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.Param;
import org.glassfish.api.admin.AdminCommand;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.CommandRunner;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Target;

public abstract class AbstractListCommandProxy
implements AdminCommand {
    @Inject
    protected ServiceLocator serviceLocator;
    @Inject
    protected Target targetUtil;
    @Inject
    protected Logger logger;
    @Param(name="terse", optional=true, defaultValue="false", shortName="t")
    protected boolean isTerse = false;
    @Param(name="output", shortName="o", optional=true)
    protected String outputHeaderList;
    @Param(name="header", shortName="h", optional=true)
    protected boolean header;
    @Param(name="target", optional=true, defaultValue="server")
    protected String target;
    @Param(name="long", shortName="l", optional=true)
    protected boolean useLongFormat;
    protected ActionReport.ExitCode commandsExitCode = ActionReport.ExitCode.SUCCESS;

    public final void execute(AdminCommandContext context) {
        ActionReport actionReport = context.getActionReport();
        Properties extraProperties = actionReport.getExtraProperties();
        if (extraProperties == null) {
            extraProperties = new Properties();
            actionReport.setExtraProperties(extraProperties);
        }
        ActionReport subReport = null;
        if (!this.preInvoke(context, actionReport)) {
            this.commandsExitCode = ActionReport.ExitCode.FAILURE;
            return;
        }
        if (this.targetUtil.isCluster(this.target)) {
            for (Server serverInst : this.targetUtil.getInstances(this.target)) {
                try {
                    subReport = this.executeInternalCommand(context, serverInst.getName());
                    break;
                }
                catch (Throwable ex) {
                    this.logger.log(Level.INFO, "Got exception: " + ex.toString());
                }
            }
        } else {
            subReport = this.target.equals("server") ? this.executeInternalCommand(context, this.target) : this.executeInternalCommand(context, this.target);
        }
        if (subReport != null) {
            if (subReport.getExtraProperties() != null && subReport.getExtraProperties().size() > 0) {
                this.postInvoke(context, subReport);
            } else if (subReport.getSubActionsReport() != null && subReport.getSubActionsReport().size() > 0) {
                this.postInvoke(context, (ActionReport)subReport.getSubActionsReport().get(0));
            } else {
                actionReport.setMessage(subReport.getMessage());
                this.commandsExitCode = subReport.getActionExitCode();
            }
        }
        actionReport.setActionExitCode(this.commandsExitCode);
    }

    protected boolean preInvoke(AdminCommandContext ctx, ActionReport subReport) {
        return true;
    }

    protected abstract String getCommandName();

    protected abstract void postInvoke(AdminCommandContext var1, ActionReport var2);

    private ActionReport executeInternalCommand(AdminCommandContext context, String targetInstanceName) {
        String commandName = this.getCommandName();
        ParameterMap params = new ParameterMap();
        params.add((Object)"target", (Object)targetInstanceName);
        this.fillParameterMap(params);
        CommandRunner runner = (CommandRunner)this.serviceLocator.getService(CommandRunner.class, new Annotation[0]);
        ActionReport subReport = context.getActionReport().addSubActionsReport();
        CommandRunner.CommandInvocation inv = runner.getCommandInvocation(commandName, subReport, context.getSubject());
        inv.parameters(params);
        inv.execute();
        return subReport;
    }

    protected void fillParameterMap(ParameterMap parameterMap) {
        if (this.isTerse) {
            parameterMap.add((Object)"terse", (Object)("" + this.isTerse));
        }
        if (this.outputHeaderList != null) {
            parameterMap.add((Object)"output", (Object)this.outputHeaderList);
        }
        if (this.header) {
            parameterMap.add((Object)"header", (Object)("" + this.header));
        }
        if (this.useLongFormat) {
            parameterMap.add((Object)"long", (Object)("" + this.useLongFormat));
        }
    }

    protected boolean isLongNumber(String str) {
        try {
            long l = Long.parseLong(str);
        }
        catch (NumberFormatException nEx) {
            return false;
        }
        return true;
    }
}

