/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ant.embedded.tasks;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;

public class Util {
    private static final Map<String, GlassFish> gfMap = new HashMap<String, GlassFish>();
    private static GlassFishRuntime glassfishRuntime;

    public static synchronized GlassFish startGlassFish(String serverID, String installRoot, String instanceRoot, String configFile, boolean configFileReadOnly, int httpPort) throws GlassFishException {
        GlassFish glassfish = gfMap.get(serverID);
        if (glassfish != null) {
            return glassfish;
        }
        if (glassfishRuntime == null) {
            BootstrapProperties bootstrapProperties = new BootstrapProperties();
            if (installRoot != null) {
                bootstrapProperties.setInstallRoot(installRoot);
            }
            glassfishRuntime = GlassFishRuntime.bootstrap((BootstrapProperties)bootstrapProperties);
        }
        GlassFishProperties glassfishProperties = new GlassFishProperties();
        if (instanceRoot != null) {
            glassfishProperties.setInstanceRoot(instanceRoot);
        }
        if (configFile != null) {
            glassfishProperties.setConfigFileURI(new File(configFile).toURI().toString());
            glassfishProperties.setConfigFileReadOnly(configFileReadOnly);
        }
        if (instanceRoot == null && configFile == null && httpPort != -1) {
            glassfishProperties.setPort("http-listener", httpPort);
        }
        glassfish = glassfishRuntime.newGlassFish(glassfishProperties);
        glassfish.start();
        gfMap.put(serverID, glassfish);
        System.out.println("Started GlassFish [" + serverID + "]");
        return glassfish;
    }

    public static void deploy(String app, String serverId, List<String> deployParams) throws Exception {
        GlassFish glassfish = gfMap.get(serverId);
        if (glassfish == null) {
            throw new Exception("Embedded GlassFish [" + serverId + "] not running");
        }
        if (app == null) {
            throw new Exception("Application can not be null");
        }
        Deployer deployer = glassfish.getDeployer();
        int len = deployParams.size();
        if (len > 0) {
            deployer.deploy(new File(app).toURI(), (String[])deployParams.toArray(String[]::new));
            System.out.println("Deployed [" + app + "] with parameters " + String.valueOf(deployParams));
        } else {
            deployer.deploy(new File(app).toURI(), new String[0]);
            System.out.println("Deployed [" + app + "]");
        }
    }

    public static void undeploy(String appName, String serverId) throws Exception {
        GlassFish glassfish = gfMap.get(serverId);
        if (glassfish == null) {
            throw new Exception("Embedded GlassFish [" + serverId + "] not running");
        }
        if (appName == null) {
            throw new Exception("Application name can not be null");
        }
        Deployer deployer = glassfish.getDeployer();
        deployer.undeploy(appName, new String[0]);
        System.out.println("Undeployed [" + appName + "]");
    }

    public static void runCommand(String commandLine, String serverId) throws Exception {
        GlassFish glassfish = gfMap.get(serverId);
        if (glassfish == null) {
            throw new Exception("Embedded GlassFish [" + serverId + "] not running");
        }
        if (commandLine == null) {
            throw new Exception("Command can not be null");
        }
        String[] split = commandLine.split(" ");
        String command = split[0].trim();
        String[] commandParams = null;
        if (split.length > 1) {
            commandParams = new String[split.length - 1];
            for (int i = 1; i < split.length; ++i) {
                commandParams[i - 1] = split[i].trim();
            }
        }
        CommandRunner cr = glassfish.getCommandRunner();
        CommandResult result = commandParams == null ? cr.run(command, new String[0]) : cr.run(command, commandParams);
        System.out.println("Executed command [" + commandLine + "]. Output : \n" + result.getOutput());
    }

    public static synchronized void disposeGlassFish(String serverID) throws GlassFishException {
        GlassFish glassfish = gfMap.remove(serverID);
        if (glassfish != null) {
            glassfish.dispose();
            System.out.println("Stopped GlassFish [" + serverID + "]");
        }
    }
}

