/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.plugin.jms;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.Attribute;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;

public class JMXUtil {
    public static final String DomainDiagnosticsMBeanName = "com.sun.appserv:type=DomainDiagnostics,name=server,category=monitor";
    public static final String DomainDiagnosticsGenerateReportMethod = "generateReport";

    public static MBeanServerConnection getMBeanServer() {
        return ManagementFactory.getPlatformMBeanServer();
    }

    public static Object invoke(String objectName, String operationName) {
        return JMXUtil.invoke(objectName, operationName, new Object[0], new String[0]);
    }

    public static Object invoke(String objectName, String operationName, Object[] params, String[] signature) {
        try {
            Object result = JMXUtil.invoke(new ObjectName(objectName), operationName, params, signature);
            return result;
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(objectName + " is MalformedObjectName.", ex);
        }
    }

    public static Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) {
        try {
            Object result = JMXUtil.getMBeanServer().invoke(objectName, operationName, params, signature);
            return result;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object getAttribute(String objectName, String attributeName) {
        try {
            Object result = JMXUtil.getAttribute(new ObjectName(objectName), attributeName);
            return result;
        }
        catch (MalformedObjectNameException ex) {
            return null;
        }
    }

    public static Object getAttribute(ObjectName objectName, String attributeName) {
        try {
            return JMXUtil.getMBeanServer().getAttribute(objectName, attributeName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static void setAttribute(String objectName, Attribute attributeName) {
        try {
            JMXUtil.setAttribute(new ObjectName(objectName), attributeName);
        }
        catch (MalformedObjectNameException ex) {
            throw new RuntimeException(objectName + " is MalformedObjectName.", ex);
        }
    }

    public static void setAttribute(ObjectName objectName, Attribute attributeName) {
        try {
            JMXUtil.getMBeanServer().setAttribute(objectName, attributeName);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Object getDefaultAttributeValue(String objName, String[] params) {
        String operName = "getDefaultAttributeValue";
        String[] signature = new String[]{"java.lang.String"};
        Object defaultValue = JMXUtil.invoke(objName, operName, (Object[])params, signature);
        return defaultValue;
    }

    public static boolean isValidMBean(String objectName) {
        boolean valid = false;
        try {
            Set<ObjectInstance> beans = JMXUtil.getMBeanServer().queryMBeans(new ObjectName(objectName), null);
            if (beans.size() > 0) {
                valid = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valid;
    }
}

