/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.servlet;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DownloadServlet
extends HttpServlet {
    private static Map<String, String> mimeTypes = new HashMap<String, String>(120);
    private static Map<String, ContentSource> _contentSources;
    public static final String DOWNLOAD_CONTEXT = "downloadContext";
    public static final String CONTENT_SOURCES = "ContentSources";
    public static final String CONTENT_SOURCE_ID = "contentSourceId";
    public static final String CONTENT_TYPE = "ContentType";
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final String EXTENSION = "extension";

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String sources = config.getInitParameter(CONTENT_SOURCES);
        if (sources == null || sources.trim().length() == 0) {
            throw new ServletException("No ContentSources specified!  Ensure at least 1 DownloadServlet.ContentSource is provided as a Servlet init parameter (key: ContentSources).");
        }
        StringTokenizer tokens = new StringTokenizer(sources, " \t\n\r\f,;:");
        while (tokens.hasMoreTokens()) {
            this.registerContentSource(tokens.nextToken());
        }
    }

    public void registerContentSource(String className) {
        if (className == null || className.trim().equals("")) {
            return;
        }
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        this.registerContentSource(cls);
    }

    public void registerContentSource(Class cls) {
        ContentSource source = null;
        try {
            source = (ContentSource)cls.newInstance();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        _contentSources.put(source.getId(), source);
    }

    public ContentSource getContentSource(String id) {
        return _contentSources.get(id);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doPost(request, response);
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Context context = this.getDownloadContext(request, response);
        ContentSource source = this.getContentSource((ServletRequest)request);
        this.writeContent(source, context);
        source.cleanUp(context);
    }

    protected Context getDownloadContext(HttpServletRequest request, HttpServletResponse response) {
        Context ctx = (Context)request.getAttribute(DOWNLOAD_CONTEXT);
        if (ctx == null) {
            ctx = new Context();
            ctx.setServlet((Servlet)this);
            ctx.setServletConfig(this.getServletConfig());
            ctx.setServletRequest((ServletRequest)request);
            request.setAttribute(DOWNLOAD_CONTEXT, (Object)ctx);
        }
        ctx.setServletResponse((ServletResponse)response);
        return ctx;
    }

    protected ContentSource getContentSource(ServletRequest request) {
        String id = request.getParameter(CONTENT_SOURCE_ID);
        if (id == null && (id = this.getServletConfig().getInitParameter(CONTENT_SOURCE_ID)) == null) {
            throw new RuntimeException("You must provide the 'contentSourceId' request parameter!");
        }
        ContentSource src = this.getContentSource(id);
        if (src == null) {
            throw new RuntimeException("The ContentSource with id '" + id + "' is not registered!");
        }
        return src;
    }

    protected void writeHeader(ContentSource source, Context context) {
        String contentType;
        ServletResponse resp = context.getServletResponse();
        if (!(resp instanceof HttpServletResponse)) {
            return;
        }
        long longTime = source.getLastModified(context);
        if (longTime != -1L) {
            ((HttpServletResponse)resp).setDateHeader("Last-Modified", longTime);
        }
        if ((contentType = (String)context.getAttribute(CONTENT_TYPE)) == null) {
            String ext = (String)context.getAttribute(EXTENSION);
            if (ext != null) {
                contentType = mimeTypes.get(ext);
            }
            if (contentType == null) {
                contentType = DEFAULT_CONTENT_TYPE;
            }
        }
        ((HttpServletResponse)resp).setHeader("Content-type", contentType);
    }

    protected void writeContent(ContentSource source, Context context) {
        InputStream in = source.getInputStream(context);
        ServletResponse resp = context.getServletResponse();
        if (in == null) {
            String jspPage = (String)context.getAttribute("JSP_PAGE_SERVED");
            if (jspPage != null && jspPage.equals("false")) {
                try {
                    ((HttpServletResponse)resp).sendError(404, "File Not Found");
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            return;
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            BufferedInputStream stream = new BufferedInputStream(in);
            this.writeHeader(source, context);
            byte[] buf = new byte[512];
            int read = ((InputStream)stream).read(buf, 0, 512);
            while (read != -1) {
                out.write(buf, 0, read);
                read = ((InputStream)stream).read(buf, 0, 512);
            }
            ((InputStream)stream).close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected long getLastModified(HttpServletRequest request) {
        Context context = this.getDownloadContext(request, null);
        ContentSource source = this.getContentSource((ServletRequest)request);
        return source.getLastModified(context);
    }

    static {
        mimeTypes.put("aif", "audio/x-aiff");
        mimeTypes.put("aifc", "audio/x-aiff");
        mimeTypes.put("aiff", "audio/x-aiff");
        mimeTypes.put("asc", "text/plain");
        mimeTypes.put("asf", "application/x-ms-asf");
        mimeTypes.put("asx", "application/x-ms-asf");
        mimeTypes.put("au", "audio/basic");
        mimeTypes.put("avi", "video/x-msvideo");
        mimeTypes.put("bin", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("bmp", "image/bmp");
        mimeTypes.put("bwf", "audio/wav");
        mimeTypes.put("bz2", "application/x-bzip2");
        mimeTypes.put("c", "text/plain");
        mimeTypes.put("cc", "text/plain");
        mimeTypes.put("cdda", "audio/x-aiff");
        mimeTypes.put("class", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("com", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("cpp", "text/plain");
        mimeTypes.put("cpr", "image/cpr");
        mimeTypes.put("css", "text/css");
        mimeTypes.put("doc", "application/msword");
        mimeTypes.put("dot", "application/msword");
        mimeTypes.put("dtd", "text/xml");
        mimeTypes.put("ear", "application/zip");
        mimeTypes.put("exe", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("flc", "video/flc");
        mimeTypes.put("fm", "application/x-maker");
        mimeTypes.put("frame", "application/x-maker");
        mimeTypes.put("frm", "application/x-maker");
        mimeTypes.put("h", "text/plain");
        mimeTypes.put("hh", "text/plain");
        mimeTypes.put("hpp", "text/plain");
        mimeTypes.put("hqx", "application/mac-binhex40");
        mimeTypes.put("htm", "text/html");
        mimeTypes.put("html", "text/html");
        mimeTypes.put("gif", "image/gif");
        mimeTypes.put("gz", "application/x-gunzip");
        mimeTypes.put("ico", "image/x-icon");
        mimeTypes.put("iso", DEFAULT_CONTENT_TYPE);
        mimeTypes.put("jar", "application/zip");
        mimeTypes.put("java", "text/plain");
        mimeTypes.put("jnlp", "application/x-java-jnlp-file");
        mimeTypes.put("jpeg", "image/jpeg");
        mimeTypes.put("jpe", "image/jpeg");
        mimeTypes.put("jpg", "image/jpeg");
        mimeTypes.put("js", "text/x-javascript");
        mimeTypes.put("m3u", "audio/x-mpegurl");
        mimeTypes.put("maker", "application/x-maker");
        mimeTypes.put("mid", "audio/midi");
        mimeTypes.put("midi", "audio/midi");
        mimeTypes.put("mim", "application/mime");
        mimeTypes.put("mime", "application/mime");
        mimeTypes.put("mov", "video/quicktime");
        mimeTypes.put("mp2", "audio/mpeg");
        mimeTypes.put("mp3", "audio/mpeg");
        mimeTypes.put("mp4", "video/mpeg4");
        mimeTypes.put("mpa", "video/mpeg");
        mimeTypes.put("mpe", "video/mpeg");
        mimeTypes.put("mpeg", "video/mpeg");
        mimeTypes.put("mpg", "video/mpeg");
        mimeTypes.put("mpga", "audio/mpeg");
        mimeTypes.put("mpm", "video/mpeg");
        mimeTypes.put("mpv", "video/mpeg");
        mimeTypes.put("pdf", "application/pdf");
        mimeTypes.put("pic", "image/x-pict");
        mimeTypes.put("pict", "image/x-pict");
        mimeTypes.put("pct", "image/x-pict");
        mimeTypes.put("pl", "application/x-perl");
        mimeTypes.put("png", "image/png");
        mimeTypes.put("pnm", "image/x-portable-anymap");
        mimeTypes.put("pbm", "image/x-portable-bitmap");
        mimeTypes.put("ppm", "image/x-portable-pixmap");
        mimeTypes.put("ps", "application/postscript");
        mimeTypes.put("ppt", "application/vnd.ms-powerpoint");
        mimeTypes.put("qt", "video/quicktime");
        mimeTypes.put("ra", "application/vnd.rn-realaudio");
        mimeTypes.put("rar", "application/zip");
        mimeTypes.put("rf", "application/vnd.rn-realflash");
        mimeTypes.put("ra", "audio/vnd.rn-realaudio");
        mimeTypes.put("ram", "audio/x-pn-realaudio");
        mimeTypes.put("rm", "application/vnd.rn-realmedia");
        mimeTypes.put("rmm", "audio/x-pn-realaudio");
        mimeTypes.put("rsml", "application/vnd.rn-rsml");
        mimeTypes.put("rtf", "text/rtf");
        mimeTypes.put("rv", "video/vnd.rn-realvideo");
        mimeTypes.put("spl", "application/futuresplash");
        mimeTypes.put("snd", "audio/basic");
        mimeTypes.put("ssm", "application/smil");
        mimeTypes.put("swf", "application/x-shockwave-flash");
        mimeTypes.put("tar", "application/x-tar");
        mimeTypes.put("tgz", "application/x-gtar");
        mimeTypes.put("tif", "image/tiff");
        mimeTypes.put("tiff", "image/tiff");
        mimeTypes.put("txt", "text/plain");
        mimeTypes.put("ulw", "audio/basic");
        mimeTypes.put("war", "application/zip");
        mimeTypes.put("wav", "audio/x-wav");
        mimeTypes.put("wax", "application/x-ms-wax");
        mimeTypes.put("wm", "application/x-ms-wm");
        mimeTypes.put("wma", "application/x-ms-wma");
        mimeTypes.put("wml", "text/wml");
        mimeTypes.put("wmw", "application/x-ms-wmw");
        mimeTypes.put("wrd", "application/msword");
        mimeTypes.put("wvx", "application/x-ms-wvx");
        mimeTypes.put("xbm", "image/x-xbitmap");
        mimeTypes.put("xpm", "image/image/x-xpixmap");
        mimeTypes.put("xml", "text/xml");
        mimeTypes.put("xsl", "text/xml");
        mimeTypes.put("xls", "application/vnd.ms-excel");
        mimeTypes.put("zip", "application/zip");
        mimeTypes.put("z", "application/x-compress");
        mimeTypes.put("Z", "application/x-compress");
        _contentSources = new HashMap<String, ContentSource>();
    }

    public static class Context {
        private Servlet _servlet = null;
        private ServletConfig _servletConfig = null;
        private ServletRequest _request = null;
        private ServletResponse _response = null;
        private Map<String, Object> _att = new HashMap<String, Object>();

        public Object getAttribute(String name) {
            if (name == null) {
                return null;
            }
            Object value = this._att.get(name);
            if (value == null) {
                value = this.getServletRequest().getParameter(name);
            }
            return value;
        }

        public void setAttribute(String name, Object value) {
            if (name != null) {
                this._att.put(name, value);
            }
        }

        public void removeAttribute(String name) {
            this._att.remove(name);
        }

        public Servlet getServlet() {
            return this._servlet;
        }

        protected void setServlet(Servlet servlet) {
            this._servlet = servlet;
        }

        public ServletConfig getServletConfig() {
            return this._servletConfig;
        }

        protected void setServletConfig(ServletConfig config) {
            this._servletConfig = config;
        }

        public ServletRequest getServletRequest() {
            return this._request;
        }

        protected void setServletRequest(ServletRequest request) {
            this._request = request;
        }

        public ServletResponse getServletResponse() {
            return this._response;
        }

        protected void setServletResponse(ServletResponse response) {
            this._response = response;
        }
    }

    public static interface ContentSource {
        public String getId();

        public InputStream getInputStream(Context var1);

        public void cleanUp(Context var1);

        public long getLastModified(Context var1);
    }
}

