/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.stringsubs.StringSubstitutionException;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.StringsubsDefinition;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class StringSubstitutionParser {
    private static final Logger _logger = SLogger.getLogger();
    private static final LocalStringsImpl _strings = new LocalStringsImpl(StringSubstitutionParser.class);
    private static final String DEFAULT_SCHEMA = "xsd/schema/stringsubs.xsd";

    public static StringsubsDefinition parse(InputStream configStream) throws StringSubstitutionException {
        if (configStream == null) {
            throw new StringSubstitutionException(_strings.get("invalidStream"));
        }
        try {
            URL schemaUrl = StringSubstitutionParser.class.getClassLoader().getResource(DEFAULT_SCHEMA);
            JAXBContext context = JAXBContext.newInstance((String)StringsubsDefinition.class.getPackage().getName());
            Unmarshaller unmarshaller = context.createUnmarshaller();
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            schemaFactory.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "file");
            schemaFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Schema schema = schemaFactory.newSchema(schemaUrl);
            unmarshaller.setSchema(schema);
            InputSource is = new InputSource(configStream);
            SAXSource source = new SAXSource(is);
            Object obj = unmarshaller.unmarshal((Source)source);
            StringsubsDefinition stringsubsDefinition = obj instanceof JAXBElement ? (StringsubsDefinition)((JAXBElement)obj).getValue() : (StringsubsDefinition)obj;
            return stringsubsDefinition;
        }
        catch (SAXException se) {
            throw new StringSubstitutionException(_strings.get("failedToParse", new Object[]{DEFAULT_SCHEMA}), se);
        }
        catch (JAXBException jaxbe) {
            throw new StringSubstitutionException(_strings.get("failedToParse", new Object[]{DEFAULT_SCHEMA}), jaxbe);
        }
        finally {
            block11: {
                try {
                    configStream.close();
                }
                catch (IOException e) {
                    if (!_logger.isLoggable(Level.FINER)) break block11;
                    _logger.log(Level.FINER, _strings.get("errorInClosingStream"));
                }
            }
        }
    }
}

