/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.domain;

import com.sun.enterprise.admin.servermgmt.domain.DomainTemplate;
import com.sun.enterprise.admin.servermgmt.xml.domaininfo.DomainInfo;
import com.sun.enterprise.admin.servermgmt.xml.domaininfo.ObjectFactory;
import com.sun.enterprise.admin.servermgmt.xml.domaininfo.TemplateRef;
import com.sun.enterprise.admin.servermgmt.xml.templateinfo.TemplateInfo;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.logging.LogDomains;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;

public class DomainInfoManager {
    private static final Logger _logger = LogDomains.getLogger(DomainInfoManager.class, (String)"javax.enterprise.system.tools.admin");
    private static final LocalStringsImpl _strings = new LocalStringsImpl(DomainInfoManager.class);
    private static final String JAVA_HOME = "JAVA_HOME";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(DomainTemplate domainTemplate, File domainDir) {
        FileOutputStream outputStream = null;
        try {
            TemplateInfo templateInfo = domainTemplate.getInfo();
            File infoDir = new File(domainDir, "init-info");
            if (!infoDir.exists() && !infoDir.mkdirs()) {
                _logger.log(Level.INFO, _strings.get("directoryCreationError", new Object[]{infoDir.getAbsolutePath()}));
                return;
            }
            File domainInfoXML = new File(infoDir, "domain-info.xml");
            outputStream = new FileOutputStream(domainInfoXML);
            ObjectFactory objFactory = new ObjectFactory();
            DomainInfo domainInfo = objFactory.createDomainInfo();
            String javaHome = System.getenv(JAVA_HOME);
            if (javaHome == null || javaHome.isEmpty()) {
                javaHome = System.getProperty("java.home");
            }
            domainInfo.setJavahome(javaHome);
            domainInfo.setMwhome(System.getProperty("com.sun.aas.productRoot"));
            TemplateRef templateRef = new TemplateRef();
            templateRef.setName(templateInfo.getName());
            templateRef.setVersion(templateInfo.getVersion());
            templateRef.setLocation(domainTemplate.getLocation());
            domainInfo.setDomainTemplateRef(templateRef);
            JAXBContext context = JAXBContext.newInstance((String)ObjectFactory.class.getPackage().getName());
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(objFactory.createDomainInfo(domainInfo), (OutputStream)outputStream);
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, _strings.get("directoryCreationError", new Object[]{"domain-info.xml"}), e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception io) {}
            }
        }
    }
}

