/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="tail-service-log-files")
@Scoped(value=PerLookup.class)
public class TailServiceLogFile
extends CLICommand {
    private String commandName = "_hidden-tail-service-log-files";
    private String filepointer = "0";
    @Param(name="servicename", optional=true)
    private String serviceName;
    @Param(name="appname", optional=true)
    private String appName;
    @Param(name="n", optional=true, defaultValue="10")
    private String numberOfRecords;
    @Param(name="_pollIntervalInSeconds", optional=true, defaultValue="5")
    private String pollIntervalInSeconds;
    boolean validationSuccess = true;
    String origin;

    protected int executeCommand() throws CommandException {
        if (this.appName == null && this.serviceName == null) {
            this.validationSuccess = false;
            System.out.println("Missing application name or service name.");
        }
        if (this.appName != null && this.serviceName != null) {
            this.validationSuccess = false;
            System.out.println("Enter either application name or service name.");
        }
        if (this.validationSuccess) {
            Date date = new Date();
            long milliseconds = date.getTime();
            this.origin = String.valueOf(milliseconds);
            while (true) {
                RemoteCommand cmd = new RemoteCommand(this.commandName, this.programOpts, this.env);
                Map attr = cmd.executeAndReturnAttributes(this.getParams());
                String fileData = (String)attr.get("filedata_value");
                String filePointer = (String)attr.get("filePointer_value");
                String origin = (String)attr.get("origin_value");
                if (fileData != null && fileData.trim().length() > 0) {
                    System.out.println(fileData);
                }
                this.filepointer = filePointer;
                this.origin = origin;
                try {
                    Thread.currentThread();
                    Thread.sleep(Long.parseLong(this.pollIntervalInSeconds) * 1000L);
                }
                catch (InterruptedException e) {}
            }
        }
        return 0;
    }

    private String[] getParams() {
        ArrayList<String> ss = new ArrayList<String>();
        ss.add(this.commandName);
        ss.add("--filePointer");
        ss.add(this.filepointer);
        ss.add("--n");
        ss.add(this.numberOfRecords);
        if (this.serviceName != null) {
            ss.add("--serviceName");
            ss.add(this.serviceName);
        }
        if (this.appName != null) {
            ss.add("--appName");
            ss.add(this.appName);
        }
        if (this.origin != null) {
            ss.add("--origin");
            ss.add(this.origin);
        }
        return ss.toArray(new String[ss.size()]);
    }
}

