/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.admin.servermgmt.cli.StopDomainCommand;
import com.sun.enterprise.admin.servermgmt.cli.Strings;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.util.ArrayList;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;

@Service(name="restart-domain")
@Scoped(value=PerLookup.class)
public class RestartDomainCommand
extends StopDomainCommand {
    @Param(name="debug", optional=true)
    private Boolean debug;
    @Inject
    private Habitat habitat;
    private static final LocalStringsImpl strings = new LocalStringsImpl(RestartDomainCommand.class);

    protected void doCommand() throws CommandException {
        if (!this.isRestartable()) {
            throw new CommandException(Strings.get("restartDomain.notRestartable"));
        }
        long uptimeOldServer = this.getUptime();
        RemoteCommand cmd = new RemoteCommand("restart-domain", this.programOpts, this.env);
        File pwFile = this.getServerDirs().getLocalPasswordFile();
        long stamp = -1L;
        if (pwFile != null) {
            stamp = pwFile.lastModified();
        }
        if (this.debug != null) {
            cmd.executeAndReturnOutput(new String[]{"restart-domain", "--debug", this.debug.toString()});
        } else {
            cmd.executeAndReturnOutput(new String[]{"restart-domain"});
        }
        this.waitForRestart(pwFile, stamp, uptimeOldServer);
        logger.info(strings.get("restartDomain.success"));
    }

    protected int dasNotRunning(boolean local) throws CommandException {
        if (!local) {
            throw new CommandException(Strings.get("restart.dasNotRunningNoRestart"));
        }
        logger.warning(strings.get("restart.dasNotRunning"));
        CLICommand cmd = (CLICommand)this.habitat.getComponent(CLICommand.class, "start-domain");
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("start-domain");
        if (this.debug != null) {
            opts.add("--debug");
            opts.add(this.debug.toString());
        }
        if (this.domainDirParam != null) {
            opts.add("--domaindir");
            opts.add(this.domainDirParam);
        }
        if (this.getDomainName() != null) {
            opts.add(this.getDomainName());
        }
        return cmd.execute(opts.toArray(new String[opts.size()]));
    }
}

