/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.servermgmt.services.AppserverServiceType;
import com.sun.enterprise.admin.servermgmt.services.PlatformServicesInfo;
import com.sun.enterprise.admin.servermgmt.services.ServiceFactory;
import com.sun.enterprise.admin.util.ServerDirsSelector;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.io.ServerDirs;
import java.io.File;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="_delete-service")
@Scoped(value=PerLookup.class)
public final class DeleteServiceCommand
extends CLICommand {
    @Param(name="name", optional=true)
    private String serviceName;
    @Param(name="domaindir", optional=true)
    private File userSpecifiedDomainDirParent;
    @Param(name="domain_or_instance_name", primary=true, optional=true, alias="domain_name")
    private String userSpecifiedServerName;
    @Param(name="nodedir", optional=true, alias="agentdir")
    private String userSpecifiedNodeDir;
    @Param(name="node", optional=true, alias="nodeagent")
    private String userSpecifiedNode;
    private static final LocalStringsImpl strings = new LocalStringsImpl(DeleteServiceCommand.class);
    private ServerDirs dirs;
    private ServerDirsSelector selector = null;

    protected void validate() throws CommandException {
        try {
            super.validate();
            this.selector = ServerDirsSelector.getInstance((File)this.userSpecifiedDomainDirParent, (String)this.userSpecifiedServerName, (String)this.userSpecifiedNodeDir, (String)this.userSpecifiedNode);
            this.dirs = this.selector.dirs();
            this.validateServiceName();
        }
        catch (CommandException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CommandException(e.getMessage(), (Throwable)e);
        }
    }

    protected int executeCommand() throws CommandException {
        try {
            com.sun.enterprise.admin.servermgmt.services.Service service = ServiceFactory.getService(this.dirs, this.getType());
            PlatformServicesInfo info = service.getInfo();
            info.setTrace(logger.isLoggable(Level.FINER));
            if (DeleteServiceCommand.ok((String)this.serviceName)) {
                info.setServiceName(this.serviceName);
            }
            if (this.programOpts.getPasswordFile() != null) {
                info.setPasswordFile(SmartFile.sanitize((File)new File(this.programOpts.getPasswordFile())));
            }
            service.deleteService();
        }
        catch (Exception e) {
            String msg = e.getMessage();
            if (DeleteServiceCommand.ok((String)msg)) {
                throw new CommandException(msg);
            }
            throw new CommandException((Throwable)e);
        }
        return 0;
    }

    private void validateServiceName() throws CommandException {
        if (!DeleteServiceCommand.ok((String)this.serviceName)) {
            this.serviceName = this.dirs.getServerDir().getName();
        }
        if (OS.isWindowsForSure() && !FileUtils.isFriendlyFilename((String)this.serviceName)) {
            throw new CommandException(strings.get("create.service.badServiceName", new Object[]{this.serviceName}));
        }
        logger.finer("service name = " + this.serviceName);
    }

    private AppserverServiceType getType() {
        if (this.selector.isInstance()) {
            return AppserverServiceType.Instance;
        }
        return AppserverServiceType.Domain;
    }
}

