/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.LoginInfoStoreFactory;
import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.servermgmt.DomainConfig;
import com.sun.enterprise.admin.servermgmt.DomainException;
import com.sun.enterprise.admin.servermgmt.KeystoreManager;
import com.sun.enterprise.admin.servermgmt.pe.PEDomainsManager;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.net.NetUtils;
import com.sun.logging.LogDomains;
import java.beans.PropertyVetoException;
import java.io.Console;
import java.io.File;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Level;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.config.Container;
import org.glassfish.api.admin.config.DomainContext;
import org.glassfish.api.admin.config.DomainInitializer;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishException;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;
import org.glassfish.security.common.FileRealmHelper;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PerLookup;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigCode;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="create-domain")
@Scoped(value=PerLookup.class)
public final class CreateDomainCommand
extends CLICommand {
    private static final String ADMIN_PORT = "adminport";
    private static final String ADMIN_PASSWORD = "AS_ADMIN_PASSWORD";
    private static final String ADMIN_ADMINPASSWORD = "AS_ADMIN_ADMINPASSWORD";
    private static final String MASTER_PASSWORD = "AS_ADMIN_MASTERPASSWORD";
    private static final String DEFAULT_MASTER_PASSWORD = "changeit";
    private static final String SAVE_MASTER_PASSWORD = "savemasterpassword";
    private static final String INSTANCE_PORT = "instanceport";
    private static final String DOMAIN_PROPERTIES = "domainproperties";
    private static final String PORTBASE_OPTION = "portbase";
    private String adminUser = null;
    @Param(name="adminport", optional=true)
    private String adminPort;
    @Param(name="portbase", optional=true)
    private String portBase;
    @Param(obsolete=true, name="profile", optional=true)
    private String profile;
    @Param(name="template", optional=true)
    private String template;
    @Param(name="domaindir", optional=true)
    private String domainDir;
    @Param(name="instanceport", optional=true)
    private String instancePort;
    @Param(name="savemasterpassword", optional=true, defaultValue="false")
    private boolean saveMasterPassword = false;
    @Param(name="usemasterpassword", optional=true, defaultValue="false")
    private boolean useMasterPassword = false;
    @Param(name="domainproperties", optional=true, separator=58)
    private Properties domainProperties;
    @Param(name="keytooloptions", optional=true)
    private String keytoolOptions;
    @Param(name="savelogin", optional=true, defaultValue="false")
    private boolean saveLoginOpt = false;
    @Param(name="nopassword", optional=true, defaultValue="false")
    private boolean noPassword = false;
    private String adminPassword = null;
    private String masterPassword = null;
    @Param(name="checkports", optional=true, defaultValue="true")
    private boolean checkPorts = true;
    @Param(name="domain_name", primary=true)
    private String domainName;
    private CommandModelData.ParamModelData masterPasswordOption = new CommandModelData.ParamModelData("AS_ADMIN_MASTERPASSWORD", String.class, false, null);
    private CommandModelData.ParamModelData adminPasswordOption;
    private static final LocalStringsImpl strings = new LocalStringsImpl(CreateDomainCommand.class);

    public CreateDomainCommand() {
        this.masterPasswordOption.description = strings.get("MasterPassword");
        this.masterPasswordOption.param._password = true;
        this.adminPasswordOption = new CommandModelData.ParamModelData(ADMIN_PASSWORD, String.class, false, null);
        this.adminPasswordOption.description = strings.get("AdminPassword");
        this.adminPasswordOption.param._password = true;
    }

    protected Collection<CommandModel.ParamModel> usageOptions() {
        Collection opts = this.commandModel.getParameters();
        LinkedHashSet<CommandModel.ParamModel> uopts = new LinkedHashSet<CommandModel.ParamModel>();
        CommandModelData.ParamModelData aPort = new CommandModelData.ParamModelData(ADMIN_PORT, String.class, true, Integer.toString(4848));
        CommandModelData.ParamModelData iPort = new CommandModelData.ParamModelData(INSTANCE_PORT, String.class, true, Integer.toString(8080));
        for (CommandModel.ParamModel pm : opts) {
            if (pm.getName().equals(ADMIN_PORT)) {
                uopts.add((CommandModel.ParamModel)aPort);
                continue;
            }
            if (pm.getName().equals(INSTANCE_PORT)) {
                uopts.add((CommandModel.ParamModel)iPort);
                continue;
            }
            uopts.add(pm);
        }
        return uopts;
    }

    protected void validate() throws CommandException, CommandValidationException {
        if (this.domainDir == null) {
            this.domainDir = this.getSystemProperty("com.sun.aas.domainsRoot");
        }
        if (this.domainDir == null) {
            throw new CommandValidationException(strings.get("InvalidDomainPath", new Object[]{this.domainDir}));
        }
        if (this.programOpts.getUser() == null && !this.noPassword) {
            Console cons = System.console();
            if (cons != null && this.programOpts.isInteractive()) {
                cons.printf("%s", strings.get("AdminUserRequiredPrompt", new Object[]{"admin"}));
                String val = cons.readLine();
                if (CreateDomainCommand.ok((String)val)) {
                    this.programOpts.setUser(val);
                }
            } else {
                throw new CommandValidationException(strings.get("AdminUserRequired"));
            }
        }
        if (this.programOpts.getUser() != null) {
            try {
                FileRealmHelper.validateUserName((String)this.programOpts.getUser());
            }
            catch (IllegalArgumentException ise) {
                throw new CommandValidationException(strings.get("InvalidUserName", new Object[]{this.programOpts.getUser()}));
            }
        }
    }

    public void verifyPortBase() throws CommandValidationException {
        if (this.usePortBase()) {
            int portbase = this.convertPortStr(this.portBase);
            this.setOptionsWithPortBase(portbase);
        }
    }

    private void setOptionsWithPortBase(int portbase) throws CommandValidationException {
        this.verifyPortBasePortIsValid(ADMIN_PORT, portbase + 48);
        this.adminPort = String.valueOf(portbase + 48);
        this.verifyPortBasePortIsValid(INSTANCE_PORT, portbase + 80);
        this.instancePort = String.valueOf(portbase + 80);
        this.domainProperties = new Properties();
        this.verifyPortBasePortIsValid("http.ssl.port", portbase + 81);
        this.domainProperties.put("http.ssl.port", String.valueOf(portbase + 81));
        this.verifyPortBasePortIsValid("orb.ssl.port", portbase + 38);
        this.domainProperties.put("orb.ssl.port", String.valueOf(portbase + 38));
        this.verifyPortBasePortIsValid("orb.mutualauth.port", portbase + 39);
        this.domainProperties.put("orb.mutualauth.port", String.valueOf(portbase + 39));
        this.verifyPortBasePortIsValid("jms.port", portbase + 76);
        this.domainProperties.put("jms.port", String.valueOf(portbase + 76));
        this.verifyPortBasePortIsValid("orb.listener.port", portbase + 37);
        this.domainProperties.put("orb.listener.port", String.valueOf(portbase + 37));
        this.verifyPortBasePortIsValid("domain.jmxPort", portbase + 86);
        this.domainProperties.put("domain.jmxPort", String.valueOf(portbase + 86));
        this.verifyPortBasePortIsValid("osgi.shell.telnet.port", portbase + 66);
        this.domainProperties.put("osgi.shell.telnet.port", String.valueOf(portbase + 66));
        this.verifyPortBasePortIsValid("java.debugger.port", portbase + 9);
        this.domainProperties.put("java.debugger.port", String.valueOf(portbase + 9));
    }

    protected int executeCommand() throws CommandException, CommandValidationException {
        try {
            PEDomainsManager manager = new PEDomainsManager();
            DomainConfig config = new DomainConfig(this.domainName, this.domainDir);
            manager.validateDomain(config, false);
            this.verifyPortBase();
        }
        catch (DomainException e) {
            logger.fine(e.getLocalizedMessage());
            throw new CommandException(strings.get("CouldNotCreateDomain", new Object[]{this.domainName}), (Throwable)e);
        }
        this.adminUser = this.programOpts.getUser();
        if (!CreateDomainCommand.ok((String)this.adminUser)) {
            this.adminUser = "admin";
            this.adminPassword = "";
        } else if (this.noPassword) {
            this.adminPassword = "";
        } else {
            boolean haveAdminPwd = false;
            this.adminPassword = (String)this.passwords.get(ADMIN_ADMINPASSWORD);
            if (this.adminPassword != null) {
                haveAdminPwd = true;
                logger.warning(strings.get("DeprecatedAdminPassword"));
            } else {
                haveAdminPwd = this.passwords.get(ADMIN_PASSWORD) != null;
                this.adminPassword = this.getAdminPassword();
            }
            this.validatePassword(this.adminPassword, (CommandModel.ParamModel)this.adminPasswordOption);
        }
        if (this.saveMasterPassword) {
            this.useMasterPassword = true;
        }
        if (this.useMasterPassword) {
            this.masterPassword = this.getMasterPassword();
        }
        if (this.masterPassword == null) {
            this.masterPassword = DEFAULT_MASTER_PASSWORD;
        }
        this.validatePassword(this.masterPassword, (CommandModel.ParamModel)this.masterPasswordOption);
        try {
            if (this.adminPort != null) {
                this.verifyPortIsValid(this.adminPort);
            }
            if (this.instancePort != null) {
                this.verifyPortIsValid(this.instancePort);
            }
            this.createTheDomain(this.domainDir, this.domainProperties);
        }
        catch (CommandException ce) {
            logger.info(ce.getLocalizedMessage());
            throw new CommandException(strings.get("CouldNotCreateDomain", new Object[]{this.domainName}), (Throwable)ce);
        }
        catch (Exception e) {
            logger.fine(e.getLocalizedMessage());
            throw new CommandException(strings.get("CouldNotCreateDomain", new Object[]{this.domainName}), (Throwable)e);
        }
        return 0;
    }

    private void verifyPortIsValid(String portNum) throws CommandException, CommandValidationException {
        int portToVerify = this.convertPortStr(portNum);
        if (!NetUtils.isPortValid((int)portToVerify)) {
            throw new CommandException(strings.get("InvalidPortRange", new Object[]{portNum}));
        }
        if (!this.checkPorts) {
            logger.log(Level.FINER, "Port ={0}", portToVerify);
            return;
        }
        NetUtils.PortAvailability avail = NetUtils.checkPort((int)portToVerify);
        switch (avail) {
            case illegalNumber: {
                throw new CommandException(strings.get("InvalidPortRange", new Object[]{portNum}));
            }
            case inUse: {
                throw new CommandException(strings.get("PortInUseError", new Object[]{this.domainName, portNum}));
            }
            case noPermission: {
                throw new CommandException(strings.get("NoPermissionForPortError", new Object[]{portNum, this.domainName}));
            }
            case unknown: {
                throw new CommandException(strings.get("UnknownPortMsg", new Object[]{portNum}));
            }
            case OK: {
                logger.log(Level.FINER, "Port ={0}", portToVerify);
                break;
            }
        }
    }

    private int convertPortStr(String port) throws CommandValidationException {
        try {
            return Integer.parseInt(port);
        }
        catch (Exception e) {
            throw new CommandValidationException(strings.get("InvalidPortNumber", new Object[]{port}));
        }
    }

    private void verifyPortBasePortIsValid(String portName, int portNum) throws CommandValidationException {
        if (portNum <= 0 || portNum > 65535) {
            throw new CommandValidationException(strings.get("InvalidPortBaseRange", new Object[]{portNum, portName}));
        }
        if (this.checkPorts && !NetUtils.isPortFree((int)portNum)) {
            throw new CommandValidationException(strings.get("PortBasePortInUse", new Object[]{portNum, portName}));
        }
        logger.finer("Port =" + portNum);
    }

    private void createTheDomain(String domainPath, Properties domainProperties) throws DomainException, CommandValidationException {
        String domainFilePath = domainPath + File.separator + this.domainName;
        if (FileUtils.safeGetCanonicalFile((File)new File(domainFilePath)).exists()) {
            throw new CommandValidationException(strings.get("DomainExists", new Object[]{this.domainName}));
        }
        Integer adminPortInt = this.getPort(domainProperties, "domain.adminPort", this.adminPort, Integer.toString(4848), "Admin");
        Integer instancePortInt = this.getPort(domainProperties, "domain.instancePort", this.instancePort, Integer.toString(8080), "HTTP Instance");
        Integer jmsPort = this.getPort(domainProperties, "jms.port", null, Integer.toString(7676), "JMS");
        Integer orbPort = this.getPort(domainProperties, "orb.listener.port", null, Integer.toString(3700), "IIOP");
        Integer httpSSLPort = this.getPort(domainProperties, "http.ssl.port", null, Integer.toString(8181), "HTTP_SSL");
        Integer iiopSSLPort = this.getPort(domainProperties, "orb.ssl.port", null, Integer.toString(3820), "IIOP_SSL");
        Integer iiopMutualAuthPort = this.getPort(domainProperties, "orb.mutualauth.port", null, Integer.toString(3920), "IIOP_MUTUALAUTH");
        Integer jmxPort = this.getPort(domainProperties, "domain.jmxPort", null, Integer.toString(8686), "JMX_ADMIN");
        Integer osgiShellTelnetPort = this.getPort(domainProperties, "osgi.shell.telnet.port", null, Integer.toString(6666), "OSGI_SHELL");
        Integer javaDebuggerPort = this.getPort(domainProperties, "java.debugger.port", null, Integer.toString(9009), "JAVA_DEBUGGER");
        this.checkPortPrivilege(new Integer[]{adminPortInt, instancePortInt, jmsPort, orbPort, httpSSLPort, jmsPort, orbPort, httpSSLPort, iiopSSLPort, iiopMutualAuthPort, jmxPort, osgiShellTelnetPort, javaDebuggerPort});
        DomainConfig domainConfig = new DomainConfig(this.domainName, adminPortInt, domainPath, this.adminUser, this.adminPassword, this.masterPassword, this.saveMasterPassword, instancePortInt, jmsPort, orbPort, httpSSLPort, iiopSSLPort, iiopMutualAuthPort, jmxPort, osgiShellTelnetPort, javaDebuggerPort, domainProperties);
        if (this.template != null) {
            domainConfig.put("template.name", this.template);
        }
        domainConfig.put("domain.validatePorts", this.checkPorts);
        domainConfig.put("keytooloptions", this.keytoolOptions);
        this.initSecureAdminSettings(domainConfig);
        PEDomainsManager manager = new PEDomainsManager();
        manager.createDomain(domainConfig);
        try {
            this.modifyInitialDomainXml(domainConfig);
        }
        catch (Exception e) {
            logger.warning(strings.get("CustomizationFailed", new Object[]{e.getMessage()}));
        }
        logger.info(strings.get("DomainCreated", new Object[]{this.domainName}));
        logger.info(strings.get("DomainPort", new Object[]{this.domainName, adminPortInt.toString()}));
        if (this.adminPassword.equals("")) {
            logger.info(strings.get("DomainAllowsUnauth", new Object[]{this.domainName, this.adminUser}));
        } else {
            logger.info(strings.get("DomainAdminUser", new Object[]{this.domainName, this.adminUser}));
        }
        if (this.saveLoginOpt) {
            this.saveLogin(adminPortInt, this.adminUser, this.adminPassword, this.domainName);
        }
    }

    private void saveLogin(int port, String user, String password, String dn) {
        try {
            LoginInfoStore store = LoginInfoStoreFactory.getStore(null);
            LoginInfo login = new LoginInfo("localhost", port, user, password);
            if (store.exists(login.getHost(), login.getPort())) {
                logger.info(strings.get("OverwriteLoginMsgCreateDomain", new Object[]{login.getHost(), "" + login.getPort()}));
            }
            store.store(login, true);
            logger.info(strings.get("LoginInfoStoredCreateDomain", new Object[]{user, dn, store.getName()}));
        }
        catch (Exception e) {
            logger.warning(strings.get("LoginInfoNotStoredCreateDomain", new Object[]{user, dn}));
            this.printExceptionStackTrace(e);
        }
    }

    private Integer getPort(Properties properties, String key, String portStr, String defaultPort, String name) throws CommandValidationException {
        int port = 0;
        boolean portNotSpecified = false;
        boolean invalidPortSpecified = false;
        boolean defaultPortUsed = false;
        if (portStr != null && !portStr.equals("")) {
            port = this.convertPortStr(portStr);
            if (port <= 0 || port > 65535) {
                invalidPortSpecified = true;
            }
        } else if (properties != null) {
            String property = properties.getProperty(key);
            if (property != null && !property.equals("")) {
                port = this.convertPortStr(property);
            } else {
                portNotSpecified = true;
            }
        } else {
            portNotSpecified = true;
        }
        if (portNotSpecified) {
            port = this.convertPortStr(defaultPort);
            defaultPortUsed = true;
        }
        if (this.checkPorts && !NetUtils.isPortFree((int)port)) {
            int newport = NetUtils.getFreePort();
            if (portNotSpecified) {
                if (defaultPortUsed) {
                    logger.fine(strings.get("DefaultPortInUse", new Object[]{name, defaultPort, Integer.toString(newport)}));
                } else {
                    logger.fine(strings.get("PortNotSpecified", new Object[]{name, Integer.toString(newport)}));
                }
            } else if (invalidPortSpecified) {
                logger.fine(strings.get("InvalidPortRangeMsg", new Object[]{name, Integer.toString(newport)}));
            } else {
                logger.fine(strings.get("PortInUse", new Object[]{name, Integer.toString(port), Integer.toString(newport)}));
            }
            port = newport;
        } else if (defaultPortUsed) {
            logger.fine(strings.get("UsingDefaultPort", new Object[]{name, Integer.toString(port)}));
        } else {
            logger.fine(strings.get("UsingPort", new Object[]{name, Integer.toString(port)}));
        }
        if (properties != null) {
            properties.remove(key);
        }
        return port;
    }

    private boolean usePortBase() throws CommandValidationException {
        if (this.portBase != null) {
            if (this.adminPort != null) {
                throw new CommandValidationException(strings.get("MutuallyExclusiveOption", new Object[]{ADMIN_PORT, PORTBASE_OPTION}));
            }
            if (this.instancePort != null) {
                throw new CommandValidationException(strings.get("MutuallyExclusiveOption", new Object[]{INSTANCE_PORT, PORTBASE_OPTION}));
            }
            if (this.domainProperties != null) {
                throw new CommandValidationException(strings.get("MutuallyExclusiveOption", new Object[]{DOMAIN_PROPERTIES, PORTBASE_OPTION}));
            }
            return true;
        }
        return false;
    }

    private void checkPortPrivilege(Integer[] ports) {
        for (Integer port : ports) {
            int p = port;
            if (p >= 1024) continue;
            logger.warning(strings.get("PortPrivilege"));
            break;
        }
    }

    public void validatePassword(String password, CommandModel.ParamModel pwdOpt) throws CommandValidationException {
        String description = pwdOpt.getParam().defaultValue();
        if (!CreateDomainCommand.ok((String)description)) {
            description = pwdOpt.getName();
        }
        if (password == null) {
            throw new CommandValidationException(strings.get("PasswordMissing", new Object[]{description}));
        }
    }

    protected String getAdminPassword() throws CommandValidationException {
        return this.getPassword((CommandModel.ParamModel)this.adminPasswordOption, "", true);
    }

    private String getMasterPassword() throws CommandValidationException, CommandException {
        return this.getPassword((CommandModel.ParamModel)this.masterPasswordOption, DEFAULT_MASTER_PASSWORD, true);
    }

    private void modifyInitialDomainXml(DomainConfig domainConfig) throws GlassFishException {
        BootstrapProperties bootstrapProperties = new BootstrapProperties();
        bootstrapProperties.setInstallRoot(domainConfig.getInstallRoot());
        GlassFishRuntime runtime = GlassFishRuntime.bootstrap((BootstrapProperties)bootstrapProperties);
        File domDir = new File(domainConfig.getDomainRoot(), domainConfig.getDomainName());
        File configDir = new File(domDir, "config");
        GlassFishProperties glassFishProperties = new GlassFishProperties();
        glassFishProperties.setConfigFileURI(new File(configDir, "domain.xml").toURI().toString());
        glassFishProperties.setConfigFileReadOnly(false);
        glassFishProperties.setProperty("hk2.startup.context.moduleStartup", "DomainCreation");
        glassFishProperties.setProperty("com.sun.aas.instanceRoot", domDir.getAbsolutePath());
        glassFishProperties.setProperty("-domain", domainConfig.getDomainName());
        GlassFish glassfish = runtime.newGlassFish(glassFishProperties);
        glassfish.start();
        Server serverConfig = (Server)glassfish.getService(Server.class, "server");
        Config config = (Config)glassfish.getService(Config.class, serverConfig.getConfigRef());
        DomainContext ctx = new DomainContext();
        ctx.setDomainType("dev");
        ctx.setLogger(LogDomains.getLogger(DomainInitializer.class, (String)"javax.enterprise.system"));
        Habitat habitat = (Habitat)glassfish.getService(Habitat.class);
        Collection inits = habitat.getAllByContract(DomainInitializer.class);
        if (inits.isEmpty()) {
            logger.info(strings.get("NoCustomization"));
        }
        for (DomainInitializer inhabitant : habitat.getAllByContract(DomainInitializer.class)) {
            logger.info(strings.get("InvokeInitializer", new Object[]{inhabitant.getClass()}));
            Container newContainerConfig = inhabitant.getInitialConfig(ctx);
            try {
                ConfigSupport.apply((ConfigCode)new ConfigCode(){

                    public Object run(ConfigBeanProxy ... objects) throws PropertyVetoException, TransactionFailure {
                        ((Config)objects[0]).getContainers().add((Container)objects[1]);
                        return Boolean.TRUE;
                    }
                }, (ConfigBeanProxy[])new ConfigBeanProxy[]{config, newContainerConfig});
            }
            catch (TransactionFailure e) {
                logger.severe(strings.get("InitializerTransactionFailure", new Object[]{inhabitant.getClass()}));
            }
        }
        glassfish.dispose();
    }

    private void initSecureAdminSettings(DomainConfig config) {
        config.put("domain.admin.cert.dn", KeystoreManager.getDASCertDN(config));
        config.put("domain.instance.cert.dn", KeystoreManager.getInstanceCertDN(config));
        config.put("domain.indicator", this.secureAdminIdentifier());
    }

    private String secureAdminIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString();
    }
}

