/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.utils;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.security.ssl.SSLUtils;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.admin.rest.client.utils.MarshallingUtils;
import org.glassfish.admin.rest.utils.Proxy;
import org.glassfish.hk2.api.ServiceLocator;

public abstract class ProxyImpl
implements Proxy {
    @Override
    public Properties proxyRequest(UriInfo sourceUriInfo, Client client, ServiceLocator habitat) {
        Properties proxiedResponse;
        block10: {
            proxiedResponse = new Properties();
            try {
                Domain domain = (Domain)habitat.getService(Domain.class, new Annotation[0]);
                String forwardInstanceName = this.extractTargetInstanceName(sourceUriInfo);
                Server forwardInstance = domain.getServerNamed(forwardInstanceName);
                if (forwardInstance == null) break block10;
                UriBuilder forwardUriBuilder = this.constructForwardURLPath(sourceUriInfo);
                URI forwardURI = forwardUriBuilder.scheme("https").host(forwardInstance.getAdminHost()).port(forwardInstance.getAdminPort()).build(new Object[0]);
                client = this.addAuthenticationInfo(client, forwardInstance, habitat);
                WebTarget resourceBuilder = client.target(forwardURI);
                Response response = (Response)resourceBuilder.request(new String[]{"application/json"}).get(Response.class);
                Response.Status status = Response.Status.fromStatusCode((int)response.getStatus());
                if (status.getFamily() == Response.Status.Family.SUCCESSFUL) {
                    Object properties;
                    Object message;
                    String jsonDoc = (String)response.readEntity(String.class);
                    Map responseMap = MarshallingUtils.buildMapFromDocument((String)jsonDoc);
                    Map resultExtraProperties = (Map)responseMap.get("extraProperties");
                    if (resultExtraProperties != null) {
                        Object entity = resultExtraProperties.get("entity");
                        if (entity != null) {
                            proxiedResponse.put("entity", entity);
                        }
                        Map childResources = (Map)resultExtraProperties.get("childResources");
                        for (Map.Entry entry : childResources.entrySet()) {
                            String targetURL = null;
                            try {
                                URL originalURL = new URL((String)entry.getValue());
                                targetURL = this.constructTargetURLPath(sourceUriInfo, originalURL).build(new Object[0]).toASCIIString();
                            }
                            catch (MalformedURLException malformedURLException) {
                                // empty catch block
                            }
                            entry.setValue(targetURL);
                        }
                        proxiedResponse.put("childResources", childResources);
                    }
                    if ((message = responseMap.get("message")) != null) {
                        proxiedResponse.put("message", message);
                    }
                    if ((properties = responseMap.get("properties")) != null) {
                        proxiedResponse.put("properties", properties);
                    }
                    break block10;
                }
                throw new WebApplicationException((String)response.readEntity(String.class), status);
            }
            catch (Exception ex) {
                throw new WebApplicationException((Throwable)ex, Response.Status.INTERNAL_SERVER_ERROR);
            }
        }
        return proxiedResponse;
    }

    private Client addAuthenticationInfo(Client client, Server server, ServiceLocator habitat) {
        SecureAdmin secureAdmin = (SecureAdmin)habitat.getService(SecureAdmin.class, new Annotation[0]);
        SSLContext sslContext = ((SSLUtils)habitat.getService(SSLUtils.class, new Annotation[0])).getAdminSSLContext(SecureAdmin.Util.DASAlias((SecureAdmin)secureAdmin), "TLS");
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().withConfig(client.getConfiguration()).hostnameVerifier((HostnameVerifier)new BasicHostnameVerifier(server.getAdminHost())).sslContext(sslContext);
        return clientBuilder.build();
    }

    private static class BasicHostnameVerifier
    implements HostnameVerifier {
        private final String host;

        public BasicHostnameVerifier(String host) {
            if (host == null) {
                throw new IllegalArgumentException("null host");
            }
            this.host = host;
        }

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return this.host.equals(s);
        }
    }
}

