/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.adapter;

import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.module.common_impl.LogHelper;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.enterprise.v3.admin.adapter.AdminEndpointDecider;
import com.sun.grizzly.tcp.Adapter;
import com.sun.grizzly.tcp.http11.GrizzlyAdapter;
import com.sun.grizzly.tcp.http11.GrizzlyRequest;
import com.sun.grizzly.tcp.http11.GrizzlyResponse;
import com.sun.grizzly.util.http.Cookie;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.net.InetAddress;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.login.LoginException;
import org.glassfish.admin.rest.LazyJerseyInterface;
import org.glassfish.admin.rest.ResourceUtil;
import org.glassfish.admin.rest.RestService;
import org.glassfish.admin.rest.SessionManager;
import org.glassfish.api.admin.ServerEnvironment;
import org.glassfish.api.container.EndpointRegistrationException;
import org.glassfish.api.event.Events;
import org.glassfish.internal.api.AdminAccessController;
import org.glassfish.internal.api.PostStartup;
import org.glassfish.internal.api.ServerContext;
import org.jvnet.hk2.annotations.Inject;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.PostConstruct;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RestAdapter
extends GrizzlyAdapter
implements org.glassfish.api.container.Adapter,
PostStartup,
PostConstruct {
    public static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(RestService.class);
    @Inject
    protected volatile AdminService as = null;
    @Inject
    protected Events events;
    @Inject
    protected Habitat habitat;
    @Inject(name="default-instance-name")
    protected Config config;
    protected CountDownLatch latch = new CountDownLatch(1);
    @Inject
    protected ServerContext sc;
    @Inject
    protected ServerEnvironment serverEnvironment;
    @Inject
    protected SessionManager sessionManager;
    private static final Logger logger = LogDomains.getLogger(RestAdapter.class, (String)"javax.enterprise.system.tools.admin");
    private volatile LazyJerseyInterface lazyJerseyInterface = null;
    private FutureTask<Boolean> exposeContextFuture;
    private volatile Adapter adapter = null;
    private boolean isRegistered = false;
    private AdminEndpointDecider epd = null;

    protected RestAdapter() {
        this.setAllowEncodedSlash(true);
    }

    public void postConstruct() {
        this.epd = new AdminEndpointDecider(this.config, logger);
        this.latch.countDown();
    }

    public void service(GrizzlyRequest req, GrizzlyResponse res) {
        LogHelper.getDefaultLogger().log(Level.FINER, "Received resource request: {0}", req.getRequestURI());
        try {
            res.setCharacterEncoding("UTF-8");
            if (!this.latch.await(20L, TimeUnit.SECONDS)) {
                String msg = localStrings.getLocalString("rest.adapter.server.wait", "Server cannot process this command at this time, please wait");
                this.reportError(req, res, 503, msg);
                return;
            }
            if (this.serverEnvironment.isInstance() && !"GET".equalsIgnoreCase(req.getRequest().method().getString())) {
                String msg = localStrings.getLocalString("rest.resource.only.GET.on.instance", "Only GET requests are allowed on an instance that is not DAS.");
                this.reportError(req, res, 403, msg);
                return;
            }
            AdminAccessController.Access access = this.authenticate(req);
            if (access == AdminAccessController.Access.FULL) {
                this.exposeContext();
                ((GrizzlyAdapter)this.adapter).service(req, res);
            } else {
                String msg;
                int status;
                if (access == AdminAccessController.Access.NONE) {
                    status = 401;
                    msg = localStrings.getLocalString("rest.adapter.auth.userpassword", "Invalid user name or password");
                    res.setHeader("WWW-Authenticate", "BASIC");
                } else {
                    assert (access == AdminAccessController.Access.FORBIDDEN);
                    status = 403;
                    msg = localStrings.getLocalString("rest.adapter.auth.forbidden", "Remote access not allowed. If you desire remote access, please turn on secure admin");
                }
                this.reportError(req, res, status, msg);
            }
        }
        catch (InterruptedException e) {
            String msg = localStrings.getLocalString("rest.adapter.server.wait", "Server cannot process this command at this time, please wait");
            this.reportError(req, res, 503, msg);
            return;
        }
        catch (IOException e) {
            String msg = localStrings.getLocalString("rest.adapter.server.ioexception", "REST: IO Exception " + e.getLocalizedMessage());
            this.reportError(req, res, 503, msg);
            return;
        }
        catch (LoginException e) {
            String msg = localStrings.getLocalString("rest.adapter.auth.error", "Error authenticating");
            this.reportError(req, res, 401, msg);
            return;
        }
        catch (Exception e) {
            String msg = localStrings.getLocalString("rest.adapter.server.exception", "An error occurred while processing the request. Please see the server logs for details.");
            this.reportError(req, res, 503, msg);
            return;
        }
    }

    private AdminAccessController.Access authenticate(GrizzlyRequest req) throws LoginException, IOException {
        AdminAccessController.Access access = AdminAccessController.Access.FULL;
        boolean authenticated = this.authenticateViaLocalPassword(req);
        if (!authenticated && !(authenticated = this.authenticateViaRestToken(req))) {
            access = ResourceUtil.authenticateViaAdminRealm(this.habitat, req);
        }
        return access;
    }

    private boolean authenticateViaRestToken(GrizzlyRequest req) {
        boolean authenticated = false;
        Cookie[] cookies = req.getCookies();
        String restToken = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!"gfresttoken".equals(cookie.getName())) continue;
                restToken = cookie.getValue();
            }
        }
        if (restToken == null) {
            restToken = req.getHeader("X-Auth-Token");
        }
        if (restToken != null) {
            authenticated = this.sessionManager.authenticate(restToken, req);
        }
        return authenticated;
    }

    private boolean authenticateViaLocalPassword(GrizzlyRequest req) {
        Cookie[] cookies = req.getCookies();
        boolean authenticated = false;
        String uid = RestService.getRestUID();
        if (uid != null && cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals("gfrestuid") || !cookie.getValue().equals(uid)) continue;
                authenticated = true;
                break;
            }
        }
        return authenticated;
    }

    public void afterService(GrizzlyRequest req, GrizzlyResponse res) throws Exception {
    }

    public void fireAdapterEvent(String type, Object data) {
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    public int getListenPort() {
        return this.epd.getListenPort();
    }

    public InetAddress getListenAddress() {
        return this.epd.getListenAddress();
    }

    public List<String> getVirtualServers() {
        return this.epd.getAsadminHosts();
    }

    protected abstract Set<Class<?>> getResourcesConfig();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected LazyJerseyInterface getLazyJersey() {
        if (this.lazyJerseyInterface != null) {
            return this.lazyJerseyInterface;
        }
        Class<Adapter> clazz = Adapter.class;
        synchronized (Adapter.class) {
            if (this.lazyJerseyInterface == null) {
                try {
                    Class<?> lazyInitClass = Class.forName("org.glassfish.admin.rest.LazyJerseyInit");
                    this.lazyJerseyInterface = (LazyJerseyInterface)lazyInitClass.newInstance();
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "Error trying to call org.glassfish.admin.rest.LazyJerseyInit via instrospection: ", ex);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.lazyJerseyInterface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void exposeContext() throws EndpointRegistrationException {
        if (this.adapter != null) return;
        Class<Adapter> clazz = Adapter.class;
        synchronized (Adapter.class) {
            if (this.adapter != null) return;
            String context = this.getContextRoot();
            logger.log(Level.FINE, "Exposing rest resource context root: {0}", context);
            if (context == null && "".equals(context)) return;
            Set<Class<?>> classes = this.getResourcesConfig();
            this.adapter = this.getLazyJersey().exposeContext(classes, this.sc, this.habitat);
            ((GrizzlyAdapter)this.adapter).setResourcesContextPath(context);
            logger.log(Level.INFO, "rest.rest_interface_initialized", context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void reportError(GrizzlyRequest req, GrizzlyResponse res, int statusCode, String msg) {
        this.getLazyJersey().reportError(req, res, statusCode, msg);
    }
}

