/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.client;

import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.client.filter.CsrfProtectionFilter;
import org.glassfish.jersey.client.filter.HttpBasicAuthFilter;
import org.glassfish.jersey.jettison.JettisonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;

public class ClientWrapper
implements Client {
    protected Client realClient = JerseyClientBuilder.newClient();

    public ClientWrapper() {
        this(new HashMap<String, String>());
    }

    public ClientWrapper(Map<String, String> headers) {
        this(headers, null, null);
    }

    public ClientWrapper(final Map<String, String> headers, String userName, String password) {
        this.realClient.register((Object)new MultiPartFeature());
        this.realClient.register((Object)new JettisonFeature());
        this.realClient.register((Object)new CsrfProtectionFilter());
        if (userName != null && password != null) {
            this.realClient.register((Object)new HttpBasicAuthFilter(userName, password));
        }
        this.realClient.register((Object)new ClientRequestFilter(){

            public void filter(ClientRequestContext rc) throws IOException {
                for (Map.Entry entry : headers.entrySet()) {
                    rc.getHeaders().add(entry.getKey(), entry.getValue());
                }
            }
        });
    }

    public void close() {
        this.realClient.close();
    }

    public WebTarget target(String uri) throws IllegalArgumentException, NullPointerException {
        return this.realClient.target(uri);
    }

    public WebTarget target(URI uri) throws NullPointerException {
        return this.realClient.target(uri);
    }

    public WebTarget target(UriBuilder uriBuilder) throws NullPointerException {
        return this.realClient.target(uriBuilder);
    }

    public WebTarget target(Link link) throws NullPointerException {
        return this.realClient.target(link);
    }

    public Invocation.Builder invocation(Link link) throws NullPointerException {
        return this.realClient.invocation(link);
    }

    public Configuration getConfiguration() {
        return this.realClient.getConfiguration();
    }

    public Client property(String name, Object value) {
        this.realClient.property(name, value);
        return this;
    }

    public Client register(Class<?> componentClass) {
        this.realClient.register(componentClass);
        return this;
    }

    public Client register(Class<?> componentClass, int bindingPriority) {
        this.realClient.register(componentClass, bindingPriority);
        return this;
    }

    public Client register(Class<?> componentClass, Class<?> ... contracts) {
        this.realClient.register(componentClass, (Class[])contracts);
        return this;
    }

    public Client register(Class<?> componentClass, Map<Class<?>, Integer> contracts) {
        this.realClient.register(componentClass, contracts);
        return this;
    }

    public Client register(Object component) {
        this.realClient.register(component);
        return this;
    }

    public Client register(Object component, int bindingPriority) {
        this.realClient.register(component, bindingPriority);
        return this;
    }

    public Client register(Object component, Class<?> ... contracts) {
        this.realClient.register(component, (Class[])contracts);
        return this;
    }

    public Client register(Object component, Map<Class<?>, Integer> contracts) {
        this.realClient.register(component, contracts);
        return this;
    }

    public SSLContext getSslContext() {
        return this.realClient.getSslContext();
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.realClient.getHostnameVerifier();
    }
}

