/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.CommandLine;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.GFLauncherLogger;
import com.sun.enterprise.admin.launcher.GFLauncherNativeHelper;
import com.sun.enterprise.admin.launcher.JavaConfig;
import com.sun.enterprise.admin.launcher.JvmOptions;
import com.sun.enterprise.admin.launcher.Profiler;
import com.sun.enterprise.universal.collections.CollectionUtils;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.glassfish.GFLauncherUtils;
import com.sun.enterprise.universal.glassfish.TokenResolver;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.io.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class GFLauncher {
    private static final LocalStringsImpl I18N = new LocalStringsImpl(GFLauncher.class);
    private static final System.Logger LOG = System.getLogger(GFLauncher.class.getName(), I18N.getBundle());
    private static final LocalStringsImpl strings = new LocalStringsImpl(GFLauncher.class);
    private final GFLauncherInfo callerParameters;
    private Map<String, String> asenvProps;
    private JavaConfig domainXMLjavaConfig;
    private List<String> domainXMLjavaConfigDebugOptions;
    private int debugPort = -1;
    private boolean debugSuspend;
    private JvmOptions domainXMLjvmOptions;
    private final List<String> domainXMLJvmOptionsAsList = new ArrayList<String>();
    private Profiler domainXMLJavaConfigProfiler;
    private Map<String, String> domainXMLSystemProperty;
    private Path javaExe;
    private File[] classpath;
    private String adminFileRealmKeyFile;
    private boolean secureAdminEnabled;
    private String logFilename;
    private boolean logFilenameWasFixed;
    private boolean setupCalledByClients;
    private boolean needsAutoUpgrade;
    private boolean needsManualUpgrade;
    private LaunchType mode = LaunchType.normal;
    private CommandLine commandLine;
    private long startTime;
    private Process glassFishProcess;
    private ProcessStreamDrainer processStreamDrainer;
    private int exitValue = -1;

    GFLauncher(GFLauncherInfo info) {
        this.callerParameters = info;
    }

    public final void launch() throws GFLauncherException {
        if (this.isDebugSuspend()) {
            LOG.log(System.Logger.Level.INFO, "ServerStart.DebuggerSuspendedMessage", this.debugPort);
        } else if (this.debugPort >= 0) {
            LOG.log(System.Logger.Level.INFO, "ServerStart.DebuggerMessage", this.debugPort);
        }
        try {
            this.startTime = System.currentTimeMillis();
            if (!this.setupCalledByClients) {
                this.setup();
            }
            this.internalLaunch();
        }
        catch (GFLauncherException gfe) {
            throw gfe;
        }
        catch (Exception t) {
            throw new GFLauncherException(strings.get("unknownError", new Object[]{t.getMessage()}), t);
        }
        finally {
            GFLauncherLogger.removeLogFileHandler();
        }
    }

    public final void relaunch() throws GFLauncherException {
        this.setupCalledByClients = false;
        this.launch();
    }

    public void setup() throws GFLauncherException, MiniXmlParserException {
        this.asenvProps = this.getAsEnvConfReader().getProps();
        this.callerParameters.setup();
        this.setupLogLevels();
        MiniXmlParser domainXML = new MiniXmlParser(this.getInfo().getConfigFile(), this.getInfo().getInstanceName());
        String domainName = domainXML.getDomainName();
        if (GFLauncherUtils.ok((String)domainName)) {
            this.callerParameters.setDomainName(domainName);
        }
        this.callerParameters.setAdminAddresses(domainXML.getAdminAddresses());
        this.domainXMLjavaConfig = new JavaConfig(domainXML.getJavaConfig());
        this.setupProfilerAndJvmOptions(domainXML);
        this.setupUpgradeSecurity();
        Map realmprops = domainXML.getAdminRealmProperties();
        if (realmprops != null) {
            String classname = (String)realmprops.get("classname");
            String keyfile = (String)realmprops.get("file");
            if ("com.sun.enterprise.security.auth.realm.file.FileRealm".equals(classname) && keyfile != null) {
                this.adminFileRealmKeyFile = keyfile;
            }
        }
        this.secureAdminEnabled = domainXML.getSecureAdminEnabled();
        this.renameOsgiCache();
        this.setupMonitoring(domainXML);
        this.domainXMLSystemProperty = domainXML.getSystemProperties();
        this.asenvProps.put("com.sun.aas.instanceRoot", this.getInfo().getInstanceRootDir().getPath());
        String javaHome = this.domainXMLjavaConfig.getJavaHome();
        if (GFLauncherUtils.ok((String)javaHome) && !javaHome.trim().equals("${com.sun.aas.javaRoot}")) {
            this.asenvProps.put("com.sun.aas.javaRoot", javaHome);
        }
        this.domainXMLjavaConfigDebugOptions = this.getDebugOptionsFromDomainXMLJavaConfig();
        this.parseJavaConfigDebugOptions();
        domainXML.setupConfigDir(this.getInfo().getConfigDir(), this.getInfo().getInstallDir());
        this.setLogFilename(domainXML);
        this.resolveAllTokens();
        this.fixLogFilename();
        GFLauncherLogger.addLogFileHandler(this.logFilename);
        this.setJavaExecutable();
        this.setClasspath();
        this.initCommandLine();
        this.setJvmOptions();
        this.logCommandLine();
        this.needsAutoUpgrade = !domainXML.hasNetworkConfig();
        this.needsManualUpgrade = !domainXML.hasDefaultConfig();
        this.setupCalledByClients = true;
    }

    public final GFLauncherInfo getInfo() {
        return this.callerParameters;
    }

    public String getAdminRealmKeyFile() {
        return this.adminFileRealmKeyFile;
    }

    public boolean isSecureAdminEnabled() {
        return this.secureAdminEnabled;
    }

    public final int getExitValue() {
        return this.exitValue;
    }

    public final Process getProcess() throws GFLauncherException {
        if (this.glassFishProcess == null) {
            throw new GFLauncherException("invalid_process");
        }
        return this.glassFishProcess;
    }

    public final ProcessStreamDrainer getProcessStreamDrainer() throws GFLauncherException {
        if (this.processStreamDrainer == null) {
            throw new GFLauncherException("invalid_psd");
        }
        return this.processStreamDrainer;
    }

    public String getLogFilename() throws GFLauncherException {
        if (!this.logFilenameWasFixed) {
            throw new GFLauncherException(strings.get("internalError") + " call to getLogFilename() before it has been initialized");
        }
        return this.logFilename;
    }

    public final int getDebugPort() {
        return this.debugPort;
    }

    public final boolean isDebugSuspend() {
        return this.debugPort >= 0 && this.debugSuspend;
    }

    public final boolean needsAutoUpgrade() {
        return this.needsAutoUpgrade;
    }

    public final boolean needsManualUpgrade() {
        return this.needsManualUpgrade;
    }

    abstract void internalLaunch() throws GFLauncherException;

    void launchInstance() throws GFLauncherException {
        List<Object> cmds;
        boolean securityTokensAvailable;
        if (this.isFakeLaunch()) {
            return;
        }
        boolean bl = securityTokensAvailable = !this.callerParameters.securityTokens.isEmpty();
        if (OS.isDarwin() && GFLauncher.useLaunchCtl(System.getProperty("os.version")) && !this.getInfo().isVerboseOrWatchdog()) {
            cmds = new ArrayList<String>();
            cmds.add("launchctl");
            cmds.add("bsexec");
            cmds.add("/");
            cmds.addAll(this.commandLine.toList());
        } else if (this.commandLine.getFormat() == CommandLine.CommandFormat.Script) {
            cmds = GFLauncher.prepareWindowsEnvironment(this.commandLine, this.getInfo().getConfigDir().toPath(), securityTokensAvailable);
        } else if (this.getInfo().isVerboseOrWatchdog()) {
            cmds = new ArrayList();
            cmds.addAll(this.commandLine.toList());
        } else {
            cmds = new ArrayList();
            if (!GFLauncher.isWindows()) {
                cmds.add("nohup");
            }
            cmds.addAll(this.commandLine.toList());
        }
        System.err.println("Executing: " + cmds.stream().collect(Collectors.joining(" ")));
        System.err.println("Please look at the server log for more details...");
        ProcessBuilder processBuilder = new ProcessBuilder(cmds);
        if (this.getInfo().isVerboseOrWatchdog()) {
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            processBuilder.redirectError(ProcessBuilder.Redirect.INHERIT);
        }
        try {
            processBuilder.directory(this.getInfo().getConfigDir());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            GFLauncherLogger.removeLogFileHandler();
            this.glassFishProcess = processBuilder.start();
            String name = this.getInfo().getDomainName();
            this.processStreamDrainer = this.getInfo().isVerbose() ? ProcessStreamDrainer.redirect((String)name, (Process)this.glassFishProcess) : (this.getInfo().isWatchdog() ? ProcessStreamDrainer.dispose((String)name, (Process)this.glassFishProcess) : ProcessStreamDrainer.save((String)name, (Process)this.glassFishProcess));
            GFLauncher.handleDeadProcess(this.glassFishProcess, this.processStreamDrainer);
            if (securityTokensAvailable) {
                GFLauncher.writeSecurityTokens(this.glassFishProcess, this.processStreamDrainer, this.callerParameters.securityTokens);
            }
        }
        catch (Exception e) {
            throw new GFLauncherException("jvmfailure", (Throwable)e, e);
        }
        if (this.getInfo().isVerboseOrWatchdog()) {
            this.wait(this.glassFishProcess);
        }
    }

    boolean isFakeLaunch() {
        return this.mode == LaunchType.fake;
    }

    public final CommandLine getCommandLine() {
        return this.commandLine;
    }

    protected final void setCommandLine(CommandLine commandLine) {
        this.commandLine = commandLine;
    }

    void setMode(LaunchType mode) {
        this.mode = mode;
    }

    LaunchType getMode() {
        return this.mode;
    }

    final long getStartTime() {
        return this.startTime;
    }

    abstract List<File> getMainClasspath() throws GFLauncherException;

    abstract String getMainClass() throws GFLauncherException;

    final Map<String, String> getEnvProps() {
        return this.asenvProps;
    }

    private ASenvPropertyReader getAsEnvConfReader() {
        if (this.isFakeLaunch()) {
            return new ASenvPropertyReader(this.callerParameters.getInstallDir());
        }
        return new ASenvPropertyReader();
    }

    private List<String> getDebugOptionsFromDomainXMLJavaConfig() {
        if (this.callerParameters.isDebug() || this.callerParameters.isSuspend() || this.domainXMLjavaConfig.isDebugEnabled()) {
            if (!this.callerParameters.isSuspend()) {
                return this.domainXMLjavaConfig.getDebugOptions();
            }
            return this.domainXMLjavaConfig.getDebugOptions().stream().filter(e -> e.startsWith("-agentlib:jdwp")).map(e -> e.replace("suspend=n", "suspend=y")).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private void parseJavaConfigDebugOptions() {
        for (String option : this.domainXMLjavaConfigDebugOptions) {
            String[] attributes;
            if (!option.startsWith("-agentlib:jdwp")) continue;
            for (String attribute : attributes = option.substring(10).split(",")) {
                if (attribute.startsWith("address=")) {
                    try {
                        this.debugPort = Integer.parseInt(attribute.substring(10));
                    }
                    catch (NumberFormatException ex) {
                        this.debugPort = -1;
                    }
                }
                if (!attribute.startsWith("suspend=")) continue;
                try {
                    this.debugSuspend = attribute.substring(8).toLowerCase(Locale.getDefault()).equals("y");
                }
                catch (Exception ex) {
                    this.debugSuspend = false;
                }
            }
        }
    }

    private void setLogFilename(MiniXmlParser domainXML) {
        this.logFilename = domainXML.getLogFilename();
        if (this.logFilename == null) {
            this.logFilename = "logs/server.log";
        }
    }

    private void resolveAllTokens() {
        HashMap<String, String> all = new HashMap<String, String>();
        all.putAll(this.asenvProps);
        all.putAll(CollectionUtils.propertiesToStringMap((Properties)System.getProperties()));
        all.putAll(this.domainXMLSystemProperty);
        all.putAll(this.domainXMLjvmOptions.getCombinedMap());
        all.putAll(this.domainXMLJavaConfigProfiler.getConfig());
        if (GFLauncher.isPreferEnvOverProperties(all).booleanValue()) {
            all.putAll(System.getenv());
            this.replacePropertiesWithEnvVars(this.domainXMLjvmOptions.xProps);
            this.replacePropertiesWithEnvVars(this.domainXMLjvmOptions.xxProps);
            this.replacePropertiesWithEnvVars(this.domainXMLjvmOptions.plainProps);
            this.replacePropertiesWithEnvVars(this.domainXMLjvmOptions.longProps);
            this.replacePropertiesWithEnvVars(this.domainXMLjvmOptions.sysProps);
        } else {
            System.getenv().forEach((name, value) -> all.putIfAbsent((String)name, (String)value));
        }
        TokenResolver resolver = new TokenResolver(all);
        resolver.resolve(this.domainXMLjvmOptions.xProps);
        resolver.resolve(this.domainXMLjvmOptions.xxProps);
        resolver.resolve(this.domainXMLjvmOptions.plainProps);
        resolver.resolve(this.domainXMLjvmOptions.longProps);
        resolver.resolve(this.domainXMLjvmOptions.sysProps);
        resolver.resolve(this.domainXMLjavaConfig.getMap());
        resolver.resolve(this.domainXMLJavaConfigProfiler.getConfig());
        resolver.resolve(this.domainXMLjavaConfigDebugOptions);
        this.logFilename = resolver.resolve(this.logFilename);
        this.adminFileRealmKeyFile = resolver.resolve(this.adminFileRealmKeyFile);
    }

    private void replacePropertiesWithEnvVars(Map<String, String> properties) {
        Pattern invalidEnvVarCharsPattern = Pattern.compile("[^_0-9a-zA-Z]");
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String envValue = System.getenv(entry.getKey());
            if (envValue != null) {
                entry.setValue(envValue);
                continue;
            }
            String sanitizedKey = invalidEnvVarCharsPattern.matcher(entry.getKey()).replaceAll("_");
            envValue = System.getenv(sanitizedKey);
            if (envValue != null) {
                entry.setValue(envValue);
                continue;
            }
            envValue = System.getenv(sanitizedKey.toUpperCase());
            if (envValue == null) continue;
            entry.setValue(envValue);
        }
    }

    private static Boolean isPreferEnvOverProperties(Map<String, String> properties) {
        return Boolean.parseBoolean(properties.get("org.glassfish.envPreferredToProperties"));
    }

    private void fixLogFilename() throws GFLauncherException {
        boolean wasCreated;
        File parent;
        File logFile;
        if (!GFLauncherUtils.ok((String)this.logFilename)) {
            this.logFilename = "logs/server.log";
        }
        if (!(logFile = new File(this.logFilename)).isAbsolute()) {
            logFile = new File(this.callerParameters.getInstanceRootDir(), this.logFilename);
        }
        if (!((logFile = logFile.toPath().toAbsolutePath().normalize().toFile()).exists() || (parent = logFile.getParentFile()).isDirectory() || (wasCreated = parent.mkdirs()))) {
            logFile = null;
        }
        this.logFilename = logFile == null ? null : logFile.getPath();
        this.logFilenameWasFixed = true;
    }

    private void setJavaExecutable() throws GFLauncherException {
        if (this.setJavaExecutableIfValid(this.domainXMLjavaConfig.getJavaHome())) {
            return;
        }
        if (!this.setJavaExecutableIfValid(this.asenvProps.get("com.sun.aas.javaRoot"))) {
            throw new GFLauncherException("nojvm");
        }
    }

    boolean setJavaExecutableIfValid(String filename) {
        if (!GFLauncherUtils.ok((String)filename)) {
            return false;
        }
        File javaFile = new File(filename);
        if (!javaFile.isDirectory()) {
            return false;
        }
        javaFile = GFLauncherUtils.isWindows() ? new File(javaFile, "bin/java.exe") : new File(javaFile, "bin/java");
        if (javaFile.exists()) {
            this.javaExe = javaFile.toPath().toAbsolutePath();
            return true;
        }
        return false;
    }

    void setClasspath() throws GFLauncherException {
        List<File> mainCP = this.getMainClasspath();
        List<File> envCP = this.domainXMLjavaConfig.getEnvClasspath();
        List<File> sysCP = this.domainXMLjavaConfig.getSystemClasspath();
        List<File> prefixCP = this.domainXMLjavaConfig.getPrefixClasspath();
        List<File> suffixCP = this.domainXMLjavaConfig.getSuffixClasspath();
        List<File> profilerCP = this.domainXMLJavaConfigProfiler.getClasspath();
        ArrayList<File> all = new ArrayList<File>();
        all.addAll(prefixCP);
        all.addAll(profilerCP);
        all.addAll(mainCP);
        all.addAll(sysCP);
        all.addAll(envCP);
        all.addAll(suffixCP);
        this.setClasspath((File[])all.toArray(File[]::new));
    }

    void initCommandLine() throws GFLauncherException {
        boolean useScript = !this.getInfo().isVerboseOrWatchdog() && GFLauncher.isSurviveWinUserSession();
        CommandLine cmdLine = new CommandLine(useScript ? CommandLine.CommandFormat.Script : CommandLine.CommandFormat.ProcessBuilder);
        cmdLine.append(this.javaExe);
        if (this.classpath.length > 0) {
            cmdLine.appendClassPath(this.getClasspath());
        }
        this.addIgnoreNull(cmdLine, this.domainXMLjavaConfigDebugOptions);
        String CLIStartTime = System.getProperty("WALL_CLOCK_START");
        if (CLIStartTime != null) {
            cmdLine.append("-DWALL_CLOCK_START=" + CLIStartTime);
        }
        if (this.debugPort >= 0) {
            cmdLine.appendSystemOption("com.sun.aas.debugMode", Boolean.TRUE.toString());
        }
        if (this.domainXMLjvmOptions != null) {
            this.domainXMLjvmOptions.toList().forEach(cmdLine::appendJavaOption);
        }
        GFLauncherNativeHelper nativeHelper = new GFLauncherNativeHelper(this.callerParameters, this.domainXMLjavaConfig, this.domainXMLjvmOptions, this.domainXMLJavaConfigProfiler);
        cmdLine.appendNativeLibraryPath(nativeHelper.getNativePath());
        this.addIgnoreNull(cmdLine, this.getMainClass());
        try {
            this.addIgnoreNull(cmdLine, this.getInfo().getArgsAsList());
        }
        catch (GFLauncherException gfle) {
            throw gfle;
        }
        catch (Exception e) {
            throw new GFLauncherException(e);
        }
        this.setCommandLine(cmdLine);
    }

    void setJvmOptions() {
        this.domainXMLJvmOptionsAsList.clear();
        if (this.domainXMLjvmOptions != null) {
            this.domainXMLjvmOptions.toList().forEach(this.domainXMLJvmOptionsAsList::add);
        }
    }

    void logCommandLine() {
        if (!this.isFakeLaunch()) {
            GFLauncherLogger.info("NCLS-GFLAUNCHER-00005", this.commandLine.toString("\n"));
        }
    }

    public final List<String> getJvmOptions() {
        return this.domainXMLJvmOptionsAsList;
    }

    private void addIgnoreNull(CommandLine command, String s) {
        if (GFLauncherUtils.ok((String)s)) {
            command.append(s);
        }
    }

    private void addIgnoreNull(CommandLine command, Collection<String> ss) {
        if (ss != null && !ss.isEmpty()) {
            ss.forEach(command::append);
        }
    }

    private void wait(Process p) throws GFLauncherException {
        try {
            p.waitFor();
            this.exitValue = p.exitValue();
        }
        catch (InterruptedException ex) {
            throw new GFLauncherException("verboseInterruption", (Throwable)ex, ex);
        }
    }

    private void setupProfilerAndJvmOptions(MiniXmlParser domainXML) throws MiniXmlParserException, GFLauncherException {
        this.domainXMLJavaConfigProfiler = new Profiler(domainXML.getProfilerConfig(), domainXML.getProfilerJvmOptions(), domainXML.getProfilerSystemProperties());
        List rawJvmOptions = domainXML.getJvmOptions();
        rawJvmOptions.addAll(this.getSpecialSystemProperties());
        if (this.domainXMLJavaConfigProfiler.isEnabled()) {
            rawJvmOptions.addAll(this.domainXMLJavaConfigProfiler.getJvmOptions());
        }
        this.domainXMLjvmOptions = new JvmOptions(rawJvmOptions);
        if (this.callerParameters.isDropInterruptedCommands()) {
            this.domainXMLjvmOptions.sysProps.put("org.glassfish.job-manager.drop-interrupted-commands", Boolean.TRUE.toString());
        }
    }

    private void setupUpgradeSecurity() throws GFLauncherException {
        if (this.callerParameters.isUpgrade() && this.domainXMLjvmOptions.sysProps.containsKey("java.security.manager")) {
            GFLauncherLogger.info("NCLS-GFLAUNCHER-00004", new Object[0]);
            Path source = this.callerParameters.installDir.toPath().resolve(Path.of("lib", "templates", "server.policy"));
            Path target = this.callerParameters.getConfigDir().toPath().resolve("server.policy");
            try {
                Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ioe) {
                Throwable cause = ioe.getCause() == null ? ioe : ioe.getCause();
                throw new GFLauncherException(strings.get("copy_server_policy_error", new Object[]{cause.getMessage()}), ioe);
            }
        }
    }

    private void renameOsgiCache() throws GFLauncherException {
        if (this.callerParameters.isUpgrade()) {
            File osgiCacheDir = new File(this.callerParameters.getDomainRootDir(), "osgi-cache");
            File backupOsgiCacheDir = new File(this.callerParameters.getDomainRootDir(), "osgi-cache-" + System.currentTimeMillis());
            if (osgiCacheDir.exists() && !backupOsgiCacheDir.exists()) {
                if (FileUtils.renameFile((File)osgiCacheDir, (File)backupOsgiCacheDir)) {
                    GFLauncherLogger.fine("rename_osgi_cache_succeeded", osgiCacheDir, backupOsgiCacheDir);
                } else {
                    throw new GFLauncherException(strings.get("rename_osgi_cache_failed", new Object[]{osgiCacheDir, backupOsgiCacheDir}));
                }
            }
        }
    }

    private void setupMonitoring(MiniXmlParser parser) {
        if (!parser.isMonitoringEnabled()) {
            return;
        }
        Set<String> plainKeys = this.domainXMLjvmOptions.plainProps.keySet();
        for (String key : plainKeys) {
            if (!key.startsWith("javaagent:") || (key = key.replace('\\', '/')).indexOf("flashlight-agent.jar") < 0) continue;
            return;
        }
        try {
            this.domainXMLjvmOptions.plainProps.put(this.getMonitoringAgentJvmOptionString(), null);
        }
        catch (GFLauncherException gFLauncherException) {
            // empty catch block
        }
    }

    private String getMonitoringAgentJvmOptionString() throws GFLauncherException {
        File libMonDir = new File(this.getInfo().getInstallDir(), "lib/monitor");
        File flashlightJarFile = new File(libMonDir, "flashlight-agent.jar");
        if (flashlightJarFile.isFile()) {
            return "javaagent:" + String.valueOf(flashlightJarFile.toPath().toAbsolutePath().normalize());
        }
        String msg = strings.get("no_flashlight_agent", new Object[]{flashlightJarFile});
        GFLauncherLogger.warning("NCLS-GFLAUNCHER-00003", flashlightJarFile);
        throw new GFLauncherException(msg);
    }

    private List<String> getSpecialSystemProperties() throws GFLauncherException {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("com.sun.aas.installRoot", this.getInfo().getInstallDir().getAbsolutePath());
        props.put("com.sun.aas.instanceRoot", this.getInfo().getInstanceRootDir().getAbsolutePath());
        return this.propsToJvmOptions(props);
    }

    final File[] getClasspath() {
        return this.classpath;
    }

    final void setClasspath(File ... classpath) {
        this.classpath = classpath;
    }

    private List<String> propsToJvmOptions(Map<String, String> map) {
        ArrayList<String> ss = new ArrayList<String>();
        Set<Map.Entry<String, String>> entries = map.entrySet();
        for (Map.Entry<String, String> entry : entries) {
            String name = entry.getKey();
            String value = entry.getValue();
            String jvm = "-D" + name;
            if (value != null) {
                jvm = jvm + "=" + value;
            }
            ss.add(jvm);
        }
        return ss;
    }

    private void setupLogLevels() {
        if (this.callerParameters.isVerbose()) {
            GFLauncherLogger.setConsoleLevel(Level.INFO);
        } else {
            GFLauncherLogger.setConsoleLevel(Level.WARNING);
        }
    }

    private static boolean useLaunchCtl(String osversion) {
        int major = 0;
        int minor = 0;
        if (osversion == null || osversion.isEmpty()) {
            return false;
        }
        String[] split = osversion.split("[\\._\\-]+");
        try {
            if (split.length > 0 && split[0].length() > 0) {
                major = Integer.parseInt(split[0]);
            }
            if (split.length > 1 && split[1].length() > 0) {
                minor = Integer.parseInt(split[1]);
            }
            return major <= 9 || major <= 10 && minor < 10;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    private static boolean isSurviveWinUserSession() {
        String surviveSessionValue = System.getenv("AS_SURVIVE_WIN_USER_SESSION");
        if (surviveSessionValue == null) {
            return GFLauncher.isWindows() && GFLauncher.isOverSSHSession();
        }
        return Boolean.parseBoolean(surviveSessionValue);
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
    }

    private static boolean isOverSSHSession() {
        return System.getenv("SSH_CLIENT") != null || System.getenv("SSH_CONNECTION") != null || System.getenv("SSH_TTY") != null;
    }

    private static List<String> prepareWindowsEnvironment(CommandLine command, Path configDir, boolean stdinPreloaded) throws GFLauncherException {
        try {
            Path startPsFile = GFLauncher.createStartPsScript(command, configDir, stdinPreloaded);
            Path schedulerPsFile = GFLauncher.createSchedulerPsScript(startPsFile, configDir, stdinPreloaded);
            ArrayList<String> cmds = new ArrayList<String>();
            cmds.add("powershell.exe");
            if (stdinPreloaded) {
                cmds.add("-noninteractive");
            }
            cmds.add("-File");
            cmds.add("\"" + String.valueOf(schedulerPsFile) + "\"");
            return cmds;
        }
        catch (IOException e) {
            throw new GFLauncherException(e);
        }
    }

    private static Path createSchedulerPsScript(Path startPsFile, Path configDir, boolean stdinPreloaded) throws IOException {
        StringBuilder schedulerFileContent = new StringBuilder(8192);
        schedulerFileContent.append("$ErrorActionPreference = \"Stop\"\n\n");
        schedulerFileContent.append("$pidFile = \"").append(new File(configDir.toFile(), "pid").getAbsolutePath()).append("\"\n");
        schedulerFileContent.append("if (Test-Path $pidFile) {\n");
        schedulerFileContent.append("    Remove-Item $pidFile -Force\n");
        schedulerFileContent.append("}\n");
        if (stdinPreloaded) {
            schedulerFileContent.append("$stdin = [System.IO.StreamReader]::new([Console]::OpenStandardInput()).ReadToEnd()\n");
            schedulerFileContent.append("$tempFile = [System.IO.Path]::GetTempFileName()\n");
            schedulerFileContent.append("[System.IO.File]::WriteAllText($tempFile, $stdin)\n");
        }
        schedulerFileContent.append("$action = New-ScheduledTaskAction -Execute \"powershell.exe\" -Argument \"-File `\"").append(startPsFile).append("`\" `\"$tempFile`\"\"\n");
        schedulerFileContent.append("$taskName = \"GlassFishInstance_\" + [System.Guid]::NewGuid().ToString()\n");
        schedulerFileContent.append("$trigger = New-ScheduledTaskTrigger -Once -At (Get-Date).AddSeconds(1)\n");
        schedulerFileContent.append("$principal = New-ScheduledTaskPrincipal -UserId $env:USERNAME -LogonType S4U\n");
        schedulerFileContent.append("$settings = New-ScheduledTaskSettingsSet -AllowStartIfOnBatteries -DontStopIfGoingOnBatteries -ExecutionTimeLimit (New-TimeSpan -Hours 0)\n");
        schedulerFileContent.append("Register-ScheduledTask -TaskName $taskName -Action $action -Trigger $trigger -Principal $principal -Settings $settings\n");
        schedulerFileContent.append("Start-ScheduledTask -TaskName $taskName\n");
        schedulerFileContent.append("Unregister-ScheduledTask -TaskName $taskName -Confirm:$false\n");
        schedulerFileContent.append("$start = Get-Date\n");
        schedulerFileContent.append("$timeout = 60\n");
        schedulerFileContent.append("while (-not (Test-Path $pidFile)) {\n");
        schedulerFileContent.append("    if ((New-TimeSpan -Start $start -End (Get-Date)).TotalSeconds -gt $timeout) {\n");
        if (stdinPreloaded) {
            schedulerFileContent.append("        Remove-Item $tempFile -Force\n");
        }
        schedulerFileContent.append("        Write-Error \"Timeout waiting for GlassFish to start (pid file not created within $timeout seconds)\"\n");
        schedulerFileContent.append("        exit 1\n");
        schedulerFileContent.append("    }\n");
        schedulerFileContent.append("    Start-Sleep -Seconds 1\n");
        schedulerFileContent.append("}\n");
        if (stdinPreloaded) {
            schedulerFileContent.append("Remove-Item $tempFile -Force\n");
        }
        Path schedulerPsFile = configDir.resolve("scheduler.ps1");
        Files.writeString(schedulerPsFile, (CharSequence)schedulerFileContent, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        return schedulerPsFile;
    }

    private static Path createStartPsScript(CommandLine command, Path configDir, boolean stdinPreloaded) throws IOException {
        List<String> commandArgs = command.toList();
        StringBuilder scriptBlock = new StringBuilder();
        scriptBlock.append("$javaExe = ").append(commandArgs.get(0)).append('\n');
        if (stdinPreloaded) {
            scriptBlock.append("$tempFile = $args[0]\n");
        }
        scriptBlock.append("$javaArgs = @(").append((CharSequence)GFLauncher.toPowerShellArgumentList(commandArgs)).append(")\n");
        scriptBlock.append("Start-Process -NoNewWindow -PassThru -FilePath ");
        scriptBlock.append(commandArgs.get(0));
        if (stdinPreloaded) {
            scriptBlock.append(" -RedirectStandardInput");
            scriptBlock.append(" \"$tempFile\"");
        }
        scriptBlock.append(" -ArgumentList $javaArgs\n");
        Path startPsFile = configDir.resolve("start.ps1");
        Files.writeString(startPsFile, (CharSequence)scriptBlock, StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        return startPsFile;
    }

    private static StringBuilder toPowerShellArgumentList(List<String> command) {
        StringBuilder psContent = new StringBuilder();
        for (int i = 1; i < command.size(); ++i) {
            psContent.append('\n');
            psContent.append('\"');
            psContent.append(command.get(i).replace("\"", "`\""));
            psContent.append('\"');
        }
        return psContent;
    }

    private static void writeSecurityTokens(Process glassfishProcess, ProcessStreamDrainer drainer, List<String> securityTokens) throws GFLauncherException, IOException {
        OutputStream os = glassfishProcess.getOutputStream();
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            osw = new OutputStreamWriter(os, Charset.defaultCharset());
            bw = new BufferedWriter(osw);
            for (String token : securityTokens) {
                bw.write(token);
                bw.newLine();
                bw.flush();
            }
        }
        catch (IOException e) {
            GFLauncher.handleDeadProcess(glassfishProcess, drainer);
            throw e;
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            if (osw != null) {
                osw.close();
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            if (bw != null) {
                GFLauncher.handleDeadProcess(glassfishProcess, drainer);
            }
        }
    }

    private static void handleDeadProcess(Process glassfishProcess, ProcessStreamDrainer drainer) throws GFLauncherException {
        String trace = GFLauncher.getDeadProcessTrace(glassfishProcess, drainer);
        if (trace != null) {
            throw new GFLauncherException(trace);
        }
    }

    private static String getDeadProcessTrace(Process process, ProcessStreamDrainer drainer) {
        if (process.isAlive()) {
            return null;
        }
        int ev = process.exitValue();
        if (ev == 0) {
            return null;
        }
        String output = drainer.getOutErrString();
        return strings.get("server_process_died", new Object[]{ev, output});
    }

    static enum LaunchType {
        normal,
        debug,
        trace,
        fake;

    }
}

