/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.config.support;

import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.hk2.component.ExistingSingletonInhabitant;
import java.beans.PropertyVetoException;
import javax.inject.Inject;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.config.support.CrudResolver;
import org.glassfish.config.support.GenericCrudCommand;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.Habitat;
import org.jvnet.hk2.component.Inhabitant;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.Dom;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service(name="type")
public class TypeResolver
implements CrudResolver {
    @Inject
    Habitat habitat;
    @Inject
    Domain domain;
    protected static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(TypeResolver.class);

    @Override
    public <T extends ConfigBeanProxy> T resolve(AdminCommandContext context, final Class<T> type) {
        ConfigBeanProxy proxy = (ConfigBeanProxy)this.habitat.getComponent(type);
        if (proxy == null) {
            try {
                proxy = (ConfigBeanProxy)type.cast(ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Domain>(){

                    public Object run(Domain writeableDomain) throws PropertyVetoException, TransactionFailure {
                        String elementName;
                        ConfigBeanProxy child = writeableDomain.createChild(type);
                        Dom domDomain = Dom.unwrap((ConfigBeanProxy)writeableDomain);
                        try {
                            elementName = GenericCrudCommand.elementName(domDomain.document, Domain.class, type);
                        }
                        catch (ClassNotFoundException e) {
                            throw new TransactionFailure(e.toString());
                        }
                        if (elementName == null) {
                            String msg = localStrings.getLocalString(TypeResolver.class, "TypeResolver.no_element_of_that_type", "The Domain configuration does not have a sub-element of the type {0}", new Object[]{type.getSimpleName()});
                            throw new TransactionFailure(msg);
                        }
                        domDomain.setNodeElements(elementName, new Dom[]{Dom.unwrap((ConfigBeanProxy)child)});
                        TypeResolver.this.habitat.addIndex((Inhabitant)new ExistingSingletonInhabitant((Object)child), type.getName(), null);
                        return child;
                    }
                }, (ConfigBeanProxy)this.domain));
            }
            catch (TransactionFailure e) {
                throw new RuntimeException(e);
            }
            if (proxy == null) {
                String msg = localStrings.getLocalString(TypeResolver.class, "TypeResolver.target_object_not_found", "Cannot find a single component instance of type {0}", new Object[]{type.getSimpleName()});
                throw new RuntimeException(msg);
            }
        }
        return (T)proxy;
    }
}

