/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli.optional;

import com.sun.enterprise.admin.cli.optional.BackupCommands;
import com.sun.enterprise.backup.BackupException;
import com.sun.enterprise.backup.BackupRequest;
import com.sun.enterprise.backup.BackupWarningException;
import com.sun.enterprise.backup.RestoreManager;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.ObjectAnalyzer;
import com.sun.enterprise.util.Utility;
import java.io.File;
import java.io.IOException;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.jvnet.hk2.annotations.Service;

@Service(name="restore-domain")
@PerLookup
public final class RestoreDomainCommand
extends BackupCommands {
    private static final LocalStringsImpl strings = new LocalStringsImpl(RestoreDomainCommand.class);
    @Param(name="filename", optional=true)
    private String backupFilename;
    @Param(name="force", optional=true, defaultValue="false")
    private boolean force;
    @Param(name="description", optional=true, obsolete=true)
    private String description;

    protected void validate() throws CommandException, CommandValidationException {
        boolean domainExists = true;
        if (Utility.isAllNull((Object[])new Object[]{this.backupFilename, this.domainName})) {
            if (!this.force) {
                throw new CommandException(strings.get("UseForceOption"));
            }
            super.validate();
        }
        this.checkOptions();
        try {
            this.setDomainName(this.domainName);
            this.initDomain();
        }
        catch (CommandException e) {
            if (e.getCause() != null && e.getCause() instanceof IOException) {
                domainExists = false;
            }
            throw e;
        }
        if (domainExists && ProcessUtils.isAlive((File)this.getServerDirs().getPidFile())) {
            throw new CommandException(strings.get("DomainIsNotStopped", new Object[]{this.domainName}));
        }
        if (this.backupFilename != null) {
            File backupFile = new File(this.backupFilename);
            if (!backupFile.exists()) {
                throw new CommandValidationException(strings.get("FileDoesNotExist", new Object[]{this.backupFilename}));
            }
            if (!backupFile.canRead()) {
                throw new CommandValidationException(strings.get("FileCanNotRead", new Object[]{this.backupFilename}));
            }
            if (backupFile.isDirectory()) {
                throw new CommandValidationException(strings.get("FileIsDirectory", new Object[]{this.backupFilename}));
            }
        }
        this.setBackupDir(this.backupdir);
        this.initRequest();
        this.initializeLogger();
    }

    protected int executeCommand() throws CommandException {
        try {
            RestoreManager restoreManager = new RestoreManager(this.request);
            logger.info(restoreManager.restore());
        }
        catch (BackupWarningException bwe) {
            logger.info(bwe.getMessage());
        }
        catch (BackupException be) {
            throw new CommandException((Throwable)be);
        }
        return 0;
    }

    private void initRequest() throws CommandValidationException {
        File backupdirFile = null;
        if (this.backupdir != null && !(backupdirFile = new File(this.backupdir)).isAbsolute()) {
            throw new CommandValidationException(strings.get("InvalidBackupDirPath", new Object[]{this.backupdir}));
        }
        boolean configonlybackup = false;
        if (this.configonly != null && Boolean.valueOf(this.configonly).booleanValue()) {
            configonlybackup = true;
        }
        this.request = new BackupRequest(this.domainDirParam, this.domainName, backupdirFile, this.backupConfig, this.backupFilename, configonlybackup);
        this.request.setTerse(this.programOpts.isTerse());
        this.request.setVerbose(this.verbose);
        this.request.setForce(this.force);
    }

    @Override
    public String toString() {
        return super.toString() + "\n" + ObjectAnalyzer.toString((Object)((Object)this));
    }
}

