/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util.cache;

import com.sun.enterprise.admin.util.cache.AdminCache;
import com.sun.enterprise.admin.util.cache.AdminCacheWeakReference;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class AdminCacheMemStore
implements AdminCache {
    private static final AdminCacheMemStore instance = new AdminCacheMemStore();
    private static final int MAX_CACHED_ITEMS_COUNT = 16;
    private final Map<String, CachedItem> cache = new HashMap<String, CachedItem>(17);
    private AdminCacheWeakReference underCache = AdminCacheWeakReference.getInstance();

    private AdminCacheMemStore() {
    }

    @Override
    public <A> A get(String key, Class<A> clazz) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Attribute clazz can not be null.");
        }
        CachedItem ci = this.cache.get(key);
        if (ci == null) {
            A item = this.underCache.get(key, clazz);
            if (item != null) {
                this.putToLocalCache(key, new CachedItem(item));
            }
            return item;
        }
        return (A)ci.getItem();
    }

    @Override
    public void put(String key, Object data) {
        this.underCache.put(key, data);
        this.putToLocalCache(key, new CachedItem(data));
    }

    private synchronized void putToLocalCache(String key, CachedItem ci) {
        if (this.cache.size() >= 16) {
            CachedItem oldest = null;
            Collection<CachedItem> values = this.cache.values();
            for (CachedItem item : values) {
                if (oldest == null) {
                    oldest = item;
                    continue;
                }
                if (item.touched >= oldest.touched) continue;
                oldest = item;
            }
            values.remove(oldest);
        }
        this.cache.put(key, ci);
    }

    @Override
    public boolean contains(String key) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Attribute key must be unempty.");
        }
        CachedItem item = this.cache.get(key);
        if (item != null) {
            item.getItem();
            return true;
        }
        return this.underCache.contains(key);
    }

    @Override
    public Date lastUpdated(String key) {
        return this.underCache.lastUpdated(key);
    }

    public static AdminCacheMemStore getInstance() {
        return instance;
    }

    private final class CachedItem
    implements Comparable<CachedItem> {
        private Object item;
        private long touched;

        private CachedItem(Object item) {
            this.item = item;
            this.touched = System.currentTimeMillis();
        }

        private Object getItem() {
            this.touched = System.currentTimeMillis();
            return this.item;
        }

        @Override
        public int compareTo(CachedItem o) {
            return (int)(this.touched - o.touched);
        }
    }
}

