/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.inject.Inject;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.hk2.api.PerLookup;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;

@Service(name="list-commands")
@PerLookup
public class ListCommandsCommand
extends CLICommand {
    @Inject
    private ServiceLocator habitat;
    private String[] remoteCommands;
    private String[] localCommands;
    private List<Pattern> patterns = new ArrayList<Pattern>();
    @Param(name="localonly", optional=true)
    private boolean localOnly;
    @Param(name="remoteonly", optional=true)
    private boolean remoteOnly;
    @Param(name="command-pattern", primary=true, optional=true, multiple=true)
    private List<String> cmds;
    private static final String SPACES = "                                                            ";
    private static final LocalStringsImpl strings = new LocalStringsImpl(ListCommandsCommand.class);

    @Override
    protected void validate() throws CommandException, CommandValidationException {
        if (this.localOnly && this.remoteOnly) {
            throw new CommandException(strings.get("listCommands.notBoth"));
        }
    }

    @Override
    public int executeCommand() throws CommandException, CommandValidationException {
        if (this.cmds != null) {
            for (String pat : this.cmds) {
                this.patterns.add(Pattern.compile(this.globToRegex(pat)));
            }
        }
        if (!this.localOnly) {
            try {
                this.remoteCommands = this.matchCommands(CLIUtil.getRemoteCommands(this.habitat, this.programOpts, this.env));
            }
            catch (CommandException ce) {
                throw new CommandException(ce.getMessage());
            }
        }
        if (!this.remoteOnly) {
            this.localCommands = this.matchCommands(CLIUtil.getLocalCommands(this.habitat));
            this.printLocalCommands();
        }
        if (!this.localOnly && !this.remoteOnly) {
            logger.info("");
        }
        if (!this.localOnly) {
            this.printRemoteCommands();
        }
        logger.info("");
        return 0;
    }

    private String[] matchCommands(String[] commands) {
        ArrayList<String> matched = new ArrayList<String>();
        for (String cmd : commands) {
            if (this.patterns.size() == 0) {
                if (cmd.startsWith("_")) continue;
                matched.add(cmd);
                continue;
            }
            for (Pattern re : this.patterns) {
                if (!re.matcher(cmd).find() || cmd.startsWith("_") && !re.pattern().startsWith("_")) continue;
                matched.add(cmd);
            }
        }
        return matched.toArray(new String[matched.size()]);
    }

    private String globToRegex(String line) {
        line = line.trim();
        int strLen = line.length();
        StringBuilder sb = new StringBuilder(strLen);
        if (line.startsWith("*")) {
            line = line.substring(1);
            --strLen;
        }
        if (line.endsWith("*")) {
            line = line.substring(0, strLen - 1);
        }
        boolean escaping = false;
        int inCurlies = 0;
        block9: for (char currentChar : line.toCharArray()) {
            switch (currentChar) {
                case '*': {
                    if (escaping) {
                        sb.append("\\*");
                    } else {
                        sb.append(".*");
                    }
                    escaping = false;
                    continue block9;
                }
                case '?': {
                    if (escaping) {
                        sb.append("\\?");
                    } else {
                        sb.append('.');
                    }
                    escaping = false;
                    continue block9;
                }
                case '$': 
                case '%': 
                case '(': 
                case ')': 
                case '+': 
                case '.': 
                case '@': 
                case '^': 
                case '|': {
                    sb.append('\\');
                    sb.append(currentChar);
                    escaping = false;
                    continue block9;
                }
                case '\\': {
                    if (escaping) {
                        sb.append("\\\\");
                        escaping = false;
                        continue block9;
                    }
                    escaping = true;
                    continue block9;
                }
                case '{': {
                    if (escaping) {
                        sb.append("\\{");
                    } else {
                        sb.append('(');
                        ++inCurlies;
                    }
                    escaping = false;
                    continue block9;
                }
                case '}': {
                    if (inCurlies > 0 && !escaping) {
                        sb.append(')');
                        --inCurlies;
                    } else if (escaping) {
                        sb.append("\\}");
                    } else {
                        sb.append("}");
                    }
                    escaping = false;
                    continue block9;
                }
                case ',': {
                    if (inCurlies > 0 && !escaping) {
                        sb.append('|');
                        continue block9;
                    }
                    if (escaping) {
                        sb.append("\\,");
                        continue block9;
                    }
                    sb.append(",");
                    continue block9;
                }
                default: {
                    escaping = false;
                    sb.append(currentChar);
                }
            }
        }
        return sb.toString();
    }

    void printLocalCommands() {
        if (this.localCommands.length == 0) {
            logger.info(strings.get("listCommands.localCommandNoMatch"));
            return;
        }
        logger.info(strings.get("listCommands.localCommandHeader"));
        for (String s : this.localCommands) {
            logger.info(s);
        }
    }

    void printRemoteCommands() {
        if (this.remoteCommands.length == 0) {
            logger.info(strings.get("listCommands.remoteCommandNoMatch"));
            return;
        }
        logger.info(strings.get("listCommands.remoteCommandHeader"));
        int num = this.remoteCommands.length;
        int offset = num / 2 + num % 2;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < offset; ++i) {
            sb.append(this.remoteCommands[i]);
            sb.append(this.justify(this.remoteCommands[i], 40));
            if (i + offset < num) {
                sb.append(this.remoteCommands[i + offset]);
            }
            if (i >= offset - 1) continue;
            sb.append(CLIConstants.EOL);
        }
        logger.info(sb.toString());
    }

    private String justify(String s, int width) {
        int numSpaces = width - s.length();
        if (numSpaces > 0) {
            return SPACES.substring(0, numSpaces);
        }
        return " ";
    }
}

