/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.cli;

import com.sun.enterprise.admin.cli.CLICommand;
import com.sun.enterprise.admin.cli.CLIUtil;
import com.sun.enterprise.admin.cli.DirectoryClassLoader;
import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.Parser;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.module.single.StaticModulesRegistry;
import com.sun.enterprise.universal.glassfish.ASenvPropertyReader;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.JDK;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.net.ConnectException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.common.util.admin.AsadminInput;
import org.jvnet.hk2.component.Habitat;

public class AsadminMain {
    private String classPath;
    private String className;
    private String command;
    private ProgramOptions po;
    private Habitat habitat;
    private Environment env = new Environment();
    protected Logger logger;
    private static final int ERROR = 1;
    private static final int CONNECTION_ERROR = 2;
    private static final int INVALID_COMMAND_ERROR = 3;
    private static final int SUCCESS = 0;
    private static final int WARNING = 4;
    private static final String ADMIN_CLI_LOGGER = "com.sun.enterprise.admin.cli";
    private static final String[] copyProps = new String[]{"com.sun.aas.installRoot", "com.sun.aas.configRoot", "com.sun.aas.productRoot"};
    private static final LocalStringsImpl strings = new LocalStringsImpl(AsadminMain.class);

    protected ClassLoader getExtensionClassLoader() {
        final ClassLoader ecl = AsadminMain.class.getClassLoader();
        File inst = new File(System.getProperty("com.sun.aas.installRoot"));
        final File ext = new File(new File(inst, "lib"), "asadmin");
        this.logger.log(Level.FINER, "asadmin extension directory: {0}", ext);
        if (ext.isDirectory()) {
            return (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return new DirectoryClassLoader(ext, ecl);
                    }
                    catch (IOException ex) {
                        AsadminMain.this.logger.info(strings.get("ExtDirFailed", new Object[]{ex}));
                        return ecl;
                    }
                }
            });
        }
        this.logger.info(strings.get("ExtDirMissing", new Object[]{ext}));
        return ecl;
    }

    protected String getCommandName() {
        return "asadmin";
    }

    public static void main(String[] args) {
        System.exit(new AsadminMain().doMain(args));
    }

    protected int doMain(String[] args) {
        int minor = JDK.getMinor();
        if (minor < 6) {
            System.err.println(strings.get("OldJdk", new Object[]{"" + minor}));
            return 1;
        }
        boolean trace = this.env.trace();
        boolean debug = this.env.debug();
        this.logger = Logger.getLogger(ADMIN_CLI_LOGGER);
        if (trace) {
            this.logger.setLevel(Level.FINEST);
        } else if (debug) {
            this.logger.setLevel(Level.FINER);
        } else {
            this.logger.setLevel(Level.FINE);
        }
        this.logger.setUseParentHandlers(false);
        CLILoggerHandler h = new CLILoggerHandler();
        h.setLevel(this.logger.getLevel());
        this.logger.addHandler(h);
        Logger rlogger = Logger.getLogger("");
        rlogger.setUseParentHandlers(false);
        for (Handler lh : rlogger.getHandlers()) {
            rlogger.removeHandler(lh);
        }
        rlogger.addHandler(h);
        if (debug) {
            System.setProperty("WALL_CLOCK_START", "" + System.currentTimeMillis());
            this.logger.log(Level.FINER, "CLASSPATH= {0}\nCommands: {1}", new Object[]{System.getProperty("java.class.path"), Arrays.toString(args)});
        }
        ClassLoader ecl = this.getExtensionClassLoader();
        Thread.currentThread().setContextClassLoader(ecl);
        StaticModulesRegistry registry = new StaticModulesRegistry(ecl);
        this.habitat = registry.createHabitat("default");
        this.classPath = SmartFile.sanitizePaths((String)System.getProperty("java.class.path"));
        this.className = AsadminMain.class.getName();
        if (args.length == 0) {
            args = new String[]{"multimode"};
        }
        if (args[0].equals("-V")) {
            args = new String[]{"version"};
        }
        this.command = args[0];
        int exitCode = this.executeCommand(args);
        switch (exitCode) {
            case 0: {
                if (this.po.isTerse()) break;
                this.logger.fine(strings.get("CommandSuccessful", new Object[]{this.command}));
                break;
            }
            case 4: {
                this.logger.fine(strings.get("CommandSuccessfulWithWarnings", new Object[]{this.command}));
                exitCode = 0;
                break;
            }
            default: {
                this.logger.fine(strings.get("CommandUnSuccessful", new Object[]{this.command}));
            }
        }
        CLIUtil.writeCommandToDebugLog(this.po, this.env, args, exitCode);
        return exitCode;
    }

    public int executeCommand(String[] argv) {
        CLICommand cmd = null;
        try {
            if (argv.length > 0 && argv[0].startsWith("-")) {
                Parser rcp = new Parser(argv, 0, ProgramOptions.getValidOptions(), false);
                ParameterMap params = rcp.getOptions();
                this.po = new ProgramOptions(params, this.env);
                AsadminMain.readAndMergeOptionsFromAuxInput(this.po);
                List<String> operands = rcp.getOperands();
                argv = operands.toArray(new String[operands.size()]);
            } else {
                this.po = new ProgramOptions(this.env);
            }
            this.po.toEnvironment(this.env);
            this.po.setClassPath(this.classPath);
            this.po.setClassName(this.className);
            this.po.setCommandName(this.getCommandName());
            if (argv.length == 0) {
                argv = this.po.isHelp() ? new String[]{"help"} : new String[]{"multimode"};
            }
            this.command = argv[0];
            this.habitat.addComponent((Object)this.env);
            this.habitat.addComponent((Object)this.po);
            cmd = CLICommand.getCommand(this.habitat, this.command);
            return cmd.execute(argv);
        }
        catch (CommandValidationException cve) {
            this.logger.severe(cve.getMessage());
            if (cmd == null) {
                this.printUsage();
            } else {
                this.logger.severe(cmd.getUsage());
            }
            return 1;
        }
        catch (InvalidCommandException ice) {
            this.logger.severe(ice.getMessage());
            try {
                CLIUtil.displayClosestMatch(this.command, CLIUtil.getAllCommands(this.habitat, this.po, this.env), strings.get("ClosestMatchedLocalAndRemoteCommands"), this.logger);
            }
            catch (InvalidCommandException e) {
                // empty catch block
            }
            return 1;
        }
        catch (CommandException ce) {
            if (ce.getCause() instanceof ConnectException) {
                this.logger.severe(ce.getMessage());
                try {
                    CLIUtil.displayClosestMatch(this.command, CLIUtil.getLocalCommands(this.habitat), strings.get("ClosestMatchedLocalCommands"), this.logger);
                }
                catch (InvalidCommandException e) {
                    this.logger.info(strings.get("InvalidRemoteCommand", new Object[]{this.command}));
                }
            } else {
                this.logger.severe(ce.getMessage());
            }
            return 1;
        }
    }

    private static void readAndMergeOptionsFromAuxInput(ProgramOptions progOpts) throws CommandException {
        String auxInput = progOpts.getAuxInput();
        if (auxInput == null || auxInput.length() == 0) {
            return;
        }
        ParameterMap newParamMap = new ParameterMap();
        progOpts.setAuxInput(null);
        try {
            AsadminInput.InputReader reader = AsadminInput.reader((String)auxInput);
            Properties newOptions = (Properties)reader.settings().get("option");
            for (String propName : newOptions.stringPropertyNames()) {
                newParamMap.add((Object)propName, (Object)newOptions.getProperty(propName));
            }
            progOpts.updateOptions(newParamMap);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private void printUsage() {
        this.logger.severe(strings.get("Asadmin.usage", new Object[]{this.getCommandName()}));
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    static {
        Map systemProps = new ASenvPropertyReader().getProps();
        for (String prop : copyProps) {
            String val = (String)systemProps.get(prop);
            if (!AsadminMain.ok(val)) continue;
            System.setProperty(prop, val);
        }
    }

    private static class CLILoggerFormatter
    extends SimpleFormatter {
        private CLILoggerFormatter() {
        }

        public synchronized String format(LogRecord record) {
            return this.formatMessage(record);
        }
    }

    private static class CLILoggerHandler
    extends ConsoleHandler {
        private CLILoggerHandler() {
            this.setFormatter(new CLILoggerFormatter());
        }

        public void publish(LogRecord logRecord) {
            if (!this.isLoggable(logRecord)) {
                return;
            }
            PrintStream ps = logRecord.getLevel() == Level.SEVERE ? System.err : System.out;
            ps.println(this.getFormatter().format(logRecord));
        }
    }
}

