/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.memleak.common;

import java.lang.reflect.Method;
import java.time.Duration;
import org.glassfish.jersey.test.memleak.common.MemoryLeakUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.InvocationInterceptor;
import org.junit.jupiter.api.extension.ReflectiveInvocationContext;

public class MemoryLeakSucceedingTimeout
implements InvocationInterceptor {
    private static final int DEFAULT_TIMEOUT_MILLIS = 300000;
    private int millis;

    public MemoryLeakSucceedingTimeout() {
        this(300000);
    }

    public MemoryLeakSucceedingTimeout(int defaultMillisTimeout) {
        this.millis = Integer.getInteger("jersey.config.test.memleak.timeout", defaultMillisTimeout);
    }

    public void interceptTestMethod(InvocationInterceptor.Invocation<Void> invocation, ReflectiveInvocationContext<Method> invocationContext, ExtensionContext extensionContext) throws Throwable {
        try {
            Assertions.assertTimeoutPreemptively((Duration)Duration.ofMillis(this.millis), () -> invocation.proceed());
        }
        catch (Throwable throwable) {
            if (throwable.getMessage().startsWith("execution timed out after")) {
                MemoryLeakUtils.verifyNoOutOfMemoryOccurred();
                System.out.println("Test timed out after " + this.millis + " ms. Successfully ending.");
            }
            throw throwable;
        }
    }
}

