/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.memleak.common;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.management.MBeanServer;

public class MemoryLeakUtils {
    public static final String JERSEY_CONFIG_TEST_CONTAINER_LOGFILE = "jersey.config.test.container.logfile";
    public static final String JERSEY_CONFIG_TEST_MEMLEAK_TIMEOUT = "jersey.config.test.memleak.timeout";
    public static final String JERSEY_CONFIG_TEST_CONTAINER_CONTEXT_ROOT = "jersey.config.test.container.contextRoot";
    public static final String JERSEY_CONFIG_TEST_MEMLEAK_HEAP_DUMP_PATH = "jersey.config.test.memleak.heapDumpPath";
    private static final Pattern PATTERN = Pattern.compile(".*java\\.lang\\.OutOfMemoryError.*");
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final String HOT_SPOT_DIAGNOSTIC_MXBEAN_CLASSNAME = "com.sun.management.HotSpotDiagnosticMXBean";
    private static volatile Object hotSpotDiagnosticMBean;
    private static volatile Method dumpHeapMethod;

    private MemoryLeakUtils() {
    }

    public static void verifyNoOutOfMemoryOccurred() throws IOException {
        String logFileName = System.getProperty(JERSEY_CONFIG_TEST_CONTAINER_LOGFILE);
        System.out.println("Verifying whether OutOfMemoryError occurred in log file: " + logFileName);
        if (logFileName == null) {
            return;
        }
        File logFile = new File(logFileName);
        if (!logFile.exists()) {
            return;
        }
        List lines = Files.lines(logFile.toPath(), Charset.defaultCharset()).filter(line -> PATTERN.matcher((CharSequence)line).matches()).collect(Collectors.toList());
        if (lines.size() > 0) {
            throw new IllegalStateException("OutOfMemoryError detected in '" + logFileName + "': " + Arrays.toString(lines.toArray()));
        }
    }

    static void dumpHeap(String fileName, boolean live) throws InvocationTargetException, IllegalAccessException, ClassNotFoundException, NoSuchMethodException, IOException {
        MemoryLeakUtils.conditionallyInitHotSpotDiagnosticMXBean();
        try {
            Files.deleteIfExists(Paths.get(fileName, new String[0]));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        dumpHeapMethod.invoke(hotSpotDiagnosticMBean, fileName, live);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void conditionallyInitHotSpotDiagnosticMXBean() throws IOException, ClassNotFoundException, NoSuchMethodException {
        if (hotSpotDiagnosticMBean != null) return;
        Class<MemoryLeakUtils> clazz = MemoryLeakUtils.class;
        synchronized (MemoryLeakUtils.class) {
            if (hotSpotDiagnosticMBean != null) return;
            Class<?> clazz2 = Class.forName(HOT_SPOT_DIAGNOSTIC_MXBEAN_CLASSNAME);
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            hotSpotDiagnosticMBean = ManagementFactory.newPlatformMXBeanProxy(server, HOTSPOT_BEAN_NAME, clazz2);
            dumpHeapMethod = clazz2.getMethod("dumpHeap", String.class, Boolean.TYPE);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

