/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.client.oauth2;

import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;

@Priority(value=1000)
class OAuth2ClientFilter
implements ClientRequestFilter {
    private final String accessToken;

    public OAuth2ClientFilter(String accessToken) {
        this.accessToken = accessToken;
    }

    public OAuth2ClientFilter() {
        this.accessToken = null;
    }

    public void filter(ClientRequestContext request) throws IOException {
        String token = this.accessToken;
        String propertyToken = (String)request.getProperty("jersey.config.client.oauth2.access.token");
        if (propertyToken != null) {
            token = propertyToken;
        }
        request.removeProperty("jersey.config.client.oauth2.access.token");
        if (token == null) {
            return;
        }
        String authentication = "Bearer " + token;
        if (!request.getHeaders().containsKey((Object)"Authorization")) {
            request.getHeaders().add((Object)"Authorization", (Object)authentication);
        }
    }
}

