/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.oauth1;

import java.security.Principal;
import javax.ws.rs.core.SecurityContext;
import org.glassfish.jersey.server.oauth1.OAuth1Consumer;
import org.glassfish.jersey.server.oauth1.OAuth1Token;

class OAuth1SecurityContext
implements SecurityContext {
    private final OAuth1Consumer consumer;
    private final OAuth1Token token;
    private final boolean isSecure;

    public OAuth1SecurityContext(OAuth1Consumer consumer, boolean isSecure) {
        this.consumer = consumer;
        this.token = null;
        this.isSecure = isSecure;
    }

    public OAuth1SecurityContext(OAuth1Token token, boolean isSecure) {
        this.consumer = null;
        this.token = token;
        this.isSecure = isSecure;
    }

    public Principal getUserPrincipal() {
        return this.consumer == null ? this.token.getPrincipal() : this.consumer.getPrincipal();
    }

    public boolean isUserInRole(String string) {
        return this.consumer == null ? this.token.isInRole(string) : this.consumer.isInRole(string);
    }

    public boolean isSecure() {
        return this.isSecure;
    }

    public String getAuthenticationScheme() {
        return "OAuth";
    }
}

