/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.opentracing;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class OpenTracingUtils {
    private OpenTracingUtils() {
    }

    public static Optional<Span> getRequestSpan(ContainerRequestContext context) {
        Object spanProperty;
        if (context != null && (spanProperty = context.getProperty("span")) != null && spanProperty instanceof Span) {
            return Optional.of((Span)spanProperty);
        }
        return Optional.empty();
    }

    public static Span getRequestChildSpan(ContainerRequestContext context) {
        return OpenTracingUtils.getRequestChildSpan(context, "jersey-resource-app");
    }

    public static Span getRequestChildSpan(ContainerRequestContext context, String spanName) {
        Object spanProperty;
        Tracer.SpanBuilder spanBuilder = GlobalTracer.get().buildSpan(spanName);
        if (context != null && (spanProperty = context.getProperty("span")) != null && spanProperty instanceof Span) {
            spanBuilder = spanBuilder.asChildOf((Span)spanProperty);
        }
        return spanBuilder.start();
    }

    static String headersAsString(MultivaluedMap<String, ?> headers) {
        return headers.entrySet().stream().map(entry -> "[" + (String)entry.getKey() + "=" + ((List)entry.getValue()).stream().map(Object::toString).collect(Collectors.joining(", ")) + "]").collect(Collectors.joining("; "));
    }

    static String formatList(List<?> list) {
        return list.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    static String formatProviders(Iterable<?> providers) {
        return StreamSupport.stream(providers.spliterator(), false).map(provider -> provider.getClass().getName()).collect(Collectors.joining(", "));
    }
}

